/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.as.itests;

import java.util.Collection;
import java.util.HashMap;
import junit.framework.TestCase;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.jdt.core.IClasspathEntry;
import org.eclipse.wst.server.core.IRuntime;
import org.eclipse.wst.server.core.IServer;
import org.jboss.ide.eclipse.as.classpath.core.ejb3.EJB30SupportVerifier;
import org.jboss.ide.eclipse.as.classpath.core.ejb3.EJB3ClasspathContainer;
import org.jboss.tools.as.test.core.internal.utils.ServerCreationTestUtils;
import org.jboss.tools.as.test.core.parametized.server.ServerParameterUtils;
import org.junit.After;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;

@RunWith(value=Parameterized.class)
public class EJB3SupportVerifierTest
extends TestCase {
    private String serverType;
    private IServer server;
    private static HashMap<String, Boolean> expected = new HashMap();

    static {
        expected.put("org.jboss.ide.eclipse.as.systemCopyServer", false);
        expected.put("org.jboss.ide.eclipse.as.32", false);
        expected.put("org.jboss.ide.eclipse.as.40", false);
        expected.put("org.jboss.ide.eclipse.as.42", true);
        expected.put("org.jboss.ide.eclipse.as.50", true);
        expected.put("org.jboss.ide.eclipse.as.51", true);
        expected.put("org.jboss.ide.eclipse.as.60", true);
        expected.put("org.jboss.ide.eclipse.as.70", true);
        expected.put("org.jboss.ide.eclipse.as.71", true);
        expected.put("org.jboss.ide.eclipse.as.wildfly.80", true);
        expected.put("org.jboss.ide.eclipse.as.wildfly.90", true);
        expected.put("org.jboss.ide.eclipse.as.wildfly.100", true);
        expected.put("org.jboss.ide.eclipse.as.eap.43", true);
        expected.put("org.jboss.ide.eclipse.as.eap.50", true);
        expected.put("org.jboss.ide.eclipse.as.eap.60", true);
        expected.put("org.jboss.ide.eclipse.as.eap.61", true);
        expected.put("org.jboss.ide.eclipse.as.eap.70", true);
    }

    @Parameterized.Parameters
    public static Collection<Object[]> data() {
        return ServerParameterUtils.asCollection((Object[])ServerParameterUtils.getAllJBossServerTypeParamterers());
    }

    public EJB3SupportVerifierTest(String serverType) {
        this.serverType = serverType;
    }

    @Before
    public void setUp() throws CoreException {
        this.server = ServerCreationTestUtils.createServerWithRuntime((String)this.serverType, (String)(String.valueOf(((Object)((Object)this)).getClass().getName()) + this.serverType));
    }

    @After
    public void tearDown() throws Exception {
        ServerCreationTestUtils.deleteAllServersAndRuntimes();
    }

    @Test
    public void testEJB30Support() {
        if (expected.get(this.serverType) == null) {
            EJB3SupportVerifierTest.fail((String)"Test needs to be updated for new server type");
        }
        boolean supported = EJB30SupportVerifier.verify((IRuntime)this.server.getRuntime());
        EJB3SupportVerifierTest.assertEquals((Object)new Boolean(supported), (Object)new Boolean(expected.get(this.serverType)));
        IPath containerPath = new Path("org.jboss.ide.eclipse.as.classpath.core.ejb3.classpathContainer").append(this.server.getName());
        EJB3ClasspathContainer container = new EJB3ClasspathContainer(containerPath, null);
        IClasspathEntry[] entries = container.getClasspathEntries();
        if (supported) {
            EJB3SupportVerifierTest.assertTrue((String)("server type " + this.serverType + " supports ejb3 but receives no jars from this classpath container"), (entries != null && entries.length > 0 ? 1 : 0) != 0);
        } else {
            EJB3SupportVerifierTest.assertTrue((entries != null && entries.length == 0 ? 1 : 0) != 0);
        }
    }
}

