/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.as.itests.server.publishing;

import java.io.IOException;
import java.util.Collection;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.wst.common.frameworks.datamodel.IDataModel;
import org.eclipse.wst.common.project.facet.core.IProjectFacetVersion;
import org.eclipse.wst.server.core.IModule;
import org.eclipse.wst.server.core.IServer;
import org.eclipse.wst.server.core.model.IModuleFile;
import org.jboss.ide.eclipse.as.core.modules.SingleDeployableFactory;
import org.jboss.tools.as.test.core.internal.utils.MatrixUtils;
import org.jboss.tools.as.test.core.internal.utils.ResourceUtils;
import org.jboss.tools.as.test.core.internal.utils.wtp.CreateProjectOperationsUtility;
import org.jboss.tools.as.test.core.internal.utils.wtp.JavaEEFacetConstants;
import org.jboss.tools.as.test.core.internal.utils.wtp.OperationTestCase;
import org.jboss.tools.as.test.core.parametized.server.ServerParameterUtils;
import org.jboss.tools.as.test.core.parametized.server.publishing.AbstractPublishingTest;
import org.jboss.tools.test.util.JobUtils;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;

@RunWith(value=Parameterized.class)
public class SingleDeployableFileTest
extends AbstractPublishingTest {
    public static final String PROJECT_ROOT_NAME = "SingleDeployableTest";
    public static int count = 0;
    private String projectName;

    @Parameterized.Parameters
    public static Collection<Object[]> params() {
        String[] servers = ServerParameterUtils.getPublishServerTypes();
        String[] zipOption = ServerParameterUtils.getServerZipOptions();
        Object[][] allOptions = new Object[][]{servers, zipOption, {"metadata"}, {"permod_default"}};
        return MatrixUtils.toMatrix((Object[][])allOptions);
    }

    public SingleDeployableFileTest(String serverType, String zip, String deployLoc, String perMod) {
        super(serverType, zip, deployLoc, perMod);
    }

    protected void createProjects() throws Exception {
        this.projectName = PROJECT_ROOT_NAME + count;
        ++count;
        IDataModel dm = CreateProjectOperationsUtility.getEARDataModel((String)this.projectName, (String)"earContent", null, null, (IProjectFacetVersion)JavaEEFacetConstants.EAR_5, (boolean)false);
        OperationTestCase.runAndVerify((IDataModel)dm);
        IProject p = ResourcesPlugin.getWorkspace().getRoot().getProject(this.projectName);
        SingleDeployableFileTest.assertTrue((boolean)p.exists());
        IFile file = ResourceUtils.createFile((IProject)p, (String)"test.xml", (String)"<test>done</test>");
        IModule[] mods = SingleDeployableFactory.getFactory().getModules();
        SingleDeployableFileTest.assertEquals((int)mods.length, (int)0);
        SingleDeployableFactory.makeDeployable((IResource)file);
        mods = SingleDeployableFactory.getFactory().getModules();
        SingleDeployableFileTest.assertEquals((int)mods.length, (int)1);
        this.addModuleToServer(mods[0]);
    }

    @Test
    public void testSingleDeployableFullPublish() throws IOException, CoreException {
        IProject p = ResourcesPlugin.getWorkspace().getRoot().getProject(this.projectName);
        this.fullPublishAndVerify(2, "<test>done</test>");
        ResourceUtils.setContents((IProject)p, (IPath)new Path("test.xml"), (String)"2");
        JobUtils.waitForIdle();
        this.fullPublishAndVerify(1, "2");
        ResourceUtils.setContents((IProject)p, (IPath)new Path("test.xml"), (String)"3");
        JobUtils.waitForIdle();
        this.fullPublishAndVerify(1, "3");
    }

    private void fullPublishAndVerify(int publishType, String expectedContents) throws CoreException, IOException {
        int[] nArray;
        boolean isFullPublish;
        SingleDeployableFileTest.publishAndCheckError((IServer)this.server, (int)publishType);
        boolean bl = isFullPublish = publishType == 2;
        if (isFullPublish) {
            int[] nArray2 = new int[2];
            nArray = nArray2;
            nArray2[0] = 2;
        } else {
            int[] nArray3 = new int[2];
            nArray = nArray3;
            nArray3[0] = 2;
        }
        int[] vals = nArray;
        vals[0] = vals[0] + this.getFullPublishChangedResourceCountModifier();
        vals[1] = vals[1] + this.getFullPublishRemovedResourceCountModifier();
        this.verifyPublishMethodResults(vals[0], vals[1]);
    }

    private IModuleFile findBinaryModuleFile(IModuleFile[] files, String name) {
        int i = 0;
        while (i < files.length) {
            if (files[i].getName().equals(name)) {
                return files[i];
            }
            ++i;
        }
        return null;
    }
}

