/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.jmx.ui.internal.adapters;

import org.eclipse.core.runtime.IAdapterFactory;
import org.eclipse.ui.views.properties.IPropertySource;
import org.jboss.tools.jmx.core.DomainWrapper;
import org.jboss.tools.jmx.core.MBeanAttributeInfoWrapper;
import org.jboss.tools.jmx.core.MBeanInfoWrapper;
import org.jboss.tools.jmx.core.MBeanOperationInfoWrapper;
import org.jboss.tools.jmx.core.tree.ObjectNameNode;
import org.jboss.tools.jmx.ui.internal.adapters.DomainPropertySourceAdapter;
import org.jboss.tools.jmx.ui.internal.adapters.MBeanAttributeInfoPropertySourceAdapter;
import org.jboss.tools.jmx.ui.internal.adapters.MBeanInfoPropertySourceAdapter;
import org.jboss.tools.jmx.ui.internal.adapters.MBeanOperationInfoPropertySourceAdapter;
import org.jboss.tools.jmx.ui.internal.adapters.ObjectNameNodePropertySourceAdapter;

public class JMXAdapterFactory
implements IAdapterFactory {
    private Class<?>[] adapterClasses = new Class[]{DomainWrapper.class, MBeanInfoWrapper.class, MBeanAttributeInfoWrapper.class, MBeanOperationInfoWrapper.class, ObjectNameNode.class};

    public Class[] getAdapterList() {
        return new Class[]{IPropertySource.class};
    }

    public Object getAdapter(Object adaptableObject, Class adapterType) {
        if (adapterType == IPropertySource.class) {
            return this.adaptToPropertySource(adaptableObject);
        }
        return null;
    }

    private IPropertySource adaptToPropertySource(Object adaptableObject) {
        if (adaptableObject instanceof DomainWrapper) {
            DomainWrapper domain = (DomainWrapper)adaptableObject;
            return new DomainPropertySourceAdapter(domain.getName());
        }
        if (adaptableObject instanceof MBeanInfoWrapper) {
            MBeanInfoWrapper wrapper = (MBeanInfoWrapper)adaptableObject;
            return new MBeanInfoPropertySourceAdapter(wrapper.getObjectName(), wrapper.getMBeanInfo());
        }
        if (adaptableObject instanceof MBeanAttributeInfoWrapper) {
            MBeanAttributeInfoWrapper wrapper = (MBeanAttributeInfoWrapper)adaptableObject;
            return new MBeanAttributeInfoPropertySourceAdapter(wrapper.getMBeanAttributeInfo(), wrapper.getObjectName(), wrapper.getConnection());
        }
        if (adaptableObject instanceof MBeanOperationInfoWrapper) {
            MBeanOperationInfoWrapper wrapper = (MBeanOperationInfoWrapper)adaptableObject;
            return new MBeanOperationInfoPropertySourceAdapter(wrapper.getMBeanOperationInfo());
        }
        if (adaptableObject instanceof ObjectNameNode) {
            ObjectNameNode objectName = (ObjectNameNode)adaptableObject;
            return new ObjectNameNodePropertySourceAdapter(objectName);
        }
        return null;
    }

    public Class<?>[] getAdapterClasses() {
        return this.adapterClasses;
    }
}

