/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.jmx.ui.internal.adapters;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import javax.management.MBeanAttributeInfo;
import javax.management.MBeanServerConnection;
import javax.management.ObjectName;
import org.eclipse.core.runtime.Assert;
import org.eclipse.osgi.util.NLS;
import org.eclipse.ui.views.properties.IPropertyDescriptor;
import org.eclipse.ui.views.properties.IPropertySource;
import org.eclipse.ui.views.properties.PropertyDescriptor;
import org.jboss.tools.jmx.core.IConnectionWrapper;
import org.jboss.tools.jmx.core.IJMXRunnable;
import org.jboss.tools.jmx.ui.JMXUIActivator;
import org.jboss.tools.jmx.ui.Messages;

public class MBeanAttributeInfoPropertySourceAdapter
implements IPropertySource {
    private final MBeanAttributeInfo attrInfo;
    private final ObjectName on;
    private final MBeanServerConnection mbsc;
    private final IConnectionWrapper conn;

    public MBeanAttributeInfoPropertySourceAdapter(MBeanAttributeInfo attrInfo, ObjectName on, MBeanServerConnection mbsc) {
        Assert.isNotNull((Object)attrInfo);
        Assert.isNotNull((Object)on);
        Assert.isNotNull((Object)mbsc);
        this.attrInfo = attrInfo;
        this.on = on;
        this.mbsc = mbsc;
        this.conn = null;
    }

    public MBeanAttributeInfoPropertySourceAdapter(MBeanAttributeInfo attrInfo, ObjectName on, IConnectionWrapper conn) {
        Assert.isNotNull((Object)attrInfo);
        Assert.isNotNull((Object)on);
        Assert.isNotNull((Object)conn);
        this.attrInfo = attrInfo;
        this.on = on;
        this.conn = conn;
        this.mbsc = null;
    }

    public Object getEditableValue() {
        return null;
    }

    public IPropertyDescriptor[] getPropertyDescriptors() {
        ArrayList<PropertyDescriptor> descriptors = new ArrayList<PropertyDescriptor>();
        this.addDescriptor("name", Messages.name, Messages.general, descriptors);
        this.addDescriptor("description", Messages.description, Messages.general, descriptors);
        this.addDescriptor("type", Messages.type, Messages.general, descriptors);
        this.addDescriptor("readable", Messages.readable, Messages.general, descriptors);
        this.addDescriptor("writable", Messages.writable, Messages.general, descriptors);
        this.addDescriptor("value", Messages.value, Messages.general, descriptors);
        return descriptors.toArray(new IPropertyDescriptor[descriptors.size()]);
    }

    private void addDescriptor(String id, String displayName, String category, List<PropertyDescriptor> descriptors) {
        PropertyDescriptor descriptor = new PropertyDescriptor((Object)id, displayName);
        descriptor.setCategory(category);
        descriptors.add(descriptor);
    }

    public Object getPropertyValue(Object id) {
        if ("name".equals(id)) {
            return this.attrInfo.getName();
        }
        if ("description".equals(id)) {
            return this.attrInfo.getDescription();
        }
        if ("type".equals(id)) {
            String obj = this.attrInfo.getType();
            if (obj instanceof Object[]) {
                return Arrays.asList((Object[])obj).toString();
            }
            return obj;
        }
        if ("readable".equals(id)) {
            return this.attrInfo.isReadable();
        }
        if ("writable".equals(id)) {
            return this.attrInfo.isWritable();
        }
        if ("value".equals(id)) {
            try {
                if (this.mbsc != null) {
                    Object obj = this.mbsc.getAttribute(this.on, this.attrInfo.getName());
                    if (obj instanceof Object[]) {
                        return Arrays.asList((Object[])obj).toString();
                    }
                    return obj;
                }
                this.conn.run(new IJMXRunnable(){
                    final Object[] ret = new Object[1];

                    public void run(MBeanServerConnection connection) throws Exception {
                        Object obj = connection.getAttribute(MBeanAttributeInfoPropertySourceAdapter.this.on, MBeanAttributeInfoPropertySourceAdapter.this.attrInfo.getName());
                        if (obj instanceof Object[]) {
                            this.ret[0] = Arrays.asList((Object[])obj).toString();
                        }
                        this.ret[0] = obj;
                    }
                });
            }
            catch (Exception e) {
                JMXUIActivator.log(2, NLS.bind((String)Messages.MBeanAttributeValue_Warning, (Object)this.attrInfo.getName()), e);
                return null;
            }
        }
        return null;
    }

    public boolean isPropertySet(Object id) {
        return false;
    }

    public void resetPropertyValue(Object id) {
    }

    public void setPropertyValue(Object id, Object value) {
    }
}

