/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.ide.eclipse.archives.core.model.internal;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Set;
import org.jboss.ide.eclipse.archives.core.ArchivesCore;
import org.jboss.ide.eclipse.archives.core.model.ArchivesModelException;
import org.jboss.ide.eclipse.archives.core.model.IArchiveNode;
import org.jboss.ide.eclipse.archives.core.model.IArchiveNodeDelta;
import org.jboss.ide.eclipse.archives.core.model.internal.ArchiveNodeImpl;

public class ArchiveNodeDeltaImpl
implements IArchiveNodeDelta {
    private IArchiveNodeDelta parentDelta;
    private IArchiveNode postNode;
    private IArchiveNode preNode;
    private HashMap attributes;
    private HashMap properties;
    private HashMap children;
    private int kind;
    private IArchiveNodeDelta[] childrenDeltas;
    private HashMap deltaMap = new HashMap();

    public ArchiveNodeDeltaImpl(IArchiveNodeDelta parentDelta, ArchiveNodeImpl impl, HashMap attributeChanges, HashMap propertyChanges, HashMap childChanges) {
        this.parentDelta = parentDelta;
        this.postNode = impl;
        this.kind = 0;
        this.properties = propertyChanges;
        this.attributes = attributeChanges;
        this.children = childChanges;
        this.ensureAccurateKind();
        this.preNode = ArchivesCore.getInstance().getNodeFactory().createDeltaNode(parentDelta, this.postNode, attributeChanges, propertyChanges);
        this.loadAllAffectedChildren();
    }

    public ArchiveNodeDeltaImpl(IArchiveNodeDelta parentDelta, ArchiveNodeImpl impl, int forcedKind, HashMap attributeChanges, HashMap propertyChanges, HashMap childChanges) {
        this(parentDelta, impl, attributeChanges, propertyChanges, childChanges);
        this.kind |= forcedKind;
        if ((this.kind & 1) == 1) {
            this.preNode = null;
            this.kind = 1;
            this.attributes.clear();
            this.properties.clear();
        }
    }

    protected IArchiveNodeDelta getParentDelta() {
        return this.parentDelta;
    }

    protected void ensureAccurateKind() {
        for (Object key : this.properties.keySet()) {
            NodeDelta val = (NodeDelta)this.properties.get(key);
            this.kind |= val.getKind();
        }
        if (this.attributes.keySet().size() > 0) {
            this.kind |= 0x80;
        }
        for (Object key : this.children.keySet()) {
            Integer val2 = (Integer)this.children.get(key);
            if (val2 == null) continue;
            this.kind |= val2.intValue();
        }
    }

    public IArchiveNodeDelta[] getAllAffectedChildren() {
        if (this.childrenDeltas == null) {
            this.loadAllAffectedChildren();
        }
        return this.childrenDeltas;
    }

    private void loadAllAffectedChildren() {
        IArchiveNodeDelta delta;
        ArrayList<IArchiveNode> priorChildren = new ArrayList<IArchiveNode>();
        IArchiveNode[] children = this.postNode.getAllChildren();
        ArrayList<IArchiveNodeDelta> deltas = new ArrayList<IArchiveNodeDelta>();
        int i = 0;
        while (i < children.length) {
            delta = this.getDelta(children[i]);
            if (delta.getKind() != 0) {
                deltas.add(delta);
                if ((delta.getKind() & 1) == 0 && (delta.getKind() & 2) == 0) {
                    this.kind |= 0x400;
                }
            }
            priorChildren.add(delta.getPreNode());
            ++i;
        }
        for (ArchiveNodeImpl node : this.children.keySet()) {
            int v = (Integer)this.children.get(node);
            if (v == 512) {
                delta = this.getDelta(node);
                deltas.add(delta);
                priorChildren.add(delta.getPreNode());
                continue;
            }
            if (v != 256) continue;
            delta = this.getDelta(node);
            priorChildren.remove(delta.getPreNode());
        }
        if (this.preNode != null) {
            Iterator<Object> i2 = priorChildren.iterator();
            while (i2.hasNext()) {
                try {
                    this.preNode.addChild((IArchiveNode)i2.next());
                }
                catch (ArchivesModelException archivesModelException) {}
            }
            this.preNode.clearDelta();
        }
        this.childrenDeltas = deltas.toArray(new IArchiveNodeDelta[deltas.size()]);
    }

    private IArchiveNodeDelta getDelta(IArchiveNode child) {
        if (!this.deltaMap.containsKey(child)) {
            this.deltaMap.put(child, this.loadDelta(child));
        }
        return (IArchiveNodeDelta)this.deltaMap.get(child);
    }

    private IArchiveNodeDelta loadDelta(IArchiveNode child) {
        if (child instanceof ArchiveNodeImpl) {
            int addedOrRemoved = 0;
            if (this.children.containsKey(child)) {
                addedOrRemoved = (Integer)this.children.get(child) >> 8;
            }
            ArchiveNodeImpl impl = (ArchiveNodeImpl)child;
            return new ArchiveNodeDeltaImpl(this, impl, addedOrRemoved, impl.getAttributeChanges(), impl.getPropertyChanges(), impl.getChildChanges());
        }
        return child.getDelta();
    }

    public int getKind() {
        return this.kind;
    }

    public IArchiveNode getPostNode() {
        return this.postNode;
    }

    public IArchiveNode getPreNode() {
        return this.preNode;
    }

    public String[] getAttributesWithDeltas() {
        Set atts = this.attributes.keySet();
        return atts.toArray(new String[atts.size()]);
    }

    public IArchiveNodeDelta.INodeDelta getAttributeDelta(String key) {
        return (IArchiveNodeDelta.INodeDelta)this.attributes.get(key);
    }

    public String[] getPropertiesWithDeltas() {
        Set atts = this.properties.keySet();
        return atts.toArray(new String[atts.size()]);
    }

    public IArchiveNodeDelta.INodeDelta getPropertyDelta(String key) {
        return (IArchiveNodeDelta.INodeDelta)this.properties.get(key);
    }

    public IArchiveNodeDelta[] getAddedChildrenDeltas() {
        return this.getChangedChildren(1);
    }

    public IArchiveNodeDelta[] getRemovedChildrenDeltas() {
        return this.getChangedChildren(2);
    }

    public IArchiveNodeDelta[] getChangedDescendentDeltas() {
        return this.getChangedChildren(1024);
    }

    private IArchiveNodeDelta[] getChangedChildren(int type) {
        ArrayList<IArchiveNodeDelta> list = new ArrayList<IArchiveNodeDelta>();
        int i = 0;
        while (i < this.childrenDeltas.length) {
            if ((this.childrenDeltas[i].getKind() & type) != 0) {
                list.add(this.childrenDeltas[i]);
            }
            ++i;
        }
        return list.toArray(new IArchiveNodeDelta[list.size()]);
    }

    protected static class NodeDelta
    implements IArchiveNodeDelta.INodeDelta {
        private int kind;
        private Object before;
        private Object after;

        public NodeDelta(Object before, Object after, int kind) {
            this.before = before;
            this.after = after;
            this.kind = kind;
        }

        public Object getBefore() {
            return this.before;
        }

        public Object getAfter() {
            return this.after;
        }

        public int getKind() {
            return this.kind;
        }
    }
}

