/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.wtp.server.launchbar;

import org.eclipse.core.runtime.CoreException;
import org.eclipse.debug.core.DebugPlugin;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.debug.core.ILaunchConfigurationType;
import org.eclipse.debug.core.ILaunchConfigurationWorkingCopy;
import org.eclipse.launchbar.core.ILaunchConfigurationProvider;
import org.eclipse.launchbar.core.ILaunchDescriptor;
import org.eclipse.launchbar.core.target.ILaunchTarget;
import org.jboss.tools.wtp.server.launchbar.descriptors.ModuleArtifactDetailsLaunchDescriptor;
import org.jboss.tools.wtp.server.launchbar.descriptors.ModuleArtifactLaunchDescriptor;
import org.jboss.tools.wtp.server.launchbar.descriptors.ModuleLaunchDescriptor;

public class ModuleLaunchConfigurationProvider
implements ILaunchConfigurationProvider {
    protected static final char[] INVALID_CHARS;

    static {
        char[] cArray = new char[12];
        cArray[0] = 47;
        cArray[1] = 92;
        cArray[2] = 58;
        cArray[3] = 42;
        cArray[4] = 63;
        cArray[5] = 34;
        cArray[6] = 60;
        cArray[7] = 62;
        cArray[8] = 124;
        cArray[10] = 64;
        cArray[11] = 38;
        INVALID_CHARS = cArray;
    }

    protected String getValidLaunchConfigurationName(String s) {
        if (s == null || s.length() == 0) {
            return "1";
        }
        int size = INVALID_CHARS.length;
        int i = 0;
        while (i < size) {
            s = s.replace(INVALID_CHARS[i], '_');
            ++i;
        }
        return s;
    }

    public boolean supports(ILaunchDescriptor descriptor, ILaunchTarget target) throws CoreException {
        return target.getTypeId().equals("org.eclipse.launchbar.core.launchTargetType.wst.server");
    }

    public ILaunchConfigurationType getLaunchConfigurationType(ILaunchDescriptor descriptor, ILaunchTarget target) throws CoreException {
        return DebugPlugin.getDefault().getLaunchManager().getLaunchConfigurationType("org.jboss.tools.wtp.server.launchbar.serverAdapterLaunch");
    }

    public ILaunchConfiguration getLaunchConfiguration(ILaunchDescriptor descriptor, ILaunchTarget target) throws CoreException {
        ILaunchConfigurationType type = this.getLaunchConfigurationType(descriptor, target);
        String descriptorName = descriptor.getName();
        String validName = this.getValidLaunchConfigurationName(descriptorName);
        ILaunchConfigurationWorkingCopy wc = type.newInstance(null, validName);
        if (descriptor instanceof ModuleLaunchDescriptor) {
            wc.setAttribute("wst.launchbar.launchtype", "module");
            wc.setAttribute("my.projectname", ((ModuleLaunchDescriptor)descriptor).getModule().getProject().getName());
            wc.setAttribute("target.name", target.getName());
            return wc;
        }
        if (descriptor instanceof ModuleArtifactDetailsLaunchDescriptor) {
            wc.setAttribute("wst.launchbar.launchtype", "artifact");
            wc.setAttribute("artifactString", ((ModuleArtifactDetailsLaunchDescriptor)descriptor).getArtifactWrapper().getArtifactString());
            wc.setAttribute("artifactClass", ((ModuleArtifactDetailsLaunchDescriptor)descriptor).getArtifactWrapper().getArtifactClass());
            wc.setAttribute("target.name", target.getName());
        }
        if (descriptor instanceof ModuleArtifactLaunchDescriptor) {
            wc.setAttribute("wst.launchbar.launchtype", "artifact");
            wc.setAttribute("artifactString", ((ModuleArtifactLaunchDescriptor)descriptor).getArtifactWrapper().getArtifactString());
            wc.setAttribute("artifactClass", ((ModuleArtifactLaunchDescriptor)descriptor).getArtifactWrapper().getArtifactClass());
            wc.setAttribute("target.name", target.getName());
        }
        wc.setAttribute("org.eclipse.debug.ui.private", true);
        return wc.doSave();
    }

    public void launchDescriptorRemoved(ILaunchDescriptor descriptor) throws CoreException {
    }

    public boolean launchConfigurationRemoved(ILaunchConfiguration configuration) throws CoreException {
        return false;
    }

    public boolean launchConfigurationAdded(ILaunchConfiguration configuration) throws CoreException {
        return false;
    }

    public boolean launchConfigurationChanged(ILaunchConfiguration configuration) throws CoreException {
        return false;
    }

    public void launchTargetRemoved(ILaunchTarget target) throws CoreException {
    }

    public boolean launchDescriptorMatches(ILaunchDescriptor descriptor, ILaunchConfiguration configuration, ILaunchTarget target) throws CoreException {
        return this.getLaunchConfiguration(descriptor, target).equals(configuration);
    }
}

