/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.wtp.server.launchbar;

import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.debug.core.ILaunch;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.debug.core.model.ILaunchConfigurationDelegate;
import org.eclipse.debug.core.model.IProcess;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.swt.widgets.Display;
import org.eclipse.wst.server.core.IModuleArtifact;
import org.eclipse.wst.server.core.IServer;
import org.eclipse.wst.server.core.ServerCore;
import org.eclipse.wst.server.core.model.ModuleArtifactDelegate;
import org.eclipse.wst.server.ui.internal.Trace;
import org.eclipse.wst.server.ui.internal.actions.RunOnServerProcess;
import org.jboss.tools.wtp.server.launchbar.launch.DeclaredArtifactRunOnServerActionDelegate;
import org.jboss.tools.wtp.server.launchbar.launch.DeclaredServerRunOnServerActionDelegate;
import org.jboss.tools.wtp.server.launchbar.objects.LaunchedArtifacts;
import org.jboss.tools.wtp.server.launchbar.objects.ModuleArtifactDetailsWrapper;

public class ServerLaunchBarDelegate
implements ILaunchConfigurationDelegate {
    public static final String ATTR_LAUNCH_TYPE = "wst.launchbar.launchtype";
    public static final String ATTR_LAUNCH_TYPE_MODULE = "module";
    public static final String ATTR_LAUNCH_TYPE_ARTIFACT = "artifact";
    public static final String ATTR_ARTIFACT_STRING = "artifactString";
    public static final String ATTR_ARTIFACT_CLASS = "artifactClass";
    public static final String ATTR_PROJECT = "my.projectname";
    public static final String ATTR_TARGET_NAME = "target.name";

    public void launch(ILaunchConfiguration configuration, String mode, ILaunch launch, IProgressMonitor monitor) throws CoreException {
        RunOnServerProcess dummyProcess = new RunOnServerProcess(launch);
        launch.addProcess((IProcess)dummyProcess);
        IServer s = this.findServer(configuration);
        String launchType = configuration.getAttribute(ATTR_LAUNCH_TYPE, null);
        if (ATTR_LAUNCH_TYPE_MODULE.equals(launchType)) {
            this.launchModule(s, configuration);
        } else if (ATTR_LAUNCH_TYPE_ARTIFACT.equals(launchType)) {
            this.launchArtifact(s, configuration);
        }
        dummyProcess.terminate();
        launch.terminate();
    }

    private IServer findServer(ILaunchConfiguration config) throws CoreException {
        String name = config.getAttribute(ATTR_TARGET_NAME, null);
        if (name != null) {
            IServer[] iServerArray = ServerCore.getServers();
            int n = iServerArray.length;
            int n2 = 0;
            while (n2 < n) {
                IServer s = iServerArray[n2];
                if (s.getId().equals(name) || s.getName().equals(name)) {
                    return s;
                }
                ++n2;
            }
        }
        return null;
    }

    private void launchModule(IServer server, ILaunchConfiguration configuration) throws CoreException {
        IServer s2 = server;
        if (s2 != null) {
            final DeclaredServerRunOnServerActionDelegate action = new DeclaredServerRunOnServerActionDelegate(s2);
            Action dummyAction = new Action(){};
            String projectName = configuration.getAttribute(ATTR_PROJECT, null);
            if (projectName != null) {
                IProject p = ResourcesPlugin.getWorkspace().getRoot().getProject(projectName);
                StructuredSelection sel = new StructuredSelection((Object)p);
                Display.getDefault().asyncExec(new Runnable((IAction)dummyAction, (IStructuredSelection)sel){
                    private final /* synthetic */ IAction val$dummyAction;
                    private final /* synthetic */ IStructuredSelection val$sel;
                    {
                        this.val$dummyAction = iAction;
                        this.val$sel = iStructuredSelection;
                    }

                    @Override
                    public void run() {
                        action.selectionChanged(this.val$dummyAction, (ISelection)this.val$sel);
                        action.run(this.val$dummyAction);
                    }
                });
            }
        }
    }

    private void launchArtifact(IServer server, ILaunchConfiguration configuration) throws CoreException {
        IServer s2 = server;
        if (s2 != null) {
            String clazz = configuration.getAttribute(ATTR_ARTIFACT_CLASS, null);
            String serial = configuration.getAttribute(ATTR_ARTIFACT_STRING, null);
            ModuleArtifactDelegate artifact = ServerLaunchBarDelegate.getArtifact(clazz, serial);
            this.markLaunched(configuration.getName(), clazz, serial);
            IModuleArtifact[] art = new IModuleArtifact[]{artifact};
            final DeclaredArtifactRunOnServerActionDelegate action = new DeclaredArtifactRunOnServerActionDelegate(s2, art);
            Action dummyAction = new Action(){};
            Display.getDefault().asyncExec(new Runnable((IAction)dummyAction){
                private final /* synthetic */ IAction val$dummyAction;
                {
                    this.val$dummyAction = iAction;
                }

                @Override
                public void run() {
                    action.selectionChanged(this.val$dummyAction, (ISelection)new StructuredSelection());
                    action.run(this.val$dummyAction);
                }
            });
        }
    }

    private void markLaunched(String name, String clazz, String serial) {
        ModuleArtifactDetailsWrapper details = new ModuleArtifactDetailsWrapper(name, serial, clazz);
        LaunchedArtifacts.getDefault().markLaunched(details);
    }

    public static ModuleArtifactDelegate getArtifact(String clazz, String str) {
        ModuleArtifactDelegate moduleArtifact = null;
        try {
            Class<?> c = Class.forName(clazz);
            moduleArtifact = (ModuleArtifactDelegate)c.newInstance();
            moduleArtifact.deserialize(str);
            return moduleArtifact;
        }
        catch (Throwable throwable) {
            if (Trace.WARNING) {
                Trace.trace((String)"/warning", (String)"Could not load module artifact delegate class");
            }
            return null;
        }
    }
}

