/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.wtp.server.launchbar.launch;

import org.eclipse.core.resources.IFolder;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Status;
import org.eclipse.debug.core.DebugPlugin;
import org.eclipse.debug.core.IBreakpointManager;
import org.eclipse.debug.core.ILaunch;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.jface.wizard.IWizard;
import org.eclipse.jface.wizard.WizardDialog;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.wst.server.core.IModule;
import org.eclipse.wst.server.core.IModuleArtifact;
import org.eclipse.wst.server.core.IModuleType;
import org.eclipse.wst.server.core.IServer;
import org.eclipse.wst.server.core.IServerType;
import org.eclipse.wst.server.core.ServerCore;
import org.eclipse.wst.server.core.ServerUtil;
import org.eclipse.wst.server.core.internal.IClient;
import org.eclipse.wst.server.core.internal.ILaunchableAdapter;
import org.eclipse.wst.server.core.model.ModuleArtifactDelegate;
import org.eclipse.wst.server.ui.internal.EclipseUtil;
import org.eclipse.wst.server.ui.internal.LaunchClientJob;
import org.eclipse.wst.server.ui.internal.Messages;
import org.eclipse.wst.server.ui.internal.ServerUIPlugin;
import org.eclipse.wst.server.ui.internal.Trace;
import org.eclipse.wst.server.ui.internal.viewers.ModuleArtifactComposite;
import org.eclipse.wst.server.ui.internal.wizard.RunOnServerWizard;
import org.jboss.tools.wtp.server.launchbar.launch.DeclaredServerRunOnServerActionDelegate;

public class DeclaredArtifactRunOnServerActionDelegate
extends DeclaredServerRunOnServerActionDelegate {
    private IModuleArtifact[] artifact;

    public DeclaredArtifactRunOnServerActionDelegate(IServer s, IModuleArtifact[] artifact) {
        super(s);
        this.artifact = artifact;
    }

    protected void run() {
        IModuleArtifact moduleArtifact;
        IModuleArtifact[] moduleArtifacts = this.artifact;
        if (moduleArtifacts == null || moduleArtifacts.length == 0 || moduleArtifacts[0] == null) {
            EclipseUtil.openError((String)Messages.errorNoArtifact);
            if (Trace.FINEST) {
                Trace.trace((String)"/finest", (String)"No module artifact found");
            }
            return;
        }
        Shell shell2 = null;
        if (this.window != null) {
            shell2 = this.window.getShell();
        } else {
            try {
                shell2 = ServerUIPlugin.getInstance().getWorkbench().getActiveWorkbenchWindow().getShell();
            }
            catch (Exception exception) {}
            if (shell2 == null) {
                shell2 = Display.getDefault().getActiveShell();
            }
        }
        final Shell shell = shell2;
        final IAdaptable info = new IAdaptable(){

            public Object getAdapter(Class adapter) {
                if (Shell.class.equals((Object)adapter)) {
                    return shell;
                }
                if (String.class.equals((Object)adapter)) {
                    return "user";
                }
                return null;
            }
        };
        if (moduleArtifacts.length > 1) {
            ModuleArtifactComposite artifactComposite = new ModuleArtifactComposite(shell, moduleArtifacts, this.launchMode);
            if (artifactComposite.open() == 1) {
                return;
            }
            moduleArtifact = artifactComposite.getSelection();
        } else {
            moduleArtifact = moduleArtifacts[0];
        }
        if (moduleArtifact.getModule() == null) {
            EclipseUtil.openError((String)Messages.errorNoModules);
            if (Trace.FINEST) {
                Trace.trace((String)"/finest", (String)"Module artifact not contained in a module");
            }
            return;
        }
        final IModule module = moduleArtifact.getModule();
        IServer[] servers = ServerCore.getServers();
        boolean found = false;
        if (servers != null) {
            int size = servers.length;
            int i = 0;
            while (i < size && !found) {
                if (ServerUIPlugin.isCompatibleWithLaunchMode((IServer)servers[i], (String)this.launchMode)) {
                    try {
                        IModule[] parents = servers[i].getRootModules(module, null);
                        if (parents != null && parents.length > 0) {
                            found = true;
                        }
                    }
                    catch (Exception exception) {}
                }
                ++i;
            }
        }
        if (!found) {
            IServerType[] serverTypes = ServerCore.getServerTypes();
            if (serverTypes != null) {
                int size = serverTypes.length;
                int i = 0;
                while (i < size && !found) {
                    IServerType type = serverTypes[i];
                    IModuleType[] moduleTypes = type.getRuntimeType().getModuleTypes();
                    if (type.supportsLaunchMode(this.launchMode) && ServerUtil.isSupportedModule((IModuleType[])moduleTypes, (IModuleType)module.getModuleType())) {
                        found = true;
                    }
                    ++i;
                }
            }
            if (!found) {
                EclipseUtil.openError((String)Messages.errorNoServer);
                if (Trace.FINEST) {
                    Trace.trace((String)"/finest", (String)"No server for start mode");
                }
                return;
            }
        }
        if (!ServerUIPlugin.saveEditors()) {
            return;
        }
        this.tasksAndClientShown = false;
        IServer server2 = null;
        this.client = (IClient)this.getOverwriteValue(ROS_CLIENT);
        this.launchableAdapter = (ILaunchableAdapter)this.getOverwriteValue(ROS_LAUNCHABLE);
        if (Trace.FINEST) {
            Trace.trace((String)"/finest", (String)("Client and launchableAdapter after setting predefined values: launchableAdapter=" + this.launchableAdapter + " client=" + this.client));
        }
        try {
            IFolder folder;
            NullProgressMonitor monitor = new NullProgressMonitor();
            server2 = this.getServer(module, moduleArtifact, (IProgressMonitor)monitor);
            if (monitor.isCanceled()) {
                return;
            }
            if (server2 != null && (folder = server2.getServerConfiguration()) != null && folder.getProject() != null && !folder.getProject().isOpen()) {
                folder.getProject().open((IProgressMonitor)monitor);
            }
        }
        catch (CoreException ce) {
            EclipseUtil.openError((Shell)shell, (String)ce.getLocalizedMessage());
            return;
        }
        final IServer server = server2;
        if (Trace.FINEST) {
            Trace.trace((String)"/finest", (String)("Server: " + server));
        }
        if (server == null) {
            EclipseUtil.openError((String)Messages.errorNoServer);
            if (Trace.SEVERE) {
                Trace.trace((String)"/severe", (String)"No server found");
            }
            return;
        }
        if (!ServerUIPlugin.promptIfDirty((Shell)shell, (IServer)server)) {
            return;
        }
        if (!this.tasksAndClientShown) {
            RunOnServerWizard wizard = new RunOnServerWizard(server, this.launchMode, moduleArtifact, this.wiz_properties);
            if (wizard.shouldAppear()) {
                WizardDialog dialog = new WizardDialog(shell, (IWizard)wizard);
                if (dialog.open() == 1) {
                    return;
                }
            } else {
                wizard.performFinish();
            }
            if (this.client == null) {
                this.client = wizard.getSelectedClient();
            }
            if (this.launchableAdapter == null) {
                this.launchableAdapter = wizard.getLaunchableAdapter();
            }
        }
        if (this.client == null) {
            this.client = new IClient(){

                public String getDescription() {
                    return Messages.clientDefaultDescription;
                }

                public String getId() {
                    return "org.eclipse.wst.server.ui.client.default";
                }

                public String getName() {
                    return Messages.clientDefaultName;
                }

                public IStatus launch(IServer server3, Object launchable2, String launchMode3, ILaunch launch) {
                    return Status.OK_STATUS;
                }

                public boolean supports(IServer server3, Object launchable2, String launchMode3) {
                    return true;
                }
            };
        }
        if (Trace.FINEST) {
            Trace.trace((String)"/finest", (String)("Prior to creating launch client jobs: launchableAdapter=" + this.launchableAdapter + " client=" + this.client));
        }
        if (moduleArtifact instanceof ModuleArtifactDelegate) {
            boolean canLoad;
            block49: {
                canLoad = false;
                try {
                    Class<?> c = Class.forName(moduleArtifact.getClass().getName());
                    if (c.newInstance() != null) {
                        canLoad = true;
                    }
                }
                catch (Throwable throwable) {
                    if (!Trace.WARNING) break block49;
                    Trace.trace((String)"/warning", (String)"Could not load module artifact delegate class, switching to backup");
                }
            }
            if (canLoad) {
                block50: {
                    try {
                        NullProgressMonitor monitor = new NullProgressMonitor();
                        ILaunchConfiguration config = this.getLaunchConfiguration(server, (ModuleArtifactDelegate)moduleArtifact, this.launchableAdapter, this.client, (IProgressMonitor)monitor);
                        config.launch(this.launchMode, (IProgressMonitor)monitor);
                    }
                    catch (CoreException ce) {
                        if (!Trace.SEVERE) break block50;
                        Trace.trace((String)"/severe", (String)"Could not launch Run on Server", (Throwable)ce);
                    }
                }
                return;
            }
        }
        Thread thread = new Thread("Run on Server"){

            /*
             * Enabled force condition propagation
             * Lifted jumps to return sites
             */
            @Override
            public void run() {
                if (Trace.FINEST) {
                    Trace.trace((String)"/finest", (String)"Ready to launch");
                }
                IModule[] modules = new IModule[]{module};
                int state = server.getServerState();
                if (state == 1) {
                    LaunchClientJob clientJob = new LaunchClientJob(server, modules, DeclaredArtifactRunOnServerActionDelegate.this.launchMode, moduleArtifact, DeclaredArtifactRunOnServerActionDelegate.this.launchableAdapter, DeclaredArtifactRunOnServerActionDelegate.this.client);
                    clientJob.schedule();
                    return;
                } else if (state == 2) {
                    int result;
                    boolean restart = false;
                    String mode = server.getMode();
                    IBreakpointManager breakpointManager = DebugPlugin.getDefault().getBreakpointManager();
                    boolean disabledBreakpoints = false;
                    if (server.getServerRestartState()) {
                        result = DeclaredArtifactRunOnServerActionDelegate.openRestartDialog((Shell)shell);
                        if (result == 0) {
                            DeclaredArtifactRunOnServerActionDelegate.this.launchMode = mode;
                            restart = true;
                        } else if (result == 9) {
                            return;
                        }
                    }
                    if (!restart) {
                        int result2;
                        boolean breakpointsOption;
                        if (!"run".equals(mode) && "run".equals(DeclaredArtifactRunOnServerActionDelegate.this.launchMode)) {
                            breakpointsOption = false;
                            if (breakpointManager.isEnabled() && "debug".equals(mode)) {
                                breakpointsOption = true;
                            }
                            if ((result2 = DeclaredArtifactRunOnServerActionDelegate.openOptionsDialog((Shell)shell, (String)Messages.wizRunOnServerTitle, (String)Messages.dialogModeWarningRun, (boolean)breakpointsOption)) == 0) {
                                restart = true;
                            } else if (result2 == 1) {
                                breakpointManager.setEnabled(false);
                                disabledBreakpoints = true;
                                DeclaredArtifactRunOnServerActionDelegate.this.launchMode = mode;
                            } else {
                                if (result2 != 2) return;
                                DeclaredArtifactRunOnServerActionDelegate.this.launchMode = mode;
                            }
                        } else if (!"debug".equals(mode) && "debug".equals(DeclaredArtifactRunOnServerActionDelegate.this.launchMode)) {
                            result = DeclaredArtifactRunOnServerActionDelegate.openOptionsDialog((Shell)shell, (String)Messages.wizDebugOnServerTitle, (String)Messages.dialogModeWarningDebug, (boolean)false);
                            if (result == 0) {
                                restart = true;
                            } else {
                                if (result != 1) return;
                                DeclaredArtifactRunOnServerActionDelegate.this.launchMode = mode;
                            }
                        } else if (!"profile".equals(mode) && "profile".equals(DeclaredArtifactRunOnServerActionDelegate.this.launchMode)) {
                            breakpointsOption = false;
                            if (breakpointManager.isEnabled() && "debug".equals(mode)) {
                                breakpointsOption = true;
                            }
                            if ((result2 = DeclaredArtifactRunOnServerActionDelegate.openOptionsDialog((Shell)shell, (String)Messages.wizProfileOnServerTitle, (String)Messages.dialogModeWarningProfile, (boolean)breakpointsOption)) == 0) {
                                restart = true;
                            } else if (result2 == 1) {
                                breakpointManager.setEnabled(false);
                                disabledBreakpoints = true;
                                DeclaredArtifactRunOnServerActionDelegate.this.launchMode = mode;
                            } else {
                                if (result2 != 2) return;
                                DeclaredArtifactRunOnServerActionDelegate.this.launchMode = mode;
                            }
                        }
                        if ("debug".equals(DeclaredArtifactRunOnServerActionDelegate.this.launchMode) && !breakpointManager.isEnabled() && !disabledBreakpoints) {
                            result = DeclaredArtifactRunOnServerActionDelegate.openBreakpointDialog((Shell)shell);
                            if (result == 0) {
                                breakpointManager.setEnabled(true);
                            } else if (result != 1) {
                                return;
                            }
                        }
                    }
                    final LaunchClientJob clientJob = new LaunchClientJob(server, modules, DeclaredArtifactRunOnServerActionDelegate.this.launchMode, moduleArtifact, DeclaredArtifactRunOnServerActionDelegate.this.launchableAdapter, DeclaredArtifactRunOnServerActionDelegate.this.client);
                    if (restart) {
                        final IServer server3 = server;
                        server.restart(DeclaredArtifactRunOnServerActionDelegate.this.launchMode, new IServer.IOperationListener(){

                            public void done(IStatus result) {
                                if (server3.shouldPublish()) {
                                    server3.publish(1, null, info, new IServer.IOperationListener(){

                                        public void done(IStatus result2) {
                                            if (result2.isOK()) {
                                                clientJob.schedule();
                                            }
                                        }
                                    });
                                } else {
                                    clientJob.schedule();
                                }
                            }
                        });
                        return;
                    } else if (server.shouldPublish()) {
                        server.publish(1, null, info, new IServer.IOperationListener(){

                            public void done(IStatus result) {
                                if (result.isOK()) {
                                    clientJob.schedule();
                                }
                            }
                        });
                        return;
                    } else {
                        clientJob.schedule();
                    }
                    return;
                } else {
                    if (state == 3) return;
                    final LaunchClientJob clientJob = new LaunchClientJob(server, modules, DeclaredArtifactRunOnServerActionDelegate.this.launchMode, moduleArtifact, DeclaredArtifactRunOnServerActionDelegate.this.launchableAdapter, DeclaredArtifactRunOnServerActionDelegate.this.client);
                    server.start(DeclaredArtifactRunOnServerActionDelegate.this.launchMode, new IServer.IOperationListener(){

                        public void done(IStatus result) {
                            if (result.isOK()) {
                                clientJob.schedule();
                            }
                        }
                    });
                }
            }
        };
        thread.setDaemon(true);
        thread.start();
    }
}

