/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.ide.eclipse.archives.ui.actions;

import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.IWorkbenchWindowActionDelegate;
import org.jboss.ide.eclipse.archives.core.build.ArchiveBuildDelegate;
import org.jboss.ide.eclipse.archives.core.model.IArchive;
import org.jboss.ide.eclipse.archives.core.model.IArchiveNode;
import org.jboss.ide.eclipse.archives.ui.ArchivesUIMessages;
import org.jboss.ide.eclipse.archives.ui.providers.ArchivesContentProviderDelegate;

public class BuildAction
implements IWorkbenchWindowActionDelegate {
    private Object selected;

    public void dispose() {
    }

    public void init(IWorkbenchWindow window) {
    }

    public void run(IAction action) {
        if (this.selected != null) {
            this.buildSelectedNode(this.selected);
        }
    }

    public Job run(Object node) {
        return this.buildSelectedNode(node);
    }

    public void selectionChanged(IAction action, ISelection selection) {
        if (!selection.isEmpty() && selection instanceof IStructuredSelection) {
            IResource res;
            Object o = ((IStructuredSelection)selection).getFirstElement();
            if (o instanceof ArchivesContentProviderDelegate.WrappedProject) {
                o = ((ArchivesContentProviderDelegate.WrappedProject)o).getElement();
            }
            if (o instanceof IAdaptable && (res = (IResource)((IAdaptable)o).getAdapter(IResource.class)) != null) {
                this.selected = res.getProject();
            }
            if (o instanceof IArchiveNode) {
                this.selected = o;
            }
            return;
        }
        this.selected = null;
    }

    private Job buildSelectedNode(final Object selected) {
        Job j = new Job(ArchivesUIMessages.BuildArchivesNode){

            protected IStatus run(IProgressMonitor monitor) {
                if (selected == null) {
                    return Status.OK_STATUS;
                }
                if (selected instanceof IArchiveNode) {
                    IArchiveNode archive = (IArchiveNode)selected;
                    if (archive.getNodeType() != 0) {
                        archive = archive.getRootArchive();
                    }
                    return new ArchiveBuildDelegate().fullArchiveBuild((IArchive)archive, monitor);
                }
                if (selected instanceof IProject || selected instanceof ArchivesContentProviderDelegate.WrappedProject) {
                    IProject p = selected instanceof IProject ? (IProject)selected : ((ArchivesContentProviderDelegate.WrappedProject)selected).getElement();
                    return new ArchiveBuildDelegate().fullProjectBuild(p.getLocation(), monitor);
                }
                return Status.OK_STATUS;
            }
        };
        j.schedule();
        return j;
    }
}

