/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.ide.eclipse.as.core.server.bean;

import java.io.File;
import org.jboss.ide.eclipse.as.core.server.bean.AbstractCondition;
import org.jboss.ide.eclipse.as.core.server.bean.JBossServerType;

public class ServerBeanTypeAS
extends JBossServerType {
    private static final String TWIDDLE_JAR_NAME = "twiddle.jar";

    protected ServerBeanTypeAS() {
        super("AS", "JBoss Application Server", ServerBeanTypeAS.asPath("bin", TWIDDLE_JAR_NAME), new String[]{"6.0", "6.1", "5.1", "5.0", "4.2", "4.0", "3.2"}, new ASServerTypeCondition());
    }

    public static class ASServerTypeCondition
    extends AbstractCondition {
        @Override
        public boolean isServerRoot(File location) {
            File asSystemJar = new File(location, JBossServerType.AS.getSystemJarPath());
            if (asSystemJar.exists() && asSystemJar.isFile()) {
                String title = ServerBeanTypeAS.getJarProperty(asSystemJar, "Implementation-Title");
                boolean isEAP = title != null && title.contains("EAP");
                return !isEAP;
            }
            return false;
        }

        @Override
        public String getServerTypeId(String version) {
            if (version.equals("3.2")) {
                return "org.jboss.ide.eclipse.as.32";
            }
            if (version.equals("4.0")) {
                return "org.jboss.ide.eclipse.as.40";
            }
            if (version.equals("4.2")) {
                return "org.jboss.ide.eclipse.as.42";
            }
            if (version.equals("5.0")) {
                return "org.jboss.ide.eclipse.as.50";
            }
            if (version.equals("5.1")) {
                return "org.jboss.ide.eclipse.as.51";
            }
            if (version.equals("6.0")) {
                return "org.jboss.ide.eclipse.as.60";
            }
            if (version.equals("6.1")) {
                return "org.jboss.ide.eclipse.as.60";
            }
            return null;
        }
    }
}

