/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.ide.eclipse.as.core.server.bean;

import java.io.File;
import org.jboss.ide.eclipse.as.core.server.bean.JBossServerType;
import org.jboss.ide.eclipse.as.core.server.bean.ServerBeanTypeEAP;

public class ServerBeanTypeEPP
extends JBossServerType {
    private static final String JBOSS_PORTLETBRIDGE_PATH = "portletbridge";
    private static final String JBOSS_PORTAL_SAR = "jboss-portal.sar";

    public ServerBeanTypeEPP() {
        super("EPP", "Enterprise Portal Platform", ServerBeanTypeEPP.asPath("jboss-as", "bin", "run.jar"), new String[]{"4.3", "5.0"}, new EPPTypeCondition());
    }

    @Override
    protected String getServerTypeBaseName() {
        return "JBoss Portal";
    }

    @Override
    public String getRootToAdapterRelativePath(String version) {
        return "jboss-as";
    }

    public static class EPPTypeCondition
    extends ServerBeanTypeEAP.EAPServerTypeCondition {
        @Override
        public boolean isServerRoot(File location) {
            boolean sysJarIsFile;
            if (!super.isServerRoot(location)) {
                return false;
            }
            File portletBridgeFolder = new File(location, ServerBeanTypeEPP.JBOSS_PORTLETBRIDGE_PATH);
            File portlalSarFolder = new File(location, ServerBeanTypeEPP.asPath("jboss-as", "server", "default", "deploy", ServerBeanTypeEPP.JBOSS_PORTAL_SAR));
            File asStdSystemJar = new File(location, ServerBeanTypeEPP.asPath("jboss-as", "bin", "run.jar"));
            boolean pbfIsDir = portletBridgeFolder.exists() && portletBridgeFolder.isDirectory();
            boolean psfIsDir = portlalSarFolder.exists() && portlalSarFolder.isDirectory();
            boolean bl = sysJarIsFile = asStdSystemJar.exists() && asStdSystemJar.isFile();
            return (pbfIsDir || psfIsDir) && sysJarIsFile;
        }
    }
}

