/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.ide.eclipse.as.core.server.bean;

import java.io.File;
import java.util.Properties;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.jboss.ide.eclipse.as.core.server.bean.ICondition;
import org.jboss.ide.eclipse.as.core.server.bean.JBossServerType;
import org.jboss.ide.eclipse.as.core.server.bean.ServerBeanType;
import org.jboss.ide.eclipse.as.core.server.bean.ServerBeanTypeEAP6;

public class ServerBeanTypeUnknownAS71Product
extends JBossServerType {
    public ServerBeanTypeUnknownAS71Product() {
        this(ServerBeanTypeUnknownAS71Product.asPath("modules", "org", "jboss", "as", "server", "main"), new UnknownAS71ProductServerTypeCondition());
    }

    public ServerBeanTypeUnknownAS71Product(String path, ICondition condition) {
        this("AS-Product", "Application Server", path, condition);
    }

    protected ServerBeanTypeUnknownAS71Product(String id, String desc, String path, ICondition condition) {
        this(id, desc, path, new String[0], condition);
    }

    @Override
    public String getServerBeanName(File root) {
        if (this.getId().equals("AS-Product")) {
            return root.getName();
        }
        return super.getServerBeanName(root);
    }

    protected ServerBeanTypeUnknownAS71Product(String id, String desc, String path, String[] version, ICondition condition) {
        super(id, desc, path, version, condition);
    }

    public static class UnknownAS71ProductServerTypeCondition
    extends ServerBeanTypeEAP6.EAP6ServerTypeCondition {
        @Override
        public String getServerTypeId(String version) {
            return "org.jboss.ide.eclipse.as.eap.60";
        }

        @Override
        public boolean isServerRoot(File location) {
            return this.getFullVersion(location, null) != null;
        }

        @Override
        public String getFullVersion(File location, File systemJarFile) {
            String productSlot = this.getSlot(location);
            String product = "org.jboss.as.product";
            if (productSlot != null) {
                product = String.valueOf(product) + "." + productSlot;
            }
            product = String.valueOf(product) + ".dir";
            File[] modules = new File[]{new File(location, "modules")};
            String vers = ServerBeanType.getManifestPropFromJBossModulesFolder(modules, product, "META-INF", "JBoss-Product-Release-Version");
            return vers;
        }

        protected String getSlot(File location) {
            Path rootPath = new Path(location.getAbsolutePath());
            IPath productConf = rootPath.append("bin/product.conf");
            if (productConf.toFile().exists()) {
                Properties p = JBossServerType.loadProperties(productConf.toFile());
                return (String)p.get("slot");
            }
            return null;
        }

        protected String[] getLayers(File location) {
            Path rootPath = new Path(location.getAbsolutePath());
            IPath layersConf = rootPath.append("modules/layers.conf");
            String[] layers = new String[]{};
            if (layersConf.toFile().exists()) {
                Properties p = JBossServerType.loadProperties(layersConf.toFile());
                String layers2 = (String)p.get("layers");
                layers = layers2 == null ? new String[]{} : layers2.trim().split(",");
            }
            return layers;
        }

        protected String[] getManifestFoldersToFindVersion(String productSlot, String[] layers) {
            return new String[]{this.getMetaInfFolderForSlot(productSlot)};
        }

        protected String getMetaInfFolderForSlot(String slot) {
            return "modules/org/jboss/as/product/" + slot + "/dir/META-INF";
        }

        @Override
        public String getUnderlyingTypeId(File location, File systemFile) {
            String s = this.getSlot(location);
            return s == null ? null : s.toUpperCase();
        }
    }
}

