/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.ide.eclipse.as.wtp.core.modules.filter.patterns.internal;

import java.util.Vector;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.wst.server.core.model.IModuleFile;
import org.eclipse.wst.server.core.model.IModuleFolder;
import org.eclipse.wst.server.core.model.IModuleResource;
import org.eclipse.wst.server.core.util.ModuleFolder;
import org.jboss.ide.eclipse.as.wtp.core.modules.filter.patterns.internal.ModuleResourceTreeNode;
import org.jboss.tools.archives.scanner.ITreeNode;
import org.jboss.tools.archives.scanner.VirtualDirectoryScanner;

public class PublishFilterDirectoryScanner
extends VirtualDirectoryScanner<ModuleResourceTreeNode> {
    protected Vector<String> dirsNotIncludedButRequired = new Vector();

    public PublishFilterDirectoryScanner(IModuleResource[] resources) {
        ModuleFolder mf = new ModuleFolder(null, "", (IPath)new Path("/"));
        mf.setMembers(resources);
        ModuleResourceTreeNode n = new ModuleResourceTreeNode((IModuleResource)mf);
        super.setBasedir((ITreeNode)n);
    }

    protected void postInclude(ModuleResourceTreeNode f, String name) {
        if (this.iterator != null) {
            this.iterator.addMatch((Object)f, name);
        }
        IPath p = new Path(name).removeLastSegments(1);
        while (p.segmentCount() > 0) {
            if (!this.dirsIncluded.contains(p.toString()) && !this.dirsNotIncludedButRequired.contains(p.toString())) {
                this.dirsNotIncludedButRequired.add(p.toString());
            }
            p = p.removeLastSegments(1);
        }
    }

    public void scan() throws IllegalStateException {
        this.scanPrepare();
        super.scandirWrap((ITreeNode)((ModuleResourceTreeNode)this.basedir), "", true);
    }

    public boolean isIncludedFile(IModuleFile resource) {
        return this.isIncludedFile(this.getResourcePath((IModuleResource)resource));
    }

    public boolean isIncludedDir(IModuleFolder resource) {
        return this.isIncludedDir(this.getResourcePath((IModuleResource)resource));
    }

    public boolean isNotIncludedButRequiredMember(IModuleResource resource) {
        return this.isNotIncludedButRequired(this.getResourcePath(resource));
    }

    public boolean isIncludedMember(IModuleResource resource) {
        String path = this.getResourcePath(resource);
        return this.isIncludedFile(path) || this.isIncludedDir(path);
    }

    public boolean isRequiredMember(IModuleResource resource) {
        String path = this.getResourcePath(resource);
        return this.isIncludedFile(path) || this.isIncludedDir(path) || this.isNotIncludedButRequired(path);
    }

    public boolean isIncludedFile(String vpath) {
        return this.filesIncluded.contains(vpath);
    }

    public boolean isIncludedDir(String vpath) {
        return this.dirsIncluded.contains(vpath);
    }

    public boolean isNotIncludedButRequired(String vpath) {
        return this.dirsNotIncludedButRequired.contains(vpath);
    }

    public boolean isIncludedMember(String vpath) {
        return this.isIncludedFile(vpath) || this.isIncludedDir(vpath);
    }

    public boolean isRequiredMember(String vpath) {
        return this.isIncludedFile(vpath) || this.isIncludedDir(vpath) || this.isNotIncludedButRequired(vpath);
    }

    private String getResourcePath(IModuleResource resource) {
        return resource.getModuleRelativePath().append(resource.getName()).makeRelative().toOSString();
    }

    public static IModuleResource findResource(IModuleResource[] allMembers, IModuleFolder parent, IPath path) {
        if (path == null || path.segmentCount() == 0) {
            return null;
        }
        IModuleResource[] children = parent == null ? allMembers : parent.members();
        int i = 0;
        while (i < children.length) {
            if (children[i].getName().equals(path.segment(0))) {
                if (path.segmentCount() == 1) {
                    return children[i];
                }
                if (children[i] instanceof IModuleFolder) {
                    return PublishFilterDirectoryScanner.findResource(allMembers, (IModuleFolder)children[i], path.removeFirstSegments(1));
                }
                throw new IllegalStateException("Requested Path Not Found");
            }
            ++i;
        }
        throw new IllegalStateException("Requested Path Not Found");
    }
}

