/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.ide.eclipse.as.core.server.internal.extendedproperties;

import java.io.File;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.jdt.internal.launching.environments.EnvironmentsManager;
import org.eclipse.jdt.launching.environments.IExecutionEnvironment;
import org.eclipse.osgi.util.NLS;
import org.eclipse.wst.server.core.IServerAttributes;
import org.jboss.ide.eclipse.as.core.Messages;
import org.jboss.ide.eclipse.as.core.resolvers.ConfigNameResolver;
import org.jboss.ide.eclipse.as.core.resolvers.RuntimeVariableResolver;
import org.jboss.ide.eclipse.as.core.server.IDefaultLaunchArguments;
import org.jboss.ide.eclipse.as.core.server.IDeploymentScannerModifier;
import org.jboss.ide.eclipse.as.core.server.IServerModuleStateVerifier;
import org.jboss.ide.eclipse.as.core.server.bean.JBossServerType;
import org.jboss.ide.eclipse.as.core.server.bean.ServerBean;
import org.jboss.ide.eclipse.as.core.server.bean.ServerBeanLoader;
import org.jboss.ide.eclipse.as.core.server.internal.JBossLT6ModuleStateVerifier;
import org.jboss.ide.eclipse.as.core.server.internal.JBossServer;
import org.jboss.ide.eclipse.as.core.server.internal.JMXServerDeploymentScannerAdditions;
import org.jboss.ide.eclipse.as.core.server.internal.extendedproperties.JBoss5xDefaultLaunchArguments;
import org.jboss.ide.eclipse.as.core.server.internal.extendedproperties.JBossDefaultLaunchArguments;
import org.jboss.ide.eclipse.as.core.server.internal.extendedproperties.JBossSoa5xDefaultLaunchArguments;
import org.jboss.ide.eclipse.as.core.server.internal.extendedproperties.ServerExtendedProperties;
import org.jboss.ide.eclipse.as.core.util.ServerUtil;
import org.jboss.tools.foundation.core.expressions.ExpressionResolver;
import org.jboss.tools.foundation.core.expressions.IVariableResolver;

public class JBossExtendedProperties
extends ServerExtendedProperties {
    @Deprecated
    protected static final String WELCOME_PAGE_URL_PATTERN = "http://{0}:{1}/";

    public JBossExtendedProperties(IAdaptable adaptable) {
        super(adaptable);
    }

    public String getRuntimeTypeVersionString() {
        return this.runtime.getRuntimeType().getVersion();
    }

    public boolean runtimeSupportsBindingToAllInterfaces() {
        return true;
    }

    public boolean runtimeSupportsExposingManagement() {
        return false;
    }

    protected ServerBeanLoader getServerBeanLoader() {
        return this.runtime == null ? null : new ServerBeanLoader(this.runtime.getLocation().toFile());
    }

    public String getServerDeployLocation() {
        String original = String.valueOf(ConfigNameResolver.getVariablePattern("jboss_config_dir")) + "/" + "deploy";
        RuntimeVariableResolver resolver = new RuntimeVariableResolver(this.runtime);
        ExpressionResolver process = new ExpressionResolver((IVariableResolver)resolver);
        return process.resolve(original);
    }

    @Override
    public int getJMXProviderType() {
        return 1;
    }

    @Override
    public boolean hasWelcomePage() {
        return true;
    }

    @Override
    public String getWelcomePageUrl() {
        try {
            JBossServer jbossServer = ServerUtil.checkedGetServerAdapter((IServerAttributes)this.server, JBossServer.class);
            int webPort = jbossServer.getJBossWebPort();
            String consoleUrl = ServerUtil.createSafeURLString("http", this.server.getHost(), webPort, null);
            return consoleUrl;
        }
        catch (CoreException coreException) {
            return null;
        }
    }

    @Override
    public int getMultipleDeployFolderSupport() {
        return 2;
    }

    @Override
    public IStatus verifyServerStructure() {
        try {
            String e = this.getVerifyStructureErrorMessage();
            if (e != null) {
                return new Status(4, "org.jboss.ide.eclipse.as.core", e);
            }
        }
        catch (CoreException ce) {
            return ce.getStatus();
        }
        return Status.OK_STATUS;
    }

    protected String getVerifyStructureErrorMessage() throws CoreException {
        if (this.server.getRuntime() == null) {
            return NLS.bind((String)Messages.ServerMissingRuntime, (Object)this.server.getName());
        }
        if (!this.server.getRuntime().getLocation().toFile().exists()) {
            return NLS.bind((String)Messages.RuntimeFolderDoesNotExist, (Object)this.server.getRuntime().getLocation().toOSString());
        }
        JBossServer jbossServer = ServerUtil.checkedGetServerAdapter((IServerAttributes)this.server, JBossServer.class);
        if (!new File(jbossServer.getConfigDirectory()).exists()) {
            return NLS.bind((String)Messages.JBossConfigurationFolderDoesNotExist, (Object)jbossServer.getConfigDirectory());
        }
        return null;
    }

    @Override
    public boolean canVerifyRemoteModuleState() {
        return true;
    }

    @Override
    public IServerModuleStateVerifier getModuleStateVerifier() {
        return new JBossLT6ModuleStateVerifier();
    }

    public IDeploymentScannerModifier getDeploymentScannerModifier() {
        return new JMXServerDeploymentScannerAdditions();
    }

    public IDefaultLaunchArguments getDefaultLaunchArguments() {
        String serverType;
        String[] as5Types = new String[]{"org.jboss.ide.eclipse.as.runtime.50", "org.jboss.ide.eclipse.as.runtime.51", "org.jboss.ide.eclipse.as.runtime.eap.50", "org.jboss.ide.eclipse.as.50", "org.jboss.ide.eclipse.as.51", "org.jboss.ide.eclipse.as.eap.50"};
        boolean isAS5 = false;
        String string = this.server == null ? null : (serverType = this.server.getServerType() == null ? null : this.server.getServerType().getId());
        String rtType = this.runtime == null ? null : (this.runtime.getRuntimeType() == null ? null : this.runtime.getRuntimeType().getId());
        int i = 0;
        while (i < as5Types.length) {
            if (as5Types[i].equals(serverType) || as5Types[i].equals(rtType)) {
                isAS5 = true;
                break;
            }
            ++i;
        }
        if (isAS5) {
            ServerBean sb = new ServerBeanLoader(this.runtime.getLocation().toFile()).getServerBean();
            if (sb.getBeanType().getId().equals(JBossServerType.EAP_STD.getId()) && (sb = new ServerBeanLoader(this.runtime.getLocation().toFile().getParentFile()).getServerBean()) != null && JBossServerType.SOAP.getId().equals(sb.getBeanType().getId()) && sb.getVersion().startsWith("5.")) {
                if (this.server != null) {
                    return new JBossSoa5xDefaultLaunchArguments(this.server);
                }
                return new JBossSoa5xDefaultLaunchArguments(this.runtime);
            }
            if (this.server != null) {
                return new JBoss5xDefaultLaunchArguments(this.server);
            }
            return new JBoss5xDefaultLaunchArguments(this.runtime);
        }
        if (this.server != null) {
            return new JBossDefaultLaunchArguments(this.server);
        }
        return new JBossDefaultLaunchArguments(this.runtime);
    }

    public boolean requiresJDK() {
        return false;
    }

    @Override
    public int getFileStructure() {
        return 1;
    }

    public IExecutionEnvironment getDefaultExecutionEnvironment() {
        return EnvironmentsManager.getDefault().getEnvironment("J2SE-1.4");
    }

    public IExecutionEnvironment getMinimumExecutionEnvironment() {
        return this.getDefaultExecutionEnvironment();
    }

    public IExecutionEnvironment getMaximumExecutionEnvironment() {
        return null;
    }

    @Override
    public boolean allowExplodedModulesInWarLibs() {
        return false;
    }

    @Override
    public boolean allowExplodedModulesInEars() {
        return false;
    }
}

