/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.ide.eclipse.as.core.server.internal.v7;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.osgi.util.NLS;
import org.eclipse.wst.server.core.IServer;
import org.jboss.dmr.ModelNode;
import org.jboss.ide.eclipse.as.core.JBossServerCorePlugin;
import org.jboss.ide.eclipse.as.core.server.v7.management.AS7ManagementDetails;
import org.jboss.ide.eclipse.as.management.core.IAS7ManagementDetails;
import org.jboss.ide.eclipse.as.management.core.IJBoss7ManagerService;
import org.jboss.ide.eclipse.as.management.core.JBoss7ManagerUtil;

public class AS7DeploymentScannerUtility {
    public static final int DEFAULT_INTERVAL = 5000;
    public static final int IGNORE = -20;
    public static final String SCANNER_PREFIX = "jbosstoolsscanner";

    public IStatus addDeploymentScanner(IServer server, String scannerName, String folder) {
        return this.addDeploymentScanner(server, scannerName, folder, 5000, -20);
    }

    public IStatus addDeploymentScanner(IServer server, String scannerName, String folder, int interval, int timeout) {
        ModelNode op = new ModelNode();
        op.get("operation").set("add");
        ModelNode addr = op.get("address");
        addr.add("subsystem", "deployment-scanner");
        addr.add("scanner", scannerName);
        op.get("path").set(folder);
        if (interval != -20) {
            op.get("scan-interval").set(interval);
        }
        if (timeout != -20) {
            op.get("deployment-timeout").set(timeout);
        }
        String request = op.toJSONString(true);
        return this.execute(server, request);
    }

    public IStatus removeDeploymentScanner(IServer server, String scannerName) {
        ModelNode op = new ModelNode();
        op.get("operation").set("remove");
        ModelNode addr = op.get("address");
        addr.add("subsystem", "deployment-scanner");
        addr.add("scanner", scannerName);
        String request = op.toJSONString(true);
        return this.execute(server, request);
    }

    public boolean updateDeploymentScannerInterval(IServer server, String scannerName, int newValue) {
        ModelNode op = new ModelNode();
        op.get("operation").set("write-attribute");
        op.get("name").set("scan-interval");
        op.get("value").set(newValue);
        ModelNode addr = op.get("address");
        addr.add("subsystem", "deployment-scanner");
        addr.add("scanner", scannerName);
        String request = op.toJSONString(true);
        try {
            this.executeWithResult(server, request);
        }
        catch (Exception exception) {
            return false;
        }
        return true;
    }

    public boolean setScannerEnabled(IServer server, String scannerName, boolean enabled) {
        ModelNode op = new ModelNode();
        op.get("operation").set("write-attribute");
        op.get("name").set("scan-enabled");
        op.get("value").set(enabled);
        ModelNode addr = op.get("address");
        addr.add("subsystem", "deployment-scanner");
        addr.add("scanner", scannerName);
        String request = op.toJSONString(true);
        try {
            this.executeWithResult(server, request);
        }
        catch (Exception e) {
            JBossServerCorePlugin.log(e);
            return false;
        }
        return true;
    }

    public HashMap<String, Integer> getDeploymentScannerIntervals(IServer server) {
        Scanner[] scanners = this.getDeploymentScanners(server);
        HashMap<String, Integer> retval = new HashMap<String, Integer>();
        int i = 0;
        while (i < scanners.length) {
            retval.put(scanners[i].name, scanners[i].interval);
            ++i;
        }
        return retval;
    }

    public Scanner[] getDeploymentScanners(IServer server) {
        return this.getDeploymentScanners(server, true);
    }

    public Scanner[] getDeploymentScannersBlocking(IServer server, boolean all) {
        return this.getDeploymentScannersBlocking(server, all, 5, 1500L);
    }

    public Scanner[] getDeploymentScannersBlocking(IServer server, boolean all, int maxTries, long sleep) {
        Scanner[] scanners = null;
        int attempt = 0;
        InterruptedException ie2 = null;
        while (scanners == null && attempt < maxTries) {
            ++attempt;
            try {
                scanners = this.getDeploymentScanners(server, all, false, true);
            }
            catch (Exception exception) {
                try {
                    Thread.sleep(sleep);
                }
                catch (InterruptedException ie) {
                    ie2 = ie;
                }
            }
        }
        if (scanners != null) {
            return scanners;
        }
        JBossServerCorePlugin.getDefault().getLog().log((IStatus)new Status(4, "org.jboss.ide.eclipse.as.core", NLS.bind((String)"Unable to retrieve a list of remote deployment scanners for server {0}", (Object)server.getName()), (Throwable)ie2));
        return null;
    }

    public Scanner[] getDeploymentScanners(IServer server, boolean allScanners) {
        try {
            return this.getDeploymentScanners(server, allScanners, true, false);
        }
        catch (Exception exception) {
            return new Scanner[0];
        }
    }

    public Scanner[] getDeploymentScanners(IServer server, boolean allScanners, boolean log, boolean rethrow) throws Exception {
        ArrayList<Scanner> list = new ArrayList<Scanner>();
        ModelNode op = new ModelNode();
        op.get("operation").set("read-resource");
        ModelNode addr = op.get("address");
        addr.add("subsystem", "deployment-scanner");
        addr.add("scanner", "*");
        String request = op.toJSONString(true);
        ModelNode response = null;
        try {
            response = this.executeWithResult(server, request);
        }
        catch (Exception e) {
            if (log) {
                JBossServerCorePlugin.getDefault().getLog().log((IStatus)new Status(4, "org.jboss.ide.eclipse.as.core", NLS.bind((String)"Unable to retrieve a list of remote deployment scanners for server {0}", (Object)server.getName()), (Throwable)e));
            }
            if (rethrow) {
                throw e;
            }
            return null;
        }
        List mnList = response.asList();
        int i = 0;
        while (i < mnList.size()) {
            ModelNode listElement = (ModelNode)mnList.get(i);
            ModelNode address = listElement.get("address");
            ModelNode result = listElement.get("result");
            String scannerName = ((ModelNode)address.asList().get(1)).get("scanner").asString();
            if (allScanners || scannerName.startsWith(SCANNER_PREFIX)) {
                int interval = result.get("scan-interval").asBigInteger().intValue();
                int timeout = result.get("deployment-timeout").asBigInteger().intValue();
                String path5 = result.get("path").toString();
                boolean enabled = result.get("scan-enabled").asBoolean();
                Scanner s = new Scanner();
                s.name = scannerName;
                s.address = path5;
                s.interval = interval;
                s.timeout = timeout;
                s.enabled = enabled;
                list.add(s);
            }
            ++i;
        }
        return list.toArray(new Scanner[list.size()]);
    }

    public HashMap<String, String> getDeploymentScannersFromServer(IServer server, boolean all) {
        try {
            return this.getDeploymentScannersFromServer(server, all, true, false);
        }
        catch (Exception exception) {
            return new HashMap<String, String>();
        }
    }

    public HashMap<String, String> getDeploymentScannersFromServer(IServer server, boolean all, boolean log, boolean rethrow) throws Exception {
        Scanner[] scanners = this.getDeploymentScanners(server, all, log, rethrow);
        return this.getDeploymentScannersFromServer(server, scanners);
    }

    public HashMap<String, String> getDeploymentScannersFromServer(IServer server, Scanner[] scanners) {
        HashMap<String, String> retval = new HashMap<String, String>();
        int i = 0;
        while (i < scanners.length) {
            retval.put(scanners[i].getName(), scanners[i].getAddress());
            ++i;
        }
        return retval;
    }

    public Scanner getDefaultDeploymentScanner(IServer server) {
        Scanner[] scanners = this.getDeploymentScanners(server, true);
        int i = 0;
        while (i < scanners.length) {
            if ("default".equals(scanners[i].name)) {
                return scanners[i];
            }
            ++i;
        }
        return null;
    }

    protected IStatus execute(IServer server, String request) {
        try {
            this.executeWithResult(server, request);
            return Status.OK_STATUS;
        }
        catch (Exception e) {
            return new Status(4, "org.jboss.ide.eclipse.as.core", e.getMessage(), (Throwable)e);
        }
    }

    protected ModelNode executeWithResult(final IServer server, final String request) throws Exception {
        String resultJSON = (String)JBoss7ManagerUtil.executeWithService((JBoss7ManagerUtil.IServiceAware)new JBoss7ManagerUtil.IServiceAware<String>(){

            public String execute(IJBoss7ManagerService service) throws Exception {
                return service.execute((IAS7ManagementDetails)new AS7ManagementDetails(server), request);
            }
        }, (IServer)server);
        ModelNode result = ModelNode.fromJSONString((String)resultJSON);
        return result;
    }

    public static final class Scanner {
        private String name;
        private int interval;
        private int timeout;
        private String address;
        private String relativeTo;
        private boolean enabled;

        public String getName() {
            return this.name;
        }

        public int getInterval() {
            return this.interval;
        }

        public String getRelativeTo() {
            return this.relativeTo;
        }

        public int getTimeout() {
            return this.timeout;
        }

        public void setTimeout(int timeout) {
            this.timeout = timeout;
        }

        public void setInterval(int interval) {
            this.interval = interval;
        }

        public String getAddress() {
            return this.address;
        }

        public boolean getEnabled() {
            return this.enabled;
        }
    }
}

