/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.ide.eclipse.as.core.util;

import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Status;
import org.eclipse.osgi.util.NLS;
import org.eclipse.wst.server.core.IServer;
import org.eclipse.wst.server.core.model.ServerBehaviourDelegate;
import org.jboss.ide.eclipse.as.core.util.RemotePath;
import org.jboss.ide.eclipse.as.wtp.core.server.behavior.ControllableServerBehavior;
import org.jboss.ide.eclipse.as.wtp.core.server.behavior.IControllableServerBehavior;
import org.jboss.ide.eclipse.as.wtp.core.server.behavior.IFilesystemController;
import org.jboss.ide.eclipse.as.wtp.core.server.behavior.IServerDetailsController;
import org.jboss.ide.eclipse.as.wtp.core.server.behavior.ISubsystemController;
import org.jboss.tools.as.core.server.controllable.systems.IDeploymentOptionsController;

public class ServerHomeValidationUtility {
    private ISubsystemController findDependencyFromBehavior(IServer server, String system) throws CoreException {
        IControllableServerBehavior beh = this.getControllableBehavior(server);
        return beh == null ? null : beh.getController(system);
    }

    private IControllableServerBehavior getControllableBehavior(IServer server) {
        ServerBehaviourDelegate del;
        if (server != null && (del = (ServerBehaviourDelegate)server.loadAdapter(ServerBehaviourDelegate.class, null)) instanceof ControllableServerBehavior) {
            return (IControllableServerBehavior)del;
        }
        return null;
    }

    public IStatus validateServerHome(IServer server) throws CoreException {
        return this.validateServerHome(server, false);
    }

    public IStatus validateServerHome(IServer server, boolean alwaysThrow) throws CoreException {
        IFilesystemController fs = (IFilesystemController)this.findDependencyFromBehavior(server, "filesystem");
        IServerDetailsController det = (IServerDetailsController)this.findDependencyFromBehavior(server, "serverDetails");
        IDeploymentOptionsController opts = (IDeploymentOptionsController)this.findDependencyFromBehavior(server, "deploymentOptions");
        IStatus s = this.validateServerHome(server, det, opts, fs);
        if (alwaysThrow && !s.isOK()) {
            throw new CoreException(s);
        }
        return s;
    }

    public IStatus validateServerHome(IServer server, IServerDetailsController details, IDeploymentOptionsController options, IFilesystemController fs) throws CoreException {
        if (details != null) {
            String serverHome = details.getProperty("PROP_SERVER_HOME");
            if (serverHome.isEmpty()) {
                return new Status(4, "org.jboss.ide.eclipse.as.core", NLS.bind((String)"The home directory for \"{0}\" cannot be empty.", (Object)server.getName()));
            }
            RemotePath remoteHome = new RemotePath(serverHome, options.getPathSeparatorCharacter());
            if (!fs.exists((IPath)remoteHome, (IProgressMonitor)new NullProgressMonitor())) {
                return new Status(4, "org.jboss.ide.eclipse.as.core", NLS.bind((String)("The home directory for \"{0}\" does not exist: " + serverHome), (Object)server.getName()));
            }
        }
        return Status.OK_STATUS;
    }
}

