/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.ide.eclipse.as.core.util;

import java.io.File;
import java.io.UnsupportedEncodingException;
import java.util.Arrays;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.regex.PatternSyntaxException;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Status;
import org.eclipse.equinox.security.storage.StorageException;
import org.eclipse.osgi.util.NLS;
import org.eclipse.wst.server.core.IRuntime;
import org.eclipse.wst.server.core.IServer;
import org.eclipse.wst.server.core.IServerAttributes;
import org.eclipse.wst.server.core.IServerType;
import org.eclipse.wst.server.core.ServerCore;
import org.jboss.ide.eclipse.as.core.JBossServerCorePlugin;
import org.jboss.ide.eclipse.as.core.Messages;
import org.jboss.ide.eclipse.as.core.server.IDelegatingServerBehavior;
import org.jboss.ide.eclipse.as.core.server.IJBossBehaviourDelegate;
import org.jboss.ide.eclipse.as.core.server.IJBossServerRuntime;
import org.jboss.ide.eclipse.as.core.server.internal.ExtendedServerPropertiesAdapterFactory;
import org.jboss.ide.eclipse.as.core.server.internal.JBossServer;
import org.jboss.ide.eclipse.as.core.server.internal.extendedproperties.ServerExtendedProperties;
import org.jboss.ide.eclipse.as.core.util.IJBossToolingConstants;
import org.jboss.ide.eclipse.as.core.util.ServerNamingUtility;
import org.jboss.ide.eclipse.as.wtp.core.util.ServerSecureStorageUtil;

public class ServerUtil {
    private static final String LEGACY_SECURE_PREFERNCES_BASEKEY = "org.jboss.ide.eclipse.as.core".replace('.', '/');
    private static final String SECURE_PREFERNCES_BASEKEY = "org.jboss.ide.eclipse.as.core";
    private static Pattern VALID_IPV4_PATTERN = null;
    private static Pattern VALID_IPV6_PATTERN = null;
    private static Pattern VALID_IPV6_COMPRESSED_PATTERN = null;
    private static final String ip4PatternString = "^(25[0-5]|2[0-4]\\d|[0-1]?\\d?\\d)(\\.(25[0-5]|2[0-4]\\d|[0-1]?\\d?\\d)){3}$";
    private static final String ip6StandardPatternString = "^(?:[0-9a-fA-F]{1,4}:){7}[0-9a-fA-F]{1,4}$";
    private static final String ip6CompressedPatternString = "^((?:[0-9A-Fa-f]{1,4}(?::[0-9A-Fa-f]{1,4})*)?)::((?:[0-9A-Fa-f]{1,4}(?::[0-9A-Fa-f]{1,4})*)?)$";

    static {
        try {
            VALID_IPV4_PATTERN = Pattern.compile(ip4PatternString, 2);
            VALID_IPV6_PATTERN = Pattern.compile(ip6StandardPatternString, 2);
            VALID_IPV6_COMPRESSED_PATTERN = Pattern.compile(ip6CompressedPatternString, 2);
        }
        catch (PatternSyntaxException patternSyntaxException) {}
    }

    public static IPath getServerStateLocation(IServer server) {
        return server == null ? JBossServerCorePlugin.getDefault().getStateLocation() : ServerUtil.getServerStateLocation(server.getId());
    }

    public static IPath getServerStateLocation(String serverID) {
        return serverID == null ? JBossServerCorePlugin.getDefault().getStateLocation() : JBossServerCorePlugin.getDefault().getStateLocation().append(serverID.replace(' ', '_'));
    }

    public static IPath getServerBinDirectory(JBossServer server) throws CoreException {
        return ServerUtil.getServerHomePath(server).append("bin");
    }

    public static <ADAPTER> ADAPTER checkedGetServerAdapter(IServerAttributes server, Class<ADAPTER> behaviorClass) throws CoreException {
        Object adapter = server.loadAdapter(behaviorClass, (IProgressMonitor)new NullProgressMonitor());
        if (adapter == null) {
            throw new CoreException((IStatus)new Status(4, SECURE_PREFERNCES_BASEKEY, NLS.bind((String)Messages.CouldNotFindServerBehavior, (Object)server.getName())));
        }
        return (ADAPTER)adapter;
    }

    public static IJBossBehaviourDelegate checkedGetBehaviorDelegate(IServer server) throws CoreException {
        return ServerUtil.checkedGetServerAdapter((IServerAttributes)server, IDelegatingServerBehavior.class).getDelegate();
    }

    public static IPath makeRelative(IRuntime rt, IPath p) {
        IPath rtLoc;
        if (p.isAbsolute() && rt != null && (rtLoc = rt.getLocation()) != null && rtLoc.isPrefixOf(p)) {
            int size = rt.getLocation().toOSString().length();
            return new Path(p.toOSString().substring(size)).makeRelative();
        }
        return p;
    }

    public static IPath makeGlobal(IRuntime rt, IPath p) {
        return rt == null ? p : ServerUtil.makeGlobal(rt.getLocation(), p);
    }

    public static IPath makeGlobal(IPath rtLocation, IPath p) {
        if (!p.isAbsolute()) {
            if (rtLocation != null && rtLocation != null) {
                return rtLocation.append(p).makeAbsolute();
            }
            return p.makeAbsolute();
        }
        return p;
    }

    public static boolean isJBossServerType(IServerType type) {
        if (type == null) {
            return false;
        }
        List<String> asList = Arrays.asList(IJBossToolingConstants.ALL_JBOSS_SERVERS);
        return asList.contains(type.getId());
    }

    public static boolean isJBoss7(IServer server) {
        return ServerUtil.isJBoss7Style(server);
    }

    public static boolean isJBoss7(IServerType type) {
        if (type == null) {
            return false;
        }
        return type.getId().equals("org.jboss.ide.eclipse.as.70") || type.getId().equals("org.jboss.ide.eclipse.as.71") || type.getId().equals("org.jboss.ide.eclipse.as.eap.60") || type.getId().equals("org.jboss.ide.eclipse.as.eap.61") || type.getId().equals("org.jboss.ide.eclipse.as.wildfly.80");
    }

    private static boolean isJBoss7Style(IServer server) {
        ServerExtendedProperties sep = ExtendedServerPropertiesAdapterFactory.getServerExtendedProperties((IServerAttributes)server);
        if (sep == null) {
            return false;
        }
        boolean as7Style = sep.getFileStructure() == 2;
        return as7Style;
    }

    public static void createStandardFolders(IServer server) {
        int fileStructure;
        File location = JBossServerCorePlugin.getServerStateLocation(server).toFile();
        location.mkdirs();
        File d1 = new File(location, "deploy");
        File d2 = new File(location, "tempDeploy");
        d1.mkdirs();
        d2.mkdirs();
        JBossServer ds = (JBossServer)((Object)server.loadAdapter(JBossServer.class, null));
        ServerExtendedProperties sep = ExtendedServerPropertiesAdapterFactory.getServerExtendedProperties((IServerAttributes)server);
        if (ds != null && sep != null && (fileStructure = sep.getFileStructure()) == 1) {
            IRuntime rt;
            IJBossServerRuntime jbsrt;
            if (!new File(ds.getDeployFolder()).equals(d1)) {
                new File(ds.getDeployFolder()).mkdirs();
            }
            if (!new File(ds.getTempDeployFolder()).equals(d2)) {
                new File(ds.getTempDeployFolder()).mkdirs();
            }
            if ((jbsrt = (IJBossServerRuntime)(rt = server.getRuntime()).loadAdapter(IJBossServerRuntime.class, (IProgressMonitor)new NullProgressMonitor())) != null) {
                String config = jbsrt.getJBossConfiguration();
                IPath newTemp = new Path("server").append(config).append("tmp").append("jbosstoolsTemp").makeRelative();
                IPath newTempAsGlobal = ServerUtil.makeGlobal(jbsrt.getRuntime(), newTemp);
                newTempAsGlobal.toFile().mkdirs();
            }
        }
    }

    public static IServer findServer(String name) {
        IServer[] servers = ServerCore.getServers();
        int i = 0;
        while (i < servers.length) {
            if (name.trim().equals(servers[i].getName())) {
                return servers[i];
            }
            ++i;
        }
        return null;
    }

    public static String getDefaultServerName(IRuntime rt) {
        return ServerNamingUtility.getDefaultServerName(rt);
    }

    public static String getDefaultServerName(String base) {
        return ServerNamingUtility.getDefaultServerName(base);
    }

    public static String checkedGetServerHome(JBossServer jbs) throws CoreException {
        String serverHome = jbs.getServer().getRuntime().getLocation().toOSString();
        if (serverHome == null) {
            throw new CoreException((IStatus)new Status(4, SECURE_PREFERNCES_BASEKEY, NLS.bind((String)Messages.CannotLocateServerHome, (Object)jbs.getServer().getName())));
        }
        return serverHome;
    }

    public static IPath getServerHomePath(JBossServer jbs) throws CoreException {
        return new Path(ServerUtil.checkedGetServerHome(jbs));
    }

    public static String getFromSecureStorage(IServerAttributes server, String key) {
        String ret = ServerSecureStorageUtil.getFromSecureStorage((String)SECURE_PREFERNCES_BASEKEY, (IServerAttributes)server, (String)key);
        if (ret == null) {
            ret = ServerSecureStorageUtil.legacyGetFromSecureStorage((String)LEGACY_SECURE_PREFERNCES_BASEKEY, (IServerAttributes)server, (String)key);
        }
        return ret;
    }

    public static void storeInSecureStorage(IServerAttributes server, String key, String val) throws StorageException, UnsupportedEncodingException {
        ServerSecureStorageUtil.storeInSecureStorage((String)SECURE_PREFERNCES_BASEKEY, (IServerAttributes)server, (String)key, (String)val);
    }

    public static String createSafeURLString(String scheme, String host, String path) {
        return ServerUtil.createSafeURLString(scheme, host, -1, path);
    }

    public static String createSafeURLString(String scheme, String host, int port, String path) {
        StringBuilder sb = new StringBuilder();
        sb.append(scheme);
        sb.append("://");
        sb.append(ServerUtil.formatPossibleIpv6Address(host));
        if (port != -1) {
            sb.append(":");
            sb.append(port);
        }
        if (path != null) {
            if (!path.startsWith("/")) {
                sb.append("/");
            }
            sb.append(path);
        }
        return sb.toString();
    }

    public static String formatPossibleIpv6Address(String address) {
        if (address == null) {
            return address;
        }
        if (!address.contains(":")) {
            return address;
        }
        if (address.startsWith("[") && address.endsWith("]")) {
            return address;
        }
        return "[" + address + "]";
    }

    public static boolean matchesIP4t(String ipAddress) {
        Matcher m1 = VALID_IPV4_PATTERN.matcher(ipAddress);
        return m1.matches();
    }

    public static boolean matchesIP6t(String ipAddress) {
        Matcher m1 = VALID_IPV6_PATTERN.matcher(ipAddress);
        if (m1.matches()) {
            return true;
        }
        Matcher m2 = VALID_IPV6_COMPRESSED_PATTERN.matcher(ipAddress);
        return m2.matches();
    }
}

