/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.as.core.internal.modules;

import java.io.File;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.wst.server.core.IModule;
import org.eclipse.wst.server.core.IModule2;
import org.eclipse.wst.server.core.IServer;
import org.eclipse.wst.server.core.IServerAttributes;
import org.jboss.ide.eclipse.as.core.util.RemotePath;
import org.jboss.ide.eclipse.as.wtp.core.util.ServerModelUtilities;
import org.jboss.tools.as.core.internal.modules.DeploymentModulePrefs;
import org.jboss.tools.as.core.internal.modules.DeploymentPreferences;
import org.jboss.tools.as.core.internal.modules.DeploymentPreferencesLoader;
import org.jboss.tools.as.core.internal.modules.DeploymentTypePrefs;

public class ModuleDeploymentPrefsUtil {
    public IPath getModuleRootDestination(IModule[] moduleTree, IServer server, String defaultFolder, char separator) {
        DeploymentPreferences prefs = DeploymentPreferencesLoader.loadPreferencesFromServer((IServerAttributes)server);
        String folder = this.getPathPropertyFromDeploymentModulePrefs(moduleTree, prefs, defaultFolder, "location", separator);
        return new Path(folder);
    }

    public IPath getModuleTreeDestinationFullPath(IModule[] moduleTree, IServerAttributes server, String defaultFolder, char separator) {
        DeploymentPreferences prefs = DeploymentPreferencesLoader.loadPreferencesFromServer(server);
        String folder = this.getPathPropertyFromDeploymentModulePrefs(moduleTree, prefs, defaultFolder, "location", separator);
        if (folder == null) {
            return null;
        }
        IPath ret = this.getModuleNestedDeployPath(moduleTree, folder, server, separator);
        return new RemotePath(ret.toString(), separator);
    }

    public IPath getModuleTempDeployPath(IModule[] moduleTree, IServerAttributes server, String defaultFolder, char separator) {
        DeploymentPreferences prefs = DeploymentPreferencesLoader.loadPreferencesFromServer(server);
        String folder = this.getPathPropertyFromDeploymentModulePrefs(moduleTree, prefs, defaultFolder, "tempLocation", separator);
        if (folder == null) {
            return null;
        }
        RemotePath rp = new RemotePath(folder, separator);
        System.out.println(rp.toString());
        System.out.println(rp.toOSString());
        return rp;
    }

    private String getPathPropertyFromDeploymentModulePrefs(IModule[] moduleTree, DeploymentPreferences prefs, String defaultFolder, String moduleProperty, char separator) {
        String loc;
        DeploymentTypePrefs typePrefs = prefs.getOrCreatePreferences();
        DeploymentModulePrefs modPrefs = typePrefs.getModulePrefs(moduleTree[0]);
        if (modPrefs != null && (loc = modPrefs.getProperty(moduleProperty)) != null && !loc.equals("")) {
            if (!new RemotePath(loc, separator).isAbsolute()) {
                RemotePath p = new RemotePath(defaultFolder, separator);
                String ret = p.append(loc).toOSString();
                return ret;
            }
            return loc;
        }
        return defaultFolder;
    }

    public IPath getModuleNestedDeployPath(IModule[] moduleTree, String rootFolder, IServerAttributes server) {
        return this.getModuleNestedDeployPath(moduleTree, rootFolder, server, File.separatorChar);
    }

    public IPath getModuleNestedDeployPath(IModule[] moduleTree, String rootFolder, IServerAttributes server, char separator) {
        RemotePath root = new RemotePath(rootFolder, separator);
        String customName = this.getOutputNameFromSettings(server, moduleTree[0]);
        if (customName != null) {
            root = root.append(customName);
        } else {
            String modName = null;
            if (moduleTree[0] instanceof IModule2) {
                modName = ((IModule2)moduleTree[0]).getProperty("org.eclipse.wst.server.core.deployName");
            }
            if (modName == null) {
                modName = moduleTree[0].getName();
            }
            String name = new RemotePath(modName, separator).lastSegment();
            String suffixedName = String.valueOf(name) + this.getDefaultSuffix(moduleTree[0]);
            root = root.append(suffixedName);
        }
        return root.append(this.getRootModuleRelativePath(server, moduleTree));
    }

    @Deprecated
    public IPath getRootModuleRelativePath(IServerAttributes server, IModule[] moduleTree) {
        return ServerModelUtilities.getRootModuleRelativePath((IServerAttributes)server, (IModule[])moduleTree);
    }

    protected String getOutputNameFromSettings(IServerAttributes server, IModule module) {
        String outName;
        DeploymentPreferences prefs = DeploymentPreferencesLoader.loadPreferencesFromServer(server);
        DeploymentTypePrefs typePrefs = prefs.getOrCreatePreferences();
        DeploymentModulePrefs modPrefs = typePrefs.getModulePrefs(module);
        if (modPrefs != null && (outName = modPrefs.getProperty("outputName")) != null && !outName.equals("")) {
            return outName;
        }
        return null;
    }

    public boolean getPrefersZipFromSettings(IServerAttributes server, IModule module, boolean defaultValue) {
        String ret;
        DeploymentPreferences prefs = DeploymentPreferencesLoader.loadPreferencesFromServer(server);
        DeploymentTypePrefs typePrefs = prefs.getOrCreatePreferences();
        DeploymentModulePrefs modPrefs = typePrefs.getModulePrefs(module);
        if (modPrefs != null && (ret = modPrefs.getProperty("zip")) != null && !ret.equals("")) {
            return Boolean.parseBoolean(ret);
        }
        return defaultValue;
    }

    public String getDefaultSuffix(IModule[] module) {
        IModule last = module == null ? null : module[module.length - 1];
        return this.getDefaultSuffix(last);
    }

    public String getDefaultSuffix(IModule module) {
        return ServerModelUtilities.getDefaultSuffixForModule((IModule)module);
    }

    public String getDefaultSuffix(String type) {
        return ServerModelUtilities.getDefaultSuffixForModuleType((String)type);
    }
}

