/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.as.core.server.controllable.systems;

import org.eclipse.wst.server.core.IModule;
import org.eclipse.wst.server.core.IServer;
import org.eclipse.wst.server.core.IServerAttributes;
import org.eclipse.wst.server.core.IServerWorkingCopy;
import org.jboss.ide.eclipse.as.core.JBossServerCorePlugin;
import org.jboss.ide.eclipse.as.core.publishers.PublishUtil;
import org.jboss.ide.eclipse.as.core.server.internal.ExtendedServerPropertiesAdapterFactory;
import org.jboss.ide.eclipse.as.core.server.internal.extendedproperties.JBossExtendedProperties;
import org.jboss.ide.eclipse.as.core.server.internal.extendedproperties.ServerExtendedProperties;
import org.jboss.ide.eclipse.as.wtp.core.server.behavior.AbstractSubsystemController;
import org.jboss.tools.as.core.internal.modules.DeploymentPreferences;
import org.jboss.tools.as.core.internal.modules.DeploymentPreferencesLoader;
import org.jboss.tools.as.core.internal.modules.ModuleDeploymentPrefsUtil;
import org.jboss.tools.as.core.server.controllable.systems.IDeploymentZipOptionsController;

public abstract class AbstractJBossDeploymentOptionsController
extends AbstractSubsystemController
implements IDeploymentZipOptionsController {
    protected static final String DEPLOY_METADATA = "metadata";
    protected static final String DEPLOY_SERVER = "server";
    protected static final String DEPLOY_CUSTOM = "custom";
    protected static final String DEPLOY_DIRECTORY = "org.jboss.ide.eclipse.as.core.server.deployDirectory";
    protected static final String TEMP_DEPLOY_DIRECTORY = "org.jboss.ide.eclipse.as.core.server.tempDeployDirectory";
    protected static final String DEPLOY_DIRECTORY_TYPE = "org.jboss.ide.eclipse.as.core.server.deployDirectoryType";
    protected static final String ZIP_DEPLOYMENTS_PREF = "org.jboss.ide.eclipse.as.core.server.zipDeploymentsPreference";

    protected IServerWorkingCopy getWorkingCopy() throws IllegalStateException {
        IServerWorkingCopy o = super.getWorkingCopy();
        if (o == null) {
            throw new IllegalStateException();
        }
        return o;
    }

    public abstract String makeGlobal(String var1);

    public abstract String makeRelative(String var1);

    @Override
    public String getDeploymentsRootFolder(boolean absolute) {
        String result = this.getDeployFolder(this.getCurrentDeploymentLocationType());
        if (result != null && absolute) {
            result = this.makeGlobal(result);
        }
        return result;
    }

    @Override
    public String getDeploymentsTemporaryFolder(boolean absolute) {
        String result = this.getTempDeployFolder(this.getCurrentDeploymentLocationType());
        if (result != null && absolute) {
            return this.makeGlobal(result);
        }
        return result;
    }

    public String getCurrentDeploymentLocationType() {
        return this.getServerOrWC().getAttribute(DEPLOY_DIRECTORY_TYPE, DEPLOY_CUSTOM);
    }

    public void setCurrentDeploymentLocationType(String type) throws IllegalStateException {
        this.getWorkingCopy().setAttribute(DEPLOY_DIRECTORY_TYPE, type);
    }

    public void setDeploymentsRootFolder(String folder) throws IllegalStateException {
        this.getWorkingCopy().setAttribute(DEPLOY_DIRECTORY, folder);
    }

    public void setDeploymentsTemporaryFolder(String folder) throws IllegalStateException {
        this.getWorkingCopy().setAttribute(TEMP_DEPLOY_DIRECTORY, folder);
    }

    public void setPrefersZippedDeployments(boolean val) throws IllegalStateException {
        this.getWorkingCopy().setAttribute(ZIP_DEPLOYMENTS_PREF, val);
    }

    @Override
    public boolean prefersZippedDeployments() {
        return this.getServerOrWC().getAttribute(ZIP_DEPLOYMENTS_PREF, false);
    }

    protected abstract String getDeployFolder(String var1);

    protected abstract String getTempDeployFolder(String var1);

    protected boolean isAS7Structure() {
        ServerExtendedProperties sep = ExtendedServerPropertiesAdapterFactory.getServerExtendedProperties(this.getServerOrWC());
        return sep != null && sep.getFileStructure() == 2;
    }

    protected boolean isDeployOnlyServer() {
        return this.getServer().getServerType().getId().equals("org.jboss.ide.eclipse.as.systemCopyServer");
    }

    protected String getMetadataDeployLocation(IServer server) {
        return JBossServerCorePlugin.getServerStateLocation(server).append("deploy").makeAbsolute().toString();
    }

    protected JBossExtendedProperties getExtendedProperties() {
        return (JBossExtendedProperties)this.getServer().loadAdapter(ServerExtendedProperties.class, null);
    }

    private ModuleDeploymentPrefsUtil createModuleDeploymentPrefsUtil() {
        return new ModuleDeploymentPrefsUtil();
    }

    @Override
    public boolean shouldZipDeployment(IModule[] module) {
        boolean defaultZipOption;
        boolean serverPrefersZip = this.prefersZippedDeployments();
        boolean forceZip = PublishUtil.deployPackaged(module, this.getServer());
        boolean bl = defaultZipOption = serverPrefersZip || forceZip;
        if (module != null && module.length > 0) {
            IServerAttributes server = this.getServerOrWC();
            boolean ret = this.createModuleDeploymentPrefsUtil().getPrefersZipFromSettings(server, module[module.length - 1], defaultZipOption);
            return ret;
        }
        return defaultZipOption;
    }

    @Override
    public void setShouldZipDeployment(IModule[] module, Boolean value) {
        this.setModuleDeploymentPreference(module[module.length - 1], "zip", value == null ? "" : value.toString());
    }

    private void verifyWorkingCopy() throws IllegalStateException {
        IServerWorkingCopy wc = this.getWorkingCopy();
        if (wc == null) {
            throw new IllegalStateException("This controller requires a server working-copy.");
        }
    }

    protected void setModuleDeploymentPreference(IModule module, String key, String val) {
        this.verifyWorkingCopy();
        DeploymentPreferences prefs = DeploymentPreferencesLoader.loadPreferencesFromServer(this.getServerOrWC());
        prefs.setModulePreferenceValue(module, key, val);
        DeploymentPreferencesLoader.savePreferencesToServerWorkingCopy(this.getWorkingCopy(), prefs);
    }
}

