/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.ide.eclipse.as.ui.dialogs;

import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.TreeSet;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Path;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.dialogs.ProgressMonitorDialog;
import org.eclipse.jface.dialogs.TitleAreaDialog;
import org.eclipse.jface.fieldassist.ContentProposalAdapter;
import org.eclipse.jface.fieldassist.IContentProposal;
import org.eclipse.jface.fieldassist.IContentProposalProvider;
import org.eclipse.jface.fieldassist.IControlContentAdapter;
import org.eclipse.jface.fieldassist.TextContentAdapter;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ITableLabelProvider;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.FormAttachment;
import org.eclipse.swt.layout.FormData;
import org.eclipse.swt.layout.FormLayout;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.DirectoryDialog;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.eclipse.swt.widgets.Tree;
import org.eclipse.swt.widgets.TreeColumn;
import org.eclipse.ui.PlatformUI;
import org.eclipse.wst.server.core.IRuntime;
import org.eclipse.wst.server.core.IServer;
import org.jboss.ide.eclipse.as.core.extensions.descriptors.XMLDocumentRepository;
import org.jboss.ide.eclipse.as.core.extensions.descriptors.XPathCategory;
import org.jboss.ide.eclipse.as.core.extensions.descriptors.XPathFileResult;
import org.jboss.ide.eclipse.as.core.extensions.descriptors.XPathModel;
import org.jboss.ide.eclipse.as.core.extensions.descriptors.XPathQuery;
import org.jboss.ide.eclipse.as.core.resolvers.RuntimeVariableResolver;
import org.jboss.ide.eclipse.as.core.server.internal.JBossServer;
import org.jboss.ide.eclipse.as.core.server.internal.extendedproperties.JBossExtendedProperties;
import org.jboss.ide.eclipse.as.core.util.ServerConverter;
import org.jboss.ide.eclipse.as.ui.Messages;
import org.jboss.tools.foundation.core.expressions.ExpressionResolver;
import org.jboss.tools.foundation.core.expressions.IVariableResolver;

public class XPathDialogs {
    public static String getConfigFolder(IServer server) {
        JBossServer jbs = (JBossServer)server.loadAdapter(JBossServer.class, (IProgressMonitor)new NullProgressMonitor());
        if (jbs != null) {
            return jbs.getConfigDirectory();
        }
        return server.getRuntime().getLocation().toOSString();
    }

    public static class XPathAttributeProposalProvider
    extends XPathProposalProvider {
        private Text elementText;

        public XPathAttributeProposalProvider(XMLDocumentRepository repo, Text elementText) {
            super(repo);
            this.elementText = elementText;
        }

        @Override
        public IContentProposal[] getProposals(String contents, int position) {
            String[] strings = this.getAttributeNameProposalStrings(this.elementText.getText(), contents.trim());
            return this.convertProposals(strings);
        }

        @Override
        public String[] getAttributeNameProposalStrings(String parentPath, String remainder) {
            ArrayList<String> names = new ArrayList<String>();
            XPathFileResult.XPathResultNode[] items = this.getXPath(parentPath);
            int i = 0;
            while (i < items.length) {
                String[] attributes = items[0].getElementAttributeNames();
                int j = 0;
                while (j < attributes.length) {
                    if (attributes[j].startsWith(remainder) && !names.contains(attributes[j])) {
                        names.add(attributes[j]);
                    }
                    ++j;
                }
                ++i;
            }
            return names.toArray(new String[names.size()]);
        }
    }

    public static class XPathCategoryDialog
    extends Dialog {
        private String initialName;
        private String currentText;
        private IServer server;
        private Label errorLabel;

        public XPathCategoryDialog(Shell parentShell, IServer server) {
            super(parentShell);
            this.server = server;
        }

        public XPathCategoryDialog(Shell parentShell, IServer server, String initialName) {
            this(parentShell, server);
            this.initialName = initialName;
        }

        protected void configureShell(Shell shell) {
            super.configureShell(shell);
            shell.setText(Messages.XPathNewCategory);
        }

        protected Control createDialogArea(Composite parent) {
            Composite c = (Composite)super.createDialogArea(parent);
            c.setLayout((Layout)new FormLayout());
            this.errorLabel = new Label(c, 0);
            this.errorLabel.setText(Messages.XPathNewCategoryNameInUse);
            FormData errorData = new FormData();
            errorData.left = new FormAttachment(0, 5);
            errorData.top = new FormAttachment(0, 5);
            this.errorLabel.setLayoutData((Object)errorData);
            this.errorLabel.setVisible(false);
            Label l = new Label(c, 0);
            l.setText(Messages.XPathCategoryName);
            FormData labelData = new FormData();
            labelData.left = new FormAttachment(0, 5);
            labelData.top = new FormAttachment((Control)this.errorLabel, 5);
            l.setLayoutData((Object)labelData);
            final Text t = new Text(c, 2048);
            FormData tData = new FormData();
            tData.left = new FormAttachment((Control)l, 5);
            tData.top = new FormAttachment((Control)this.errorLabel, 5);
            tData.right = new FormAttachment(100, -5);
            t.setLayoutData((Object)tData);
            if (this.currentText != null) {
                t.setText(this.currentText);
            }
            t.addModifyListener(new ModifyListener(){

                public void modifyText(ModifyEvent e) {
                    XPathCategoryDialog.this.verifyText(t.getText());
                }
            });
            return c;
        }

        private void verifyText(String text) {
            boolean valid;
            boolean bl = valid = !XPathModel.getDefault().containsCategory(this.server, text) || this.initialName != null && this.initialName.equals(text);
            if (valid) {
                this.errorLabel.setVisible(false);
                this.currentText = text;
                this.getButton(0).setEnabled(true);
            } else {
                this.errorLabel.setVisible(true);
                this.getButton(0).setEnabled(false);
            }
        }

        public String getText() {
            return this.currentText;
        }
    }

    public static class XPathDialog
    extends TitleAreaDialog {
        protected Text nameText;
        protected Text baseDirText;
        protected Text filesetText;
        protected Text xpathText;
        protected Text attributeText;
        protected Label nameLabel;
        protected Label baseDirLabel;
        protected Label filesetLabel;
        protected Label xpathLabel;
        protected Label attributeLabel;
        protected Button previewButton;
        protected Button rootDirBrowse;
        protected XPathProposalProvider proposalProvider;
        protected IServer server;
        protected String name;
        protected String rootDir;
        protected String filePattern;
        protected String xpath;
        protected String attribute;
        protected String originalName = null;
        protected XPathQuery original = null;
        protected XPathCategory category;
        protected int previewId = 48879;
        protected Tree previewTree;
        protected TreeColumn column;
        protected TreeColumn column2;
        protected TreeViewer previewTreeViewer;
        protected Composite main;
        protected XMLDocumentRepository repository;

        public XPathDialog(Shell parentShell, IServer server) {
            this(parentShell, server, null);
        }

        public XPathDialog(Shell parentShell, IServer server, XPathQuery original) {
            super(parentShell);
            this.setShellStyle(this.getShellStyle() | 0x10);
            this.server = server;
            this.repository = new XMLDocumentRepository(null);
            if (original != null) {
                this.original = original;
                this.originalName = this.name = original.getName();
                this.filePattern = original.getFilePattern();
                this.rootDir = original.getBaseDir();
                this.category = original.getCategory();
                this.xpath = original.getXpathPattern();
                this.attribute = original.getAttribute();
            }
            if (this.xpath == null) {
                this.xpath = "//server/mbean";
            }
            if (this.filePattern == null) {
                this.filePattern = "**/*.xml";
            }
            if (this.rootDir == null) {
                String defaultRootDir;
                JBossServer jbs = server == null ? null : (JBossServer)ServerConverter.getJBossServer((IServer)server);
                JBossExtendedProperties properties = jbs == null ? null : jbs.getExtendedProperties();
                this.rootDir = defaultRootDir = properties == null ? "" : properties.getNewFilesetDefaultRootFolder();
            }
        }

        protected void configureShell(Shell shell) {
            super.configureShell(shell);
            String title = this.original == null ? Messages.XPathNewXpath : Messages.XPathEditXpath;
            shell.setText(title);
            shell.setBounds(shell.getLocation().x, shell.getLocation().y, 550, 500);
        }

        protected int getShellStyle() {
            int ret = super.getShellStyle();
            return ret | 0x10;
        }

        protected void createButtonsForButtonBar(Composite parent) {
            super.createButtonsForButtonBar(parent);
            this.previewButton = this.createButton(parent, this.previewId, Messages.XPathDialogs_PreviewButton, true);
            if (this.name == null) {
                this.getButton(0).setEnabled(false);
            }
            this.addListeners();
            this.checkErrors();
        }

        protected Control createDialogArea(Composite parent) {
            String title = this.original == null ? Messages.XPathNewXpath : Messages.XPathEditXpath;
            this.setTitle(title);
            this.main = new Composite((Composite)super.createDialogArea(parent), 0);
            this.main.setLayoutData((Object)new GridData(1808));
            this.main.setLayout((Layout)new FormLayout());
            this.layoutWidgets(this.main);
            if (this.name != null) {
                this.nameText.setText(this.name);
            }
            if (this.attribute != null) {
                this.attributeText.setText(this.attribute);
            }
            if (this.xpath != null) {
                this.xpathText.setText(this.xpath);
            }
            if (this.filePattern != null) {
                this.filesetText.setText(this.filePattern);
            }
            if (this.rootDir != null) {
                this.baseDirText.setText(this.rootDir);
            }
            this.proposalProvider = new XPathProposalProvider(this.repository);
            if (this.server != null) {
                this.proposalProvider.setPath(XPathDialogs.getConfigFolder(this.server));
            }
            ContentProposalAdapter adapter = new ContentProposalAdapter((Control)this.xpathText, (IControlContentAdapter)new TextContentAdapter(), (IContentProposalProvider)this.proposalProvider, null, null);
            adapter.setProposalAcceptanceStyle(2);
            XPathAttributeProposalProvider provider2 = new XPathAttributeProposalProvider(this.repository, this.xpathText);
            if (this.server != null) {
                provider2.setPath(XPathDialogs.getConfigFolder(this.server));
            }
            ContentProposalAdapter adapter2 = new ContentProposalAdapter((Control)this.attributeText, (IControlContentAdapter)new TextContentAdapter(), (IContentProposalProvider)provider2, null, null);
            adapter2.setProposalAcceptanceStyle(2);
            return this.main;
        }

        protected void addListeners() {
            this.nameText.addModifyListener(new ModifyListener(){

                public void modifyText(ModifyEvent e) {
                    XPathDialog.this.checkErrors();
                    XPathDialog.this.name = XPathDialog.this.nameText.getText();
                }
            });
            this.attributeText.addModifyListener(new ModifyListener(){

                public void modifyText(ModifyEvent e) {
                    XPathDialog.this.attribute = XPathDialog.this.attributeText.getText();
                }
            });
            this.xpathText.addModifyListener(new ModifyListener(){

                public void modifyText(ModifyEvent e) {
                    XPathDialog.this.xpath = XPathDialog.this.xpathText.getText();
                }
            });
            this.baseDirText.addModifyListener(new ModifyListener(){

                public void modifyText(ModifyEvent e) {
                    XPathDialog.this.rootDir = XPathDialog.this.baseDirText.getText();
                }
            });
            this.filesetText.addModifyListener(new ModifyListener(){

                public void modifyText(ModifyEvent e) {
                    XPathDialog.this.filePattern = XPathDialog.this.filesetText.getText();
                }
            });
            this.rootDirBrowse.addSelectionListener(new SelectionListener(){

                public void widgetSelected(SelectionEvent e) {
                    XPathDialog.this.browsePressed();
                }

                public void widgetDefaultSelected(SelectionEvent e) {
                }
            });
            this.previewButton.addSelectionListener(new SelectionListener(){

                public void widgetDefaultSelected(SelectionEvent e) {
                }

                public void widgetSelected(SelectionEvent e) {
                    XPathDialog.this.previewPressed();
                }
            });
        }

        protected void checkErrors() {
            ArrayList<String> errorList = this.getErrors();
            if (errorList.size() == 0) {
                this.setError(null);
                this.getButton(0).setEnabled(true);
                return;
            }
            this.setError(errorList.get(0));
            if (this.getButton(0) != null) {
                this.getButton(0).setEnabled(false);
            }
        }

        protected ArrayList<String> getErrors() {
            String nameError;
            ArrayList<String> list = new ArrayList<String>();
            String serverError = this.getServerError();
            if (serverError != null) {
                list.add(serverError);
            }
            if ((nameError = this.getNameError()) != null) {
                list.add(nameError);
            }
            return list;
        }

        protected String getServerError() {
            if (this.server == null) {
                return Messages.XPathDialogs_SelectServer;
            }
            return null;
        }

        protected void setError(String message) {
            if (message == null) {
                this.setMessage(Messages.XPathDialogs_XPathDescriptionLabel);
            } else {
                this.setMessage(message, 3);
            }
        }

        protected String getNameError() {
            if (this.nameText.getText().equals("")) {
                return Messages.XPathNameEmpty;
            }
            if (this.category != null) {
                XPathQuery[] queries = this.category.getQueries();
                int i = 0;
                while (i < queries.length) {
                    if (this.nameText.getText().equals(queries[i].getName()) && (this.originalName == null || !this.nameText.getText().equals(this.originalName))) {
                        return Messages.XPathNameInUse;
                    }
                    ++i;
                }
            }
            return null;
        }

        protected void browsePressed() {
            DirectoryDialog d = new DirectoryDialog(this.rootDirBrowse.getShell());
            String folder = this.rootDir;
            if (!new Path(this.rootDir).isAbsolute()) {
                folder = this.server.getRuntime().getLocation().append(this.rootDir).toString();
            }
            d.setFilterPath(folder);
            String result = d.open();
            if (result != null) {
                Path result2 = new Path(result);
                IRuntime rt = this.server.getRuntime();
                if (result2.isAbsolute() && rt != null && rt.getLocation().isPrefixOf((IPath)result2)) {
                    int size = rt.getLocation().toOSString().length();
                    result2 = new Path(result2.toOSString().substring(size)).makeRelative();
                }
                this.rootDir = result2.toString();
                this.baseDirText.setText(this.rootDir);
            }
        }

        private String getReplacedString(String original) {
            RuntimeVariableResolver resolver = new RuntimeVariableResolver(this.server.getRuntime());
            ExpressionResolver process = new ExpressionResolver((IVariableResolver)resolver);
            return process.resolve(original);
        }

        protected void previewPressed() {
            if (this.server == null) {
                this.checkErrors();
                return;
            }
            final String xpText = this.xpathText.getText();
            final String attText = this.attributeText.getText();
            String filePattern = this.filesetText.getText();
            String directory = this.baseDirText.getText();
            if (!new Path(directory = this.getReplacedString(directory)).isAbsolute()) {
                directory = this.server.getRuntime().getLocation().append(directory).toString();
            }
            final String directory2 = directory;
            final String filePattern2 = filePattern = this.getReplacedString(filePattern);
            IRunnableWithProgress op = new IRunnableWithProgress(){

                public void run(IProgressMonitor monitor) throws InvocationTargetException, InterruptedException {
                    XPathQuery tmp = new XPathQuery(XPathDialog.this.server, "", directory2, filePattern2, xpText, attText);
                    tmp.setRepository(XPathDialog.this.repository);
                    final ArrayList<XPathFileResult> list = new ArrayList<XPathFileResult>();
                    list.addAll(Arrays.asList(tmp.getResults()));
                    Display.getDefault().asyncExec(new Runnable(){

                        @Override
                        public void run() {
                            (this).XPathDialog.this.previewTreeViewer.setInput((Object)list);
                            if (list.size() == 0) {
                                XPathDialog.this.setError(Messages.XPathDialogs_NoElementsMatched);
                                (this).XPathDialog.this.previewTreeViewer.getTree().setEnabled(false);
                            } else {
                                (this).XPathDialog.this.previewTreeViewer.getTree().setEnabled(true);
                                XPathDialog.this.checkErrors();
                            }
                            if ((this).XPathDialog.this.main != null) {
                                (this).XPathDialog.this.main.layout();
                            }
                        }
                    });
                }
            };
            try {
                new ProgressMonitorDialog(PlatformUI.getWorkbench().getActiveWorkbenchWindow().getShell()).run(true, true, op);
            }
            catch (InvocationTargetException invocationTargetException) {
            }
            catch (InterruptedException interruptedException) {}
        }

        protected void layoutWidgets(Composite c) {
            Composite middleComposite = this.createMiddleComposite(c);
            this.previewTree = new Tree(c, 2048);
            this.previewTree.setHeaderVisible(true);
            this.previewTree.setLinesVisible(true);
            this.column = new TreeColumn(this.previewTree, 0);
            this.column2 = new TreeColumn(this.previewTree, 0);
            this.column.setText(Messages.XPathColumnLocation);
            this.column2.setText(Messages.XPathColumnAttributeVals);
            this.column.setWidth(150);
            this.column2.setWidth(150);
            this.previewTreeViewer = new TreeViewer(this.previewTree);
            c.layout();
            FormData middleCompositeData = new FormData();
            middleCompositeData.left = new FormAttachment(0, 5);
            middleCompositeData.right = new FormAttachment(100, -5);
            middleCompositeData.top = new FormAttachment(0, 5);
            middleComposite.setLayoutData((Object)middleCompositeData);
            FormData previewTreeData = new FormData();
            previewTreeData.left = new FormAttachment(0, 5);
            previewTreeData.right = new FormAttachment(100, -5);
            previewTreeData.top = new FormAttachment((Control)middleComposite, 5);
            previewTreeData.bottom = new FormAttachment(100, -5);
            this.previewTree.setLayoutData((Object)previewTreeData);
            this.previewTreeViewer.setContentProvider((IContentProvider)new ITreeContentProvider(){

                public Object[] getChildren(Object parentElement) {
                    if (parentElement instanceof XPathFileResult.XPathResultNode) {
                        return new Object[0];
                    }
                    if (parentElement instanceof XPathFileResult) {
                        if (((XPathFileResult)parentElement).getChildren().length > 1) {
                            return ((XPathFileResult)parentElement).getChildren();
                        }
                        return new Object[0];
                    }
                    if (parentElement instanceof XPathQuery) {
                        Object[] kids = ((XPathQuery)parentElement).getResults();
                        return kids;
                    }
                    return new Object[0];
                }

                public Object getParent(Object element) {
                    return null;
                }

                public boolean hasChildren(Object element) {
                    return this.getChildren(element).length > 0;
                }

                public Object[] getElements(Object inputElement) {
                    if (inputElement instanceof ArrayList) {
                        return ((ArrayList)inputElement).toArray();
                    }
                    return new Object[0];
                }

                public void dispose() {
                }

                public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
                }
            });
            this.previewTreeViewer.setLabelProvider((IBaseLabelProvider)new XPathPropertyLabelProvider());
        }

        protected Composite createMiddleComposite(Composite c) {
            Composite gridComposite = new Composite(c, 0);
            gridComposite.setLayout((Layout)new GridLayout(2, false));
            this.nameLabel = new Label(gridComposite, 0);
            this.nameText = new Text(gridComposite, 2048);
            this.nameText.setLayoutData((Object)new GridData(4, 0x1000000, true, true));
            this.baseDirLabel = new Label(gridComposite, 0);
            Composite baseDirTextAndButton = new Composite(gridComposite, 0);
            baseDirTextAndButton.setLayout((Layout)new FormLayout());
            baseDirTextAndButton.setLayoutData((Object)new GridData(4, 0x1000000, true, true));
            this.baseDirText = new Text(baseDirTextAndButton, 2048);
            this.rootDirBrowse = new Button(baseDirTextAndButton, 8);
            this.rootDirBrowse.setText(Messages.browse);
            FormData d = new FormData();
            d.right = new FormAttachment(100, -5);
            this.rootDirBrowse.setLayoutData((Object)d);
            d = new FormData();
            d.left = new FormAttachment(0, 0);
            d.right = new FormAttachment((Control)this.rootDirBrowse, -5);
            this.baseDirText.setLayoutData((Object)d);
            this.filesetLabel = new Label(gridComposite, 0);
            this.filesetText = new Text(gridComposite, 2048);
            this.filesetText.setLayoutData((Object)new GridData(4, 0x1000000, true, true));
            this.xpathLabel = new Label(gridComposite, 0);
            this.xpathText = new Text(gridComposite, 2048);
            this.xpathText.setLayoutData((Object)new GridData(4, 0x1000000, true, true));
            this.attributeLabel = new Label(gridComposite, 0);
            this.attributeText = new Text(gridComposite, 2048);
            this.attributeText.setLayoutData((Object)new GridData(4, 0x1000000, true, true));
            this.nameLabel.setText(Messages.XPathName);
            this.xpathLabel.setText(Messages.XPathPattern);
            this.attributeLabel.setText(Messages.XPathAttribute);
            this.filesetLabel.setText(Messages.XPathFilePattern);
            this.baseDirLabel.setText(Messages.XPathRootDir);
            return gridComposite;
        }

        public String getAttribute() {
            return this.attribute;
        }

        public String getName() {
            return this.name;
        }

        public String getXpath() {
            return this.xpath;
        }

        public String getBaseDir() {
            return this.rootDir;
        }

        public String getFilePattern() {
            return this.filePattern;
        }
    }

    public static class XPathPropertyLabelProvider
    extends LabelProvider
    implements ITableLabelProvider {
        public Image getColumnImage(Object element, int columnIndex) {
            return null;
        }

        public String getColumnText(Object element, int columnIndex) {
            if (element instanceof XPathQuery) {
                XPathFileResult.XPathResultNode[] nodes;
                if (columnIndex == 0) {
                    return ((XPathQuery)element).getName();
                }
                if (columnIndex == 1 && (nodes = this.getResultNodes((XPathQuery)element)).length == 1) {
                    return nodes[0].getText();
                }
            }
            if (element instanceof XPathFileResult) {
                XPathFileResult result = (XPathFileResult)element;
                if (columnIndex == 0) {
                    String substr = result.getFileLocation().substring(result.getQuery().getBaseDir().length());
                    return new Path(substr).makeRelative().toString();
                }
                if (result.getChildren().length == 1) {
                    element = result.getChildren()[0];
                }
            }
            if (element instanceof XPathFileResult.XPathResultNode) {
                XPathFileResult.XPathResultNode element2 = (XPathFileResult.XPathResultNode)element;
                if (columnIndex == 0) {
                    return String.valueOf(Messages.DescriptorXPathMatch) + element2.getIndex();
                }
                if (columnIndex == 1) {
                    return element2.getText().trim();
                }
            }
            return null;
        }

        public XPathFileResult.XPathResultNode[] getResultNodes(XPathQuery query) {
            ArrayList<XPathFileResult.XPathResultNode> l = new ArrayList<XPathFileResult.XPathResultNode>();
            XPathFileResult[] files = query.getResults();
            int i = 0;
            while (i < files.length) {
                l.addAll(Arrays.asList(files[i].getChildren()));
                ++i;
            }
            return l.toArray(new XPathFileResult.XPathResultNode[l.size()]);
        }
    }

    public static class XPathProposalProvider
    implements IContentProposalProvider {
        protected static final int NEW_ELEMENT = 1;
        protected static final int NEW_ATTRIBUTE = 2;
        protected static final int NEW_ATTRIBUTE_VALUE = 3;
        protected static final int IN_ELEMENT = 4;
        protected static final int IN_ATTRIBUTE = 5;
        protected static final int IN_ATTRIBUTE_VALUE = 6;
        protected static final int CLOSE_ATTRIBUTE = 7;
        private String path;
        private HashMap<String, ArrayList<XPathFileResult.XPathResultNode>> xpathCache = new HashMap();
        protected XMLDocumentRepository repository;

        public XPathProposalProvider(XMLDocumentRepository repository) {
            this.repository = repository;
        }

        public void setPath(String path) {
            this.path = path;
        }

        public IContentProposal[] getProposals(String contents, int position) {
            if (contents.equals("") || contents.equals("/") || contents.equals(" ")) {
                return new IContentProposal[]{new XPathContentProposal("/server/", "/server/".length(), null, null)};
            }
            int type = this.getType(contents);
            if (type == 1) {
                return this.getElementProposals(contents, "");
            }
            if (type == 4) {
                return this.getElementProposals(contents);
            }
            if (type == 2) {
                return this.getAttributeNameProposals(contents.substring(0, contents.length() - 1), "");
            }
            if (type == 5) {
                return this.getAttributeNameProposals(contents);
            }
            if (type == 3) {
                return this.getAttributeValueProposals(contents, "");
            }
            if (type == 6) {
                return this.getAttributeValueProposals(contents);
            }
            return new IContentProposal[0];
        }

        protected XPathFileResult.XPathResultNode[] getXPath(String xpath) {
            if (this.path == null) {
                return new XPathFileResult.XPathResultNode[0];
            }
            if (this.xpathCache.containsKey(xpath)) {
                ArrayList<XPathFileResult.XPathResultNode> list = this.xpathCache.get(xpath);
                return list.toArray(new XPathFileResult.XPathResultNode[list.size()]);
            }
            XPathQuery tmp = new XPathQuery(null, "", this.path, "**/*.xml", xpath, null);
            tmp.setRepository(this.repository);
            ArrayList<XPathFileResult.XPathResultNode> list = new ArrayList<XPathFileResult.XPathResultNode>();
            XPathFileResult[] items = tmp.getResults();
            int i = 0;
            while (i < items.length) {
                XPathFileResult.XPathResultNode[] children = items[i].getChildren();
                int j = 0;
                while (j < children.length) {
                    XPathFileResult.XPathResultNode i2 = children[j];
                    list.add(i2);
                    ++j;
                }
                ++i;
            }
            this.xpathCache.put(xpath, list);
            return list.toArray(new XPathFileResult.XPathResultNode[list.size()]);
        }

        public IContentProposal[] getElementProposals(String path) {
            String parentPath = path.substring(0, path.lastIndexOf(47) + 1);
            String prefix = path.substring(path.lastIndexOf(47) + 1);
            return this.getElementProposals(parentPath, prefix);
        }

        public IContentProposal[] getElementProposals(String parentPath, String elementPrefix) {
            String[] strings = this.getElementProposalStrings(parentPath, elementPrefix);
            return this.convertProposals(strings);
        }

        public String[] getElementProposalStrings(String parentPath, String elementPrefix) {
            TreeSet<String> set = new TreeSet<String>();
            XPathFileResult.XPathResultNode[] items = this.getXPath(String.valueOf(parentPath) + "*");
            int i = 0;
            while (i < items.length) {
                if (items[i].getElementName().startsWith(elementPrefix)) {
                    if (items[i].getElementName().equals(elementPrefix)) {
                        set.addAll(Arrays.asList(this.getAttributeNameProposalStrings(String.valueOf(parentPath) + elementPrefix, "")));
                    } else {
                        set.add(String.valueOf(parentPath) + items[i].getElementName());
                    }
                }
                ++i;
            }
            return set.toArray(new String[set.size()]);
        }

        public IContentProposal[] getAttributeNameProposals(String path) {
            String parent = path.substring(0, path.lastIndexOf(91));
            int attName = path.lastIndexOf(91) > path.lastIndexOf(64) ? path.lastIndexOf(91) : path.lastIndexOf(64);
            String[] props = this.getAttributeNameProposalStrings(parent, path.substring(attName + 1));
            return this.convertProposals(props);
        }

        public IContentProposal[] getAttributeNameProposals(String parentPath, String remainder) {
            return this.convertProposals(this.getAttributeNameProposalStrings(parentPath, remainder));
        }

        public String[] getAttributeNameProposalStrings(String parentPath, String remainder) {
            ArrayList<String> names = new ArrayList<String>();
            XPathFileResult.XPathResultNode[] items = this.getXPath(parentPath);
            int i = 0;
            while (i < items.length) {
                String[] attributes = items[i].getElementAttributeNames();
                int j = 0;
                while (j < attributes.length) {
                    if (attributes[j].startsWith(remainder) && !names.contains(attributes[j])) {
                        names.add(attributes[j]);
                    }
                    ++j;
                }
                ++i;
            }
            String[] results = new String[names.size()];
            int i2 = 0;
            while (i2 < results.length) {
                results[i2] = String.valueOf(parentPath) + "[@" + (String)names.get(i2) + "=";
                ++i2;
            }
            return results;
        }

        public IContentProposal[] getAttributeValueProposals(String path) {
            return this.getAttributeValueProposals(path.substring(0, path.lastIndexOf(61)), path.substring(path.lastIndexOf(61) + 1));
        }

        public IContentProposal[] getAttributeValueProposals(String parentPath, String remainder) {
            int eqIndex;
            String parentElementPath = parentPath.substring(0, parentPath.lastIndexOf(91));
            int brackIndex = parentPath.lastIndexOf(91);
            int n = eqIndex = parentPath.lastIndexOf(61) == -1 ? parentPath.length() : parentPath.lastIndexOf(61);
            if (eqIndex < brackIndex) {
                eqIndex = parentPath.length();
            }
            String attName = parentPath.substring(brackIndex + 2, eqIndex);
            if (remainder.startsWith("'")) {
                remainder = remainder.substring(1);
            }
            ArrayList<String> values = new ArrayList<String>();
            XPathFileResult.XPathResultNode[] items = this.getXPath(parentElementPath);
            int i = 0;
            while (i < items.length) {
                String[] attributes = items[i].getElementAttributeValues(attName);
                int j = 0;
                while (j < attributes.length) {
                    if (attributes[j].startsWith(remainder) && !values.contains(attributes[j])) {
                        values.add(attributes[j]);
                    }
                    ++j;
                }
                ++i;
            }
            Object[] results = new String[values.size()];
            String prefix = String.valueOf(parentElementPath) + "[@" + attName + "='";
            int i2 = 0;
            while (i2 < results.length) {
                results[i2] = String.valueOf(prefix) + (String)values.get(i2) + "']/";
                ++i2;
            }
            Arrays.sort(results);
            return this.convertProposals((String[])results);
        }

        public int getType(String contents) {
            switch (contents.charAt(contents.length() - 1)) {
                case '/': {
                    return 1;
                }
                case '[': {
                    return 2;
                }
                case ']': {
                    return 7;
                }
                case '=': {
                    return 3;
                }
            }
            int max = -1;
            int lastSlash = contents.lastIndexOf(47);
            max = lastSlash > max ? lastSlash : max;
            int lastOpenBracket = contents.lastIndexOf(91);
            max = lastOpenBracket > max ? lastOpenBracket : max;
            int lastCloseBracket = contents.lastIndexOf(93);
            max = lastCloseBracket > max ? lastCloseBracket : max;
            int lastEquals = contents.lastIndexOf(61);
            int n = max = lastEquals > max ? lastEquals : max;
            if (max == lastSlash) {
                return 4;
            }
            if (max == lastOpenBracket) {
                return 5;
            }
            if (max == lastCloseBracket) {
                return 7;
            }
            if (max == lastEquals) {
                return 6;
            }
            return -1;
        }

        public IContentProposal[] convertProposals(String[] strings) {
            ArrayList<XPathContentProposal> list = new ArrayList<XPathContentProposal>();
            int i = 0;
            while (i < strings.length) {
                list.add(new XPathContentProposal(strings[i], strings[i].length(), null, null));
                ++i;
            }
            return list.toArray(new IContentProposal[list.size()]);
        }

        public class XPathContentProposal
        implements IContentProposal {
            private String content;
            private String description;
            private String label;
            private int position;

            public XPathContentProposal(String content, int position, String description, String label) {
                this.content = content;
                this.description = description;
                this.label = label;
                this.position = position;
            }

            public String getContent() {
                return this.content;
            }

            public int getCursorPosition() {
                return this.position;
            }

            public String getDescription() {
                return this.description;
            }

            public String getLabel() {
                return this.label;
            }
        }
    }
}

