/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.ide.eclipse.as.ui.editor;

import java.util.regex.Pattern;
import java.util.regex.PatternSyntaxException;
import org.eclipse.core.commands.operations.IUndoableOperation;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.FormLayout;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorSite;
import org.eclipse.ui.forms.widgets.FormToolkit;
import org.eclipse.ui.forms.widgets.Section;
import org.eclipse.wst.server.core.IServerAttributes;
import org.eclipse.wst.server.core.IServerWorkingCopy;
import org.eclipse.wst.server.ui.editor.ServerEditorSection;
import org.jboss.ide.eclipse.as.core.server.internal.DeployableServer;
import org.jboss.ide.eclipse.as.core.util.ServerAttributeHelper;
import org.jboss.ide.eclipse.as.core.util.ServerConverter;
import org.jboss.ide.eclipse.as.ui.editor.Messages;
import org.jboss.ide.eclipse.as.ui.editor.ServerWorkingCopyPropertyComboCommand;
import org.jboss.ide.eclipse.as.wtp.ui.editor.ServerWorkingCopyPropertyButtonCommand;
import org.jboss.ide.eclipse.as.wtp.ui.editor.ServerWorkingCopyPropertyCommand;
import org.jboss.ide.eclipse.as.wtp.ui.util.FormDataUtility;

public class ModuleRestartSection
extends ServerEditorSection {
    private Button useDefaultPattern;
    private Button overrideHotcodeButton;
    private Combo hotcodeCombo;
    private Text restartPatternText;
    private SelectionListener checkboxListener;
    private ModifyListener comboListener;
    private SelectionListener hotcodeCheckboxListener;
    private ModifyListener textListener;
    protected ServerAttributeHelper helper;
    private String[] hotcodeReplaceStrings;
    private int[] hotcodeReplaceCodes;

    public void init(IEditorSite site, IEditorInput input) {
        super.init(site, input);
        this.helper = new ServerAttributeHelper(this.server.getOriginal(), this.server);
    }

    public void createSection(Composite parent) {
        super.createSection(parent);
        this.createUI(parent);
        DeployableServer ds = (DeployableServer)ServerConverter.getDeployableServer((IServerAttributes)this.server.getOriginal());
        String defaultPattern = ds.getDefaultModuleRestartPattern();
        String pattern = this.server.getAttribute("org.jboss.tools.as.restartFilePattern", defaultPattern);
        String useDef = this.server.getAttribute("org.jboss.tools.as.useDefaultRestartFilePattern", Boolean.TRUE.toString());
        boolean useDefB = new Boolean(useDef);
        this.useDefaultPattern.setSelection(useDefB);
        this.restartPatternText.setEnabled(!useDefB);
        this.restartPatternText.setText(pattern == null || useDefB ? defaultPattern : pattern);
        boolean customizeHotcode = this.server.getAttribute("org.jboss.ide.eclipse.as.wtp.core.server.launch.OverrideHotCodeReplace", true);
        int customizedBehavior = this.server.getAttribute("org.jboss.ide.eclipse.as.wtp.core.server.launch.hotCodeReplace", 0);
        this.overrideHotcodeButton.setSelection(customizeHotcode);
        this.hotcodeCombo.setEnabled(customizeHotcode);
        this.hotcodeCombo.select(customizedBehavior);
        this.addListeners();
    }

    protected void createUI(Composite parent) {
        FormToolkit toolkit = new FormToolkit(parent.getDisplay());
        Section section = toolkit.createSection(parent, 322);
        section.setText(Messages.ModuleRestartSection_title);
        section.setLayoutData((Object)new GridData(784));
        Composite composite = toolkit.createComposite((Composite)section);
        composite.setLayout((Layout)new FormLayout());
        Label desc = toolkit.createLabel(composite, Messages.ModuleRestartSection_arbDesc);
        desc.setLayoutData((Object)FormDataUtility.createFormData2((Object)0, (int)5, null, (int)0, (Object)0, (int)5, null, (int)0));
        Label l = toolkit.createLabel(composite, Messages.ModuleRestartSection_arbRegexLabel);
        l.setLayoutData((Object)FormDataUtility.createFormData2((Object)desc, (int)5, null, (int)0, (Object)0, (int)5, null, (int)0));
        this.useDefaultPattern = toolkit.createButton(composite, Messages.ModuleRestartSection_arbDefaultPatternLabel, 32);
        this.useDefaultPattern.setLayoutData((Object)FormDataUtility.createFormData2((Object)l, (int)5, null, (int)0, (Object)0, (int)5, null, (int)0));
        this.restartPatternText = toolkit.createText(composite, "");
        this.restartPatternText.setLayoutData((Object)FormDataUtility.createFormData2((Object)this.useDefaultPattern, (int)5, null, (int)0, (Object)0, (int)5, (Object)100, (int)-5));
        this.overrideHotcodeButton = toolkit.createButton(composite, Messages.ModuleRestartSection_interceptHCR, 32);
        this.overrideHotcodeButton.setLayoutData((Object)FormDataUtility.createFormData2((Object)this.restartPatternText, (int)5, null, (int)0, (Object)0, (int)5, (Object)100, (int)-5));
        Label hotcodeComboLabel = toolkit.createLabel(composite, Messages.ModuleRestartSection_hcrFailureBehavior);
        hotcodeComboLabel.setLayoutData((Object)FormDataUtility.createFormData2((Object)this.overrideHotcodeButton, (int)5, null, (int)0, (Object)0, (int)5, null, (int)0));
        this.hotcodeCombo = new Combo(composite, 8);
        this.hotcodeCombo.setLayoutData((Object)FormDataUtility.createFormData2((Object)this.overrideHotcodeButton, (int)5, null, (int)0, (Object)hotcodeComboLabel, (int)5, (Object)100, (int)-5));
        this.hotcodeReplaceStrings = new String[]{org.jboss.ide.eclipse.as.wtp.ui.Messages.hcrShowDialog, org.jboss.ide.eclipse.as.wtp.ui.Messages.hcrRestartModules, org.jboss.ide.eclipse.as.wtp.ui.Messages.hcrTerminate, org.jboss.ide.eclipse.as.wtp.ui.Messages.hcrRestartServer, org.jboss.ide.eclipse.as.wtp.ui.Messages.hcrContinue};
        this.hotcodeCombo.setItems(this.hotcodeReplaceStrings);
        int[] nArray = new int[5];
        nArray[1] = 1;
        nArray[2] = 4;
        nArray[3] = 2;
        nArray[4] = 3;
        this.hotcodeReplaceCodes = nArray;
        toolkit.paintBordersFor(composite);
        section.setClient((Control)composite);
    }

    protected void addListeners() {
        this.checkboxListener = new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                ModuleRestartSection.this.execute((IUndoableOperation)new SetCustomizePatternCommand(ModuleRestartSection.this.server));
            }

            public void widgetDefaultSelected(SelectionEvent e) {
            }
        };
        this.textListener = new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                ModuleRestartSection.this.execute((IUndoableOperation)new SetCustomPatternCommand(ModuleRestartSection.this.server));
            }
        };
        this.useDefaultPattern.addSelectionListener(this.checkboxListener);
        this.restartPatternText.addModifyListener(this.textListener);
        this.hotcodeCheckboxListener = new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                ModuleRestartSection.this.execute((IUndoableOperation)new SetOverrideHotcodeReplaceCommand(ModuleRestartSection.this.server));
            }

            public void widgetDefaultSelected(SelectionEvent e) {
            }
        };
        this.overrideHotcodeButton.addSelectionListener(this.hotcodeCheckboxListener);
        this.comboListener = new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                ModuleRestartSection.this.execute((IUndoableOperation)new SetHotcodeReplaceBehaviorCommand(ModuleRestartSection.this.server));
            }
        };
        this.hotcodeCombo.addModifyListener(this.comboListener);
    }

    public class SetCustomPatternCommand
    extends ServerWorkingCopyPropertyCommand {
        public SetCustomPatternCommand(IServerWorkingCopy server) {
            super(server, Messages.ModuleRestartSection_arbCustomPatternCommand, ModuleRestartSection.this.restartPatternText, ModuleRestartSection.this.restartPatternText.getText(), "org.jboss.tools.as.restartFilePattern", ModuleRestartSection.this.textListener);
        }

        public void undo() {
            super.undo();
            this.validate();
        }

        public void execute() {
            super.execute();
            this.validate();
        }

        protected void validate() {
            try {
                Pattern.compile(ModuleRestartSection.this.restartPatternText.getText(), 2);
                ModuleRestartSection.this.setErrorMessage(null);
            }
            catch (PatternSyntaxException patternSyntaxException) {
                ModuleRestartSection.this.setErrorMessage(String.valueOf(Messages.ModuleRestartSection_invalidRegex) + ModuleRestartSection.this.restartPatternText.getText());
            }
        }
    }

    public class SetCustomizePatternCommand
    extends ServerWorkingCopyPropertyButtonCommand {
        public SetCustomizePatternCommand(IServerWorkingCopy server) {
            super(server, Messages.ModuleRestartSection_arbDefaultPatternCommand, ModuleRestartSection.this.useDefaultPattern, ModuleRestartSection.this.useDefaultPattern.getSelection(), "org.jboss.tools.as.useDefaultRestartFilePattern", ModuleRestartSection.this.checkboxListener, true);
        }

        public void execute() {
            super.execute();
            this.updatePatternText();
        }

        public void undo() {
            super.undo();
            this.updatePatternText();
        }

        private void updatePatternText() {
            ModuleRestartSection.this.restartPatternText.setEnabled(!ModuleRestartSection.this.useDefaultPattern.getSelection());
            ModuleRestartSection.this.restartPatternText.removeModifyListener(ModuleRestartSection.this.textListener);
            String newPattern = ModuleRestartSection.this.useDefaultPattern.getSelection() ? "\\.jar$" : this.server.getAttribute("org.jboss.tools.as.restartFilePattern", "\\.jar$");
            ModuleRestartSection.this.restartPatternText.setText(newPattern);
            ModuleRestartSection.this.restartPatternText.addModifyListener(ModuleRestartSection.this.textListener);
        }
    }

    public class SetHotcodeReplaceBehaviorCommand
    extends ServerWorkingCopyPropertyComboCommand {
        public SetHotcodeReplaceBehaviorCommand(IServerWorkingCopy server) {
            super(server, Messages.ModuleRestartSection_hcrBehaviorCommand, ModuleRestartSection.this.hotcodeCombo, ModuleRestartSection.this.hotcodeCombo.getSelectionIndex() == -1 ? "" : Integer.toString(ModuleRestartSection.this.hotcodeReplaceCodes[ModuleRestartSection.this.hotcodeCombo.getSelectionIndex()]), "org.jboss.ide.eclipse.as.wtp.core.server.launch.hotCodeReplace", ModuleRestartSection.this.comboListener);
        }

        protected String getStringForValue(String value) {
            int i = 0;
            while (i < ModuleRestartSection.this.hotcodeReplaceCodes.length) {
                if (Integer.toString(ModuleRestartSection.this.hotcodeReplaceCodes[i]).equals(value)) {
                    return ModuleRestartSection.this.hotcodeReplaceStrings[i];
                }
                ++i;
            }
            return value;
        }
    }

    public class SetOverrideHotcodeReplaceCommand
    extends ServerWorkingCopyPropertyButtonCommand {
        public SetOverrideHotcodeReplaceCommand(IServerWorkingCopy server) {
            super(server, Messages.ModuleRestartSection_hcrOverrideCommand, ModuleRestartSection.this.overrideHotcodeButton, ModuleRestartSection.this.overrideHotcodeButton.getSelection(), "org.jboss.ide.eclipse.as.wtp.core.server.launch.OverrideHotCodeReplace", ModuleRestartSection.this.hotcodeCheckboxListener, true);
        }

        public void execute() {
            super.execute();
            this.updateCombo();
        }

        public void undo() {
            super.undo();
            this.updateCombo();
        }

        private void updateCombo() {
            ModuleRestartSection.this.hotcodeCombo.setEnabled(ModuleRestartSection.this.overrideHotcodeButton.getSelection());
        }
    }
}

