/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.ide.eclipse.as.ui.editor.internal;

import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.Path;
import org.eclipse.jface.viewers.CellEditor;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.ICellEditorValidator;
import org.eclipse.jface.viewers.ICellModifier;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.TextCellEditor;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.swt.layout.FormAttachment;
import org.eclipse.swt.layout.FormData;
import org.eclipse.swt.layout.FormLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.TreeColumn;
import org.eclipse.swt.widgets.TreeItem;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorSite;
import org.eclipse.ui.forms.widgets.FormToolkit;
import org.eclipse.ui.forms.widgets.ScrolledForm;
import org.eclipse.wst.server.core.IModule;
import org.eclipse.wst.server.core.ServerEvent;
import org.jboss.ide.eclipse.as.ui.Messages;
import org.jboss.ide.eclipse.as.ui.editor.DeploymentPage;
import org.jboss.ide.eclipse.as.ui.editor.IDeploymentPageUIController;
import org.jboss.ide.eclipse.as.ui.editor.ModuleDeploymentOptionsComposite;
import org.jboss.ide.eclipse.as.wtp.core.server.behavior.AbstractSubsystemController;
import org.jboss.tools.as.core.internal.modules.DeploymentModulePrefs;
import org.jboss.tools.as.core.internal.modules.DeploymentPreferences;

public class ManagementDeploymentPageController
extends AbstractSubsystemController
implements IDeploymentPageUIController {
    protected DeploymentPage page;
    protected ModuleDeploymentOptionsComposite perModuleOptions;

    public DeploymentPage getPage() {
        return this.page;
    }

    @Override
    public void serverChanged(ServerEvent event) {
    }

    @Override
    public void doSave(IProgressMonitor monitor) {
    }

    @Override
    public void init(IEditorSite site, IEditorInput input, DeploymentPage page) {
        this.page = page;
    }

    @Override
    public void createPartControl(Composite parent) {
        try {
            ScrolledForm innerContent = this.createPageStructure(parent);
            this.addDeploymentLocationControls(innerContent.getBody());
            innerContent.reflow(true);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private ScrolledForm createPageStructure(Composite parent) {
        FormToolkit toolkit = this.getFormToolkit(parent);
        ScrolledForm allContent = toolkit.createScrolledForm(parent);
        toolkit.decorateFormHeading(allContent.getForm());
        allContent.setText(Messages.EditorDeployment);
        allContent.getBody().setLayout((Layout)new FormLayout());
        return allContent;
    }

    public FormToolkit getFormToolkit(Composite parent) {
        return this.page.getFormToolkit(parent);
    }

    @Override
    public void dispose() {
    }

    protected void addDeploymentLocationControls(Composite parent) {
        FormToolkit toolkit = new FormToolkit(parent.getDisplay());
        Label l1 = toolkit.createLabel(parent, Messages.EditorDeploymentPageWarning);
        FormData fd = new FormData();
        fd.left = new FormAttachment(0, 5);
        fd.top = new FormAttachment(0, 5);
        fd.right = new FormAttachment(100, -5);
        l1.setLayoutData((Object)fd);
        this.perModuleOptions = new ManagementModuleDeploymentOptionsComposite(parent, this.getPage(), this.getFormToolkit(parent), this.getPage().getPreferences());
        fd = new FormData();
        fd.left = new FormAttachment(0, 5);
        fd.top = new FormAttachment((Control)l1, 5);
        fd.right = new FormAttachment(100, -5);
        fd.bottom = new FormAttachment(100, -5);
        this.perModuleOptions.setLayoutData(fd);
    }

    private static class ManagementModuleDeploymentOptionsComposite
    extends ModuleDeploymentOptionsComposite {
        public ManagementModuleDeploymentOptionsComposite(Composite parent, DeploymentPage partner, FormToolkit tk, DeploymentPreferences prefs) {
            super(parent, partner, tk, prefs);
        }

        @Override
        protected TreeViewer createTreeViewer(Composite root) {
            TreeViewer viewer = new TreeViewer(root, 2048);
            viewer.getTree().setHeaderVisible(true);
            viewer.getTree().setLinesVisible(true);
            viewer.setContentProvider((IContentProvider)this.createViewerContentProvider());
            viewer.setLabelProvider((IBaseLabelProvider)this.createViewerLabelProvider());
            TreeColumn moduleColumn = new TreeColumn(viewer.getTree(), 0);
            TreeColumn publishNameColumn = new TreeColumn(viewer.getTree(), 0);
            moduleColumn.setText(Messages.EditorModule);
            publishNameColumn.setText("Deployment Name");
            moduleColumn.setWidth(200);
            publishNameColumn.setWidth(200);
            viewer.setColumnProperties(new String[]{"name", "location"});
            viewer.setInput((Object)"");
            CellEditor[] editors = new CellEditor[]{new TextCellEditor((Composite)viewer.getTree()), new TextCellEditor((Composite)viewer.getTree())};
            editors[1].setValidator(new ICellEditorValidator(){

                public String isValid(Object value) {
                    if (((String)value).contains("/") || ((String)value).contains("\\")) {
                        return "WRONG";
                    }
                    return null;
                }
            });
            viewer.setCellEditors(editors);
            viewer.setCellModifier(this.createViewerCellModifier());
            return viewer;
        }

        @Override
        protected ICellModifier createViewerCellModifier() {
            ModuleDeploymentOptionsComposite.ModuleDeploymentCellModifier t = new ModuleDeploymentOptionsComposite.ModuleDeploymentCellModifier(this){

                @Override
                public Object getValue(Object element, String property) {
                    DeploymentModulePrefs p = this.getPreferences().getOrCreatePreferences().getOrCreateModulePrefs((IModule)element);
                    if (property == "location") {
                        String outputName = p.getProperty("outputName");
                        outputName = outputName == null || outputName.length() == 0 ? ManagementModuleDeploymentOptionsComposite.this.getDefaultOutputName((IModule)element) : outputName;
                        return outputName;
                    }
                    return "";
                }

                @Override
                public void modify(Object element, String property, Object value) {
                    IModule module = (IModule)((TreeItem)element).getData();
                    DeploymentModulePrefs p = this.getPreferences().getOrCreatePreferences().getOrCreateModulePrefs(module);
                    if (property == "location") {
                        String outputName = value == null || ((String)value).equals("") ? "" : new Path((String)value).lastSegment();
                        this.getComposite().firePropertyChangeCommand(p, new String[]{"outputName"}, new String[]{outputName}, Messages.EditorEditDeployLocCommand);
                        this.getViewer().refresh();
                    }
                }
            };
            return t;
        }
    }
}

