/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.ide.eclipse.as.ui.views;

import java.io.IOException;
import java.io.PrintWriter;
import java.io.StringWriter;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.dialogs.IDialogConstants;
import org.eclipse.jface.dialogs.TrayDialog;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.swt.dnd.Clipboard;
import org.eclipse.swt.dnd.TextTransfer;
import org.eclipse.swt.dnd.Transfer;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.internal.views.log.Messages;
import org.jboss.ide.eclipse.as.ui.views.AbstractEntry;
import org.jboss.ide.eclipse.as.ui.views.LogEntry;
import org.jboss.ide.eclipse.as.ui.views.LogLabelProvider;

public class EventDetailsDialog
extends TrayDialog {
    private AbstractEntry entry;
    private LogLabelProvider labelProvider;
    private TreeViewer provider;
    private static int COPY_ID = 22;
    private Label dateLabel;
    private Label severityImageLabel;
    private Label severityLabel;
    private Text msgText;
    private Text stackTraceText;
    private Clipboard clipboard;
    private Button copyButton;

    protected EventDetailsDialog(Shell parentShell, AbstractEntry selection, TreeViewer provider) {
        super(parentShell);
        this.provider = provider;
        this.labelProvider = (LogLabelProvider)this.provider.getLabelProvider();
        this.entry = selection;
        this.setShellStyle(3312);
        this.clipboard = new Clipboard(parentShell.getDisplay());
    }

    public void create() {
        super.create();
        this.getShell().setSize(500, 550);
        EventDetailsDialog.applyDialogFont((Control)this.buttonBar);
        this.getButton(0).setFocus();
    }

    protected void buttonPressed(int buttonId) {
        if (buttonId == 0) {
            this.okPressed();
        } else if (1 == buttonId) {
            this.cancelPressed();
        } else if (COPY_ID == buttonId) {
            this.copyPressed();
        }
    }

    protected void copyPressed() {
        StringWriter writer = new StringWriter();
        PrintWriter pwriter = new PrintWriter(writer);
        this.entry.write(pwriter);
        pwriter.flush();
        String textVersion = writer.toString();
        try {
            pwriter.close();
            writer.close();
        }
        catch (IOException iOException) {}
        this.clipboard.setContents(new Object[]{textVersion}, new Transfer[]{TextTransfer.getInstance()});
    }

    public void updateProperties() {
        if (this.entry instanceof LogEntry) {
            LogEntry logEntry = (LogEntry)this.entry;
            String strDate = logEntry.getFormattedDate();
            this.dateLabel.setText(strDate);
            this.severityImageLabel.setImage(this.labelProvider.getColumnImage((Object)this.entry, 0));
            this.severityLabel.setText(logEntry.getSeverityText());
            this.msgText.setText(logEntry.getMessage() != null ? logEntry.getMessage() : "");
            String stack = logEntry.getStack();
            if (stack != null) {
                stack = this.filterStack(stack);
                this.stackTraceText.setText(stack);
            } else {
                this.stackTraceText.setText(Messages.EventDetailsDialog_noStack);
            }
        } else {
            this.dateLabel.setText("");
            this.severityImageLabel.setImage(null);
            this.severityLabel.setText("");
            this.msgText.setText("");
            this.stackTraceText.setText("");
        }
    }

    protected Control createDialogArea(Composite parent) {
        Composite container = new Composite(parent, 0);
        GridLayout layout = new GridLayout();
        layout.numColumns = 1;
        container.setLayout((Layout)layout);
        GridData gd = new GridData(1808);
        container.setLayoutData((Object)gd);
        this.createDetailsSection(container);
        this.createStackSection(container);
        this.updateProperties();
        Dialog.applyDialogFont((Control)container);
        return container;
    }

    private void createToolbarButtonBar(Composite parent) {
        Composite comp = new Composite(parent, 0);
        GridLayout layout = new GridLayout();
        layout.marginHeight = 0;
        layout.marginWidth = 0;
        comp.setLayout((Layout)layout);
        comp.setLayoutData((Object)new GridData(1040));
        ((GridData)comp.getLayoutData()).verticalAlignment = 1024;
        Composite container = new Composite(comp, 0);
        layout = new GridLayout();
        layout.marginWidth = 0;
        layout.marginHeight = 0;
        container.setLayout((Layout)layout);
        container.setLayoutData((Object)new GridData(1808));
        this.copyButton = this.createButton(container, COPY_ID, "", false);
        GridData gd = new GridData();
        this.copyButton.setLayoutData((Object)gd);
        this.copyButton.setImage(PlatformUI.getWorkbench().getSharedImages().getImage("IMG_TOOL_COPY"));
        this.copyButton.setToolTipText(Messages.EventDetailsDialog_copy);
        layout.numColumns = 2;
    }

    protected void createButtonsForButtonBar(Composite parent) {
        this.createButton(parent, 0, IDialogConstants.OK_LABEL, true);
    }

    private void createDetailsSection(Composite parent) {
        Composite container = new Composite(parent, 0);
        GridLayout layout = new GridLayout();
        layout.marginHeight = 0;
        layout.marginWidth = 0;
        layout.numColumns = 2;
        container.setLayout((Layout)layout);
        container.setLayoutData((Object)new GridData(768));
        this.createTextSection(container);
        this.createToolbarButtonBar(container);
    }

    private void createTextSection(Composite parent) {
        Composite textContainer = new Composite(parent, 0);
        GridLayout layout = new GridLayout();
        layout.numColumns = 3;
        layout.marginWidth = 0;
        layout.marginHeight = 0;
        textContainer.setLayout((Layout)layout);
        textContainer.setLayoutData((Object)new GridData(768));
        Label label = new Label(textContainer, 0);
        label.setText(Messages.EventDetailsDialog_date);
        this.dateLabel = new Label(textContainer, 0);
        GridData gd = new GridData(768);
        gd.horizontalSpan = 2;
        this.dateLabel.setLayoutData((Object)gd);
        label = new Label(textContainer, 0);
        label.setText(Messages.EventDetailsDialog_severity);
        this.severityImageLabel = new Label(textContainer, 0);
        this.severityLabel = new Label(textContainer, 0);
        gd = new GridData(768);
        this.severityLabel.setLayoutData((Object)gd);
        label = new Label(textContainer, 0);
        label.setText(Messages.EventDetailsDialog_message);
        gd = new GridData(2);
        label.setLayoutData((Object)gd);
        this.msgText = new Text(textContainer, 2626);
        this.msgText.setEditable(false);
        gd = new GridData(1810);
        gd.horizontalSpan = 2;
        gd.heightHint = 44;
        gd.grabExcessVerticalSpace = true;
        this.msgText.setLayoutData((Object)gd);
    }

    private void createStackSection(Composite parent) {
        Composite container = new Composite(parent, 0);
        GridLayout layout = new GridLayout(2, false);
        layout.marginHeight = 0;
        layout.marginWidth = 6;
        container.setLayout((Layout)layout);
        GridData gd = new GridData(1808);
        gd.heightHint = 100;
        container.setLayoutData((Object)gd);
        Label label = new Label(container, 0);
        label.setText(Messages.EventDetailsDialog_exception);
        gd = new GridData();
        gd.verticalAlignment = 1024;
        label.setLayoutData((Object)gd);
        this.stackTraceText = new Text(container, 2818);
        gd = new GridData(1808);
        gd.grabExcessHorizontalSpace = true;
        gd.horizontalSpan = 2;
        this.stackTraceText.setLayoutData((Object)gd);
        this.stackTraceText.setEditable(false);
    }

    private String filterStack(String stack) {
        return stack;
    }
}

