/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.jmx.local.internal.ui;

import org.eclipse.swt.graphics.Image;
import org.jboss.tools.common.jdt.debug.tools.ToolsCore;
import org.jboss.tools.common.jdt.debug.tools.ToolsCoreException;
import org.jboss.tools.jmx.jvmmonitor.core.IActiveJvm;
import org.jboss.tools.jmx.local.internal.Activator;
import org.jboss.tools.jmx.local.ui.JVMLabelProviderDelegate;

public class MavenLabelProvider
implements JVMLabelProviderDelegate {
    static final String ECLIPSE_MAVEN_PROCESS_PREFIX = "-DECLIPSE_PROCESS_NAME='";
    static final String ECLIPSE_MAVEN_PROCESS_POSTFIX = "'";
    static final String MAVEN_PREFIX = "org.codehaus.plexus.classworlds.launcher.Launcher";

    @Override
    public boolean accepts(IActiveJvm jvm) {
        return jvm.getMainClass().startsWith(MAVEN_PREFIX);
    }

    @Override
    public Image getImage(IActiveJvm connection) {
        return Activator.getDefault().getSharedImages().image("image/container.gif");
    }

    @Override
    public String getDisplayString(IActiveJvm jvm) {
        String displayName = "maven" + jvm.getMainClass().substring(MAVEN_PREFIX.length());
        if (!jvm.isRemote()) {
            int start;
            String pInfo = null;
            try {
                pInfo = ToolsCore.getMainArgs((String)jvm.getHost().getName(), (int)jvm.getPid());
            }
            catch (ToolsCoreException toolsCoreException) {}
            if (pInfo != null && (start = pInfo.indexOf(ECLIPSE_MAVEN_PROCESS_PREFIX)) != -1) {
                int end = pInfo.indexOf(ECLIPSE_MAVEN_PROCESS_POSTFIX, start + ECLIPSE_MAVEN_PROCESS_PREFIX.length() + 1);
                displayName = end != -1 ? pInfo.substring(start + ECLIPSE_MAVEN_PROCESS_PREFIX.length(), end) : pInfo.substring(start + ECLIPSE_MAVEN_PROCESS_PREFIX.length());
            }
        }
        return displayName;
    }
}

