/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.jmx.core;

import java.util.Set;
import javax.management.MBeanInfo;
import javax.management.MBeanServerConnection;
import javax.management.MalformedObjectNameException;
import javax.management.ObjectName;
import org.eclipse.core.runtime.Assert;
import org.jboss.tools.jmx.core.MBeanInfoWrapper;

public class DomainWrapper {
    private final String name;
    private final MBeanServerConnection mbsc;

    public DomainWrapper(String name, MBeanServerConnection mbsc) {
        Assert.isNotNull((Object)name);
        Assert.isNotNull((Object)mbsc);
        this.name = name;
        this.mbsc = mbsc;
    }

    private ObjectName getPattern() throws MalformedObjectNameException {
        return new ObjectName(String.valueOf(this.name) + ":*");
    }

    public String getName() {
        return this.name;
    }

    public MBeanInfoWrapper[] getMBeanInfos() {
        try {
            Set<ObjectName> set = this.mbsc.queryNames(this.getPattern(), null);
            MBeanInfoWrapper[] instances = new MBeanInfoWrapper[set.size()];
            int i = 0;
            for (ObjectName on : set) {
                MBeanInfo info = this.mbsc.getMBeanInfo(on);
                instances[i] = new MBeanInfoWrapper(on, info, this.mbsc, null);
                ++i;
            }
            return instances;
        }
        catch (Exception e) {
            e.printStackTrace();
            return new MBeanInfoWrapper[0];
        }
    }
}

