/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.ide.eclipse.as.wtp.ui.editor;

import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.wst.server.core.IServerWorkingCopy;
import org.eclipse.wst.server.ui.internal.command.ServerCommand;

public class ServerWorkingCopyPropertyComboCommand
extends ServerCommand {
    public static int POST_EXECUTE = 1;
    public static int POST_UNDO = 2;
    public static int POST_REDO = 3;
    protected String oldVal;
    protected String newVal;
    protected String key;
    protected Combo combo;
    protected ModifyListener modlistener;
    protected SelectionListener selListener;
    protected IServerWorkingCopy wc;

    public ServerWorkingCopyPropertyComboCommand(IServerWorkingCopy wc, String commandName, Combo combo, String newVal, String attributeKey, ModifyListener listener) {
        super(wc, commandName);
        this.wc = wc;
        this.combo = combo;
        this.key = attributeKey;
        this.newVal = newVal;
        this.modlistener = listener;
        if (this.key != null) {
            this.oldVal = wc.getAttribute(attributeKey, "");
        }
    }

    public ServerWorkingCopyPropertyComboCommand(IServerWorkingCopy wc, String commandName, Combo combo, String newVal, String attributeKey, SelectionListener listener) {
        super(wc, commandName);
        this.wc = wc;
        this.combo = combo;
        this.key = attributeKey;
        this.newVal = newVal;
        this.selListener = listener;
        if (this.key != null) {
            this.oldVal = wc.getAttribute(attributeKey, "");
        }
    }

    public void execute() {
        this.wc.setAttribute(this.key, this.newVal);
        this.postOp(POST_EXECUTE);
    }

    public void undo() {
        if (this.modlistener != null) {
            this.combo.removeModifyListener(this.modlistener);
        }
        if (this.selListener != null) {
            this.combo.removeSelectionListener(this.selListener);
        }
        this.wc.setAttribute(this.key, this.oldVal);
        if (this.combo != null && !this.combo.isDisposed()) {
            String oldValAsText = this.getStringForValue(this.oldVal);
            int toSel = this.getItemIndex(oldValAsText);
            if (toSel != -1) {
                this.combo.select(toSel);
            } else {
                this.combo.setText(oldValAsText);
            }
        }
        if (this.modlistener != null) {
            this.combo.addModifyListener(this.modlistener);
        }
        if (this.selListener != null) {
            this.combo.addSelectionListener(this.selListener);
        }
        this.postOp(POST_UNDO);
    }

    protected int getItemIndex(String text) {
        String[] items = this.combo.getItems();
        int i = 0;
        while (i < items.length) {
            if (items[i].equals(text)) {
                return i;
            }
            ++i;
        }
        return -1;
    }

    public IStatus redo() {
        if (this.modlistener != null) {
            this.combo.removeModifyListener(this.modlistener);
        }
        if (this.selListener != null) {
            this.combo.removeSelectionListener(this.selListener);
        }
        this.wc.setAttribute(this.key, this.newVal);
        if (this.combo != null && !this.combo.isDisposed()) {
            String newValAsText = this.getStringForValue(this.newVal);
            int toSel = this.getItemIndex(newValAsText);
            if (toSel != -1) {
                this.combo.select(toSel);
            } else {
                this.combo.setText(newValAsText);
            }
        }
        if (this.modlistener != null) {
            this.combo.addModifyListener(this.modlistener);
        }
        if (this.selListener != null) {
            this.combo.addSelectionListener(this.selListener);
        }
        this.postOp(POST_REDO);
        return Status.OK_STATUS;
    }

    protected void postOp(int type) {
    }

    protected String getStringForValue(String value) {
        return value;
    }
}

