/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.ide.eclipse.as.wtp.ui.editor;

import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.widgets.Text;
import org.eclipse.wst.server.core.IServerWorkingCopy;
import org.eclipse.wst.server.ui.internal.command.ServerCommand;

public class ServerWorkingCopyPropertyTextCommand
extends ServerCommand {
    public static int POST_EXECUTE = 1;
    public static int POST_UNDO = 2;
    public static int POST_REDO = 3;
    protected String oldVal;
    protected String newVal;
    protected String key;
    protected String defaultDisplay;
    protected Text text;
    protected ModifyListener listener;
    protected IServerWorkingCopy wc;

    public ServerWorkingCopyPropertyTextCommand(IServerWorkingCopy wc, String commandName, Text text, String newVal, String attributeKey, ModifyListener listener) {
        this(wc, commandName, text, newVal, attributeKey, null, listener);
    }

    public ServerWorkingCopyPropertyTextCommand(IServerWorkingCopy wc, String commandName, Text text, String newVal, String attributeKey, String defaultDisplay, ModifyListener listener) {
        super(wc, commandName);
        this.wc = wc;
        this.text = text;
        this.key = attributeKey;
        this.newVal = newVal;
        this.listener = listener;
        if (this.key != null) {
            this.oldVal = wc.getAttribute(attributeKey, null);
        }
        this.defaultDisplay = defaultDisplay == null ? "" : defaultDisplay;
    }

    public void execute() {
        if (this.newVal.equals(this.defaultDisplay) || this.newVal.equals("")) {
            this.wc.setAttribute(this.key, null);
        } else {
            this.wc.setAttribute(this.key, this.newVal);
        }
        this.postOp(POST_EXECUTE);
    }

    public void undo() {
        if (this.listener != null) {
            this.text.removeModifyListener(this.listener);
        }
        this.wc.setAttribute(this.key, this.oldVal);
        if (this.text != null && !this.text.isDisposed()) {
            this.text.setText(this.oldVal == null ? this.defaultDisplay : this.oldVal);
        }
        if (this.listener != null) {
            this.text.addModifyListener(this.listener);
        }
        this.postOp(POST_UNDO);
    }

    public IStatus redo() {
        if (this.listener != null) {
            this.text.removeModifyListener(this.listener);
        }
        this.wc.setAttribute(this.key, this.newVal);
        if (this.text != null && !this.text.isDisposed()) {
            this.text.setText(this.newVal);
        }
        if (this.listener != null) {
            this.text.addModifyListener(this.listener);
        }
        this.postOp(POST_REDO);
        return Status.OK_STATUS;
    }

    protected void postOp(int type) {
    }
}

