/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.ide.eclipse.as.wtp.ui.profile;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Iterator;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtensionRegistry;
import org.eclipse.core.runtime.Platform;
import org.eclipse.wst.server.ui.wizard.WizardFragment;

public class ProfileUI {
    private static ProfileUI instance;
    private HashMap<String, FragmentWrapper> map;

    public static ProfileUI getDefault() {
        if (instance == null) {
            instance = new ProfileUI();
        }
        return instance;
    }

    ProfileUI() {
    }

    public WizardFragment[] getWizardFragments(String serverType, String profile) {
        ProfileUI.getDefault().ensureLoaded();
        Collection<FragmentWrapper> all = this.map.values();
        ArrayList<FragmentWrapper> all2 = new ArrayList<FragmentWrapper>(all);
        Collections.sort(all2, new Comparator<FragmentWrapper>(){

            @Override
            public int compare(FragmentWrapper arg0, FragmentWrapper arg1) {
                return arg0.getWeight() - arg1.getWeight();
            }
        });
        Iterator<FragmentWrapper> it = all.iterator();
        ArrayList<WizardFragment> ret = new ArrayList<WizardFragment>();
        while (it.hasNext()) {
            WizardFragment tempFragment;
            FragmentWrapper temp = it.next();
            if (!profile.equals(temp.profile) || !temp.supportsServerType(serverType) || (tempFragment = temp.getFragment()) == null) continue;
            ret.add(tempFragment);
        }
        return ret.toArray(new WizardFragment[ret.size()]);
    }

    private void ensureLoaded() {
        HashMap<String, FragmentWrapper> temp = new HashMap<String, FragmentWrapper>();
        IExtensionRegistry registry = Platform.getExtensionRegistry();
        IConfigurationElement[] cf = registry.getConfigurationElementsFor("org.jboss.ide.eclipse.as.wtp.ui", "ServerProfileWizardFragments");
        int i = 0;
        while (i < cf.length) {
            FragmentWrapper oneWrapper = new FragmentWrapper(cf[i]);
            temp.put(oneWrapper.id, oneWrapper);
            ++i;
        }
        this.map = temp;
    }

    private class FragmentWrapper {
        private String id;
        private String serverTypes;
        private String profile;
        private WizardFragment fragment;
        private IConfigurationElement element;
        private int weight;

        public FragmentWrapper(IConfigurationElement element) {
            this.id = element.getAttribute("id");
            this.profile = element.getAttribute("profile");
            this.serverTypes = element.getAttribute("serverTypes");
            this.element = element;
            String w = element.getAttribute("weight");
            try {
                Integer i = Integer.parseInt(w);
                this.weight = i;
            }
            catch (NumberFormatException numberFormatException) {
                this.weight = 100;
            }
        }

        protected boolean supportsServerType(String servertype) {
            String[] typesAsArr = this.serverTypes.split(",");
            int i = 0;
            while (i < typesAsArr.length) {
                if (typesAsArr[i].equals(servertype)) {
                    return true;
                }
                ++i;
            }
            return false;
        }

        public int getWeight() {
            return this.weight;
        }

        public WizardFragment getFragment() {
            try {
                if (this.fragment == null) {
                    this.fragment = (WizardFragment)this.element.createExecutableExtension("class");
                }
            }
            catch (CoreException ce) {
                ce.printStackTrace();
            }
            return this.fragment;
        }
    }
}

