/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.ide.eclipse.as.rse.ui;

import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.rse.core.model.IHost;
import org.eclipse.rse.services.clientserver.messages.SystemMessageException;
import org.eclipse.rse.services.files.IFileService;
import org.eclipse.rse.subsystems.files.core.servicesubsystem.IFileServiceSubSystem;
import org.eclipse.rse.subsystems.files.core.subsystems.IRemoteFile;
import org.eclipse.swt.widgets.Display;
import org.eclipse.wst.server.core.IModule;
import org.eclipse.wst.server.core.IServer;
import org.eclipse.wst.server.core.IServerAttributes;
import org.jboss.ide.eclipse.as.core.util.JBossServerBehaviorUtils;
import org.jboss.ide.eclipse.as.core.util.RemotePath;
import org.jboss.ide.eclipse.as.rse.core.IFileServiceProvider;
import org.jboss.ide.eclipse.as.rse.core.RSEFrameworkUtils;
import org.jboss.ide.eclipse.as.rse.core.RSEUtils;
import org.jboss.ide.eclipse.as.rse.ui.RSEUIPlugin;
import org.jboss.ide.eclipse.as.rse.ui.SystemShowInTableAction;
import org.jboss.ide.eclipse.as.ui.subsystems.IExploreBehavior;
import org.jboss.ide.eclipse.as.wtp.core.server.behavior.AbstractSubsystemController;
import org.jboss.ide.eclipse.as.wtp.core.server.behavior.IControllableServerBehavior;
import org.jboss.ide.eclipse.as.wtp.core.server.behavior.IFilesystemController;
import org.jboss.tools.as.core.server.controllable.systems.IDeploymentOptionsController;
import org.jboss.tools.as.core.server.controllable.systems.IModuleDeployPathController;

public class RSEExploreBehavior
extends AbstractSubsystemController
implements IExploreBehavior {
    public void openExplorer(IServer server, IModule[] module) {
        IPath remoteFolder = null;
        try {
            IDeploymentOptionsController controller;
            IControllableServerBehavior cs = JBossServerBehaviorUtils.getControllableBehavior((IServerAttributes)server);
            if (module == null) {
                controller = (IDeploymentOptionsController)cs.getController("deploymentOptions");
                remoteFolder = new RemotePath(controller.getDeploymentsRootFolder(true), controller.getPathSeparatorCharacter());
            } else {
                controller = (IModuleDeployPathController)cs.getController("moduleDeployPath");
                remoteFolder = controller.getDeployDirectory(module);
            }
            IFilesystemController fsController = (IFilesystemController)cs.getController("filesystem");
            if (fsController != null && fsController instanceof IFileServiceProvider) {
                IFileService fs = ((IFileServiceProvider)fsController).getFileService();
                IFileServiceSubSystem fsSubsystem = ((IFileServiceProvider)fsController).getFileServiceSubSystem();
                String connectionName = RSEUtils.getRSEConnectionName((IServerAttributes)server);
                IHost host = RSEFrameworkUtils.findHost((String)connectionName);
                RSEFrameworkUtils.ensureActiveConnection((IServer)server, (IFileServiceSubSystem)RSEFrameworkUtils.findFileTransferSubSystem((IHost)host), (IProgressMonitor)new NullProgressMonitor());
                fs.getFile(remoteFolder.removeLastSegments(1).toOSString(), remoteFolder.lastSegment(), (IProgressMonitor)new NullProgressMonitor());
                String path = remoteFolder.toString();
                IRemoteFile rf = fsSubsystem.getRemoteFileObject(path, null);
                SystemShowInTableAction act = new SystemShowInTableAction(Display.getDefault().getActiveShell());
                act.setSelectedObject(rf);
                act.run();
            }
        }
        catch (CoreException ce) {
            RSEUIPlugin.log(ce);
        }
        catch (SystemMessageException sme) {
            RSEUIPlugin.log(sme);
        }
    }

    public boolean canExplore(IServer server, IModule[] module) {
        return true;
    }
}

