/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.ide.eclipse.archives.core.build;

import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.resources.WorkspaceJob;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.QualifiedName;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.ISchedulingRule;
import org.jboss.ide.eclipse.archives.core.ArchivesCoreMessages;
import org.jboss.ide.eclipse.archives.core.build.ArchiveBuildDelegate;
import org.jboss.ide.eclipse.archives.core.build.ModelChangeListener;
import org.jboss.ide.eclipse.archives.core.model.IArchive;
import org.jboss.ide.eclipse.archives.core.model.IArchiveNode;
import org.jboss.ide.eclipse.archives.core.model.IArchiveNodeDelta;
import org.jboss.ide.eclipse.archives.core.util.internal.ModelTruezipBridge;

public class ModelChangeListenerWithRefresh
extends ModelChangeListener {
    protected void executeAndLog(IArchiveNodeDelta delta) {
        final IArchiveNodeDelta delta2 = delta;
        WorkspaceJob j = new WorkspaceJob(ArchivesCoreMessages.UpdatingModelJob){

            public IStatus runInWorkspace(IProgressMonitor monitor) {
                IArchiveNode post;
                IArchiveNode iArchiveNode = post = delta2 == null ? null : delta2.getPostNode();
                if (post != null) {
                    IPath path = delta2.getPostNode().getModelRootNode().getDescriptor();
                    IFile[] files = ResourcesPlugin.getWorkspace().getRoot().findFilesForLocation(path);
                    int i = 0;
                    while (i < files.length) {
                        try {
                            files[i].refreshLocal(2, (IProgressMonitor)new NullProgressMonitor());
                        }
                        catch (CoreException coreException) {
                            // empty catch block
                        }
                        ++i;
                    }
                }
                try {
                    ModelChangeListenerWithRefresh.super.executeAndLog(delta2);
                }
                catch (ModelTruezipBridge.FullBuildRequiredException fbre) {
                    IArchiveNode o = delta2.getPostNode();
                    IPath p = o == null ? null : o.getProjectPath();
                    return new ArchiveBuildDelegate().fullProjectBuild(delta2.getPostNode().getProjectPath(), monitor);
                }
                return Status.OK_STATUS;
            }
        };
        j.setRule((ISchedulingRule)ResourcesPlugin.getWorkspace().getRoot());
        j.schedule();
    }

    protected void postChange(IArchiveNode node) {
        IArchive pack = node.getRootArchive();
        if (pack != null) {
            IWorkspaceRoot root = ResourcesPlugin.getWorkspace().getRoot();
            IContainer proj = root.getContainerForLocation(pack.getProjectPath());
            try {
                IContainer res;
                proj.setSessionProperty(new QualifiedName("org.jboss.ide.eclipse.archives.core", "localname"), (Object)"inUse");
                if (pack.isDestinationInWorkspace() && (res = root.getContainerForLocation(pack.getProjectPath())) != null) {
                    try {
                        res.refreshLocal(2, (IProgressMonitor)new NullProgressMonitor());
                    }
                    catch (CoreException coreException) {
                        // empty catch block
                    }
                }
                try {
                    proj.getFile((IPath)new Path(".packages")).refreshLocal(1, (IProgressMonitor)new NullProgressMonitor());
                }
                catch (CoreException coreException) {}
            }
            catch (CoreException coreException) {
                // empty catch block
            }
        }
    }
}

