/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.ide.eclipse.archives.core.model.internal;

import java.util.ArrayList;
import org.eclipse.core.runtime.IPath;
import org.jboss.ide.eclipse.archives.core.model.IArchive;
import org.jboss.ide.eclipse.archives.core.model.IArchiveFileSet;
import org.jboss.ide.eclipse.archives.core.model.IArchiveFolder;
import org.jboss.ide.eclipse.archives.core.model.IArchiveNode;
import org.jboss.ide.eclipse.archives.core.model.INamedContainerArchiveNode;
import org.jboss.ide.eclipse.archives.core.model.internal.ArchiveNodeImpl;
import org.jboss.ide.eclipse.archives.core.model.internal.xb.XbFolder;

public class ArchiveFolderImpl
extends ArchiveNodeImpl
implements IArchiveFolder {
    private XbFolder folderDelegate;

    public ArchiveFolderImpl() {
        this(new XbFolder());
    }

    public ArchiveFolderImpl(XbFolder delegate) {
        super(delegate);
        this.folderDelegate = delegate;
    }

    public String getName() {
        return this.folderDelegate.getName();
    }

    public IArchiveFileSet[] getFileSets() {
        IArchiveNode[] nodes = this.getChildren(2);
        IArchiveFileSet[] filesets = new IArchiveFileSet[nodes.length];
        System.arraycopy(nodes, 0, filesets, 0, nodes.length);
        return filesets;
    }

    public IArchiveFolder[] getFolders() {
        IArchiveNode[] nodes = this.getChildren(3);
        IArchiveFolder[] folders = new IArchiveFolder[nodes.length];
        System.arraycopy(nodes, 0, folders, 0, nodes.length);
        return folders;
    }

    public IArchive[] getArchives() {
        IArchiveNode[] nodes = this.getChildren(0);
        IArchive[] pkgs = new IArchive[nodes.length];
        System.arraycopy(nodes, 0, pkgs, 0, nodes.length);
        return pkgs;
    }

    public int getNodeType() {
        return 3;
    }

    public void setName(String name) {
        this.attributeChanged("org.jboss.ide.eclipse.archives.core.model.INamedContainerArchiveNodename", this.getName(), name);
        this.folderDelegate.setName(name);
    }

    protected XbFolder getFolderDelegate() {
        return this.folderDelegate;
    }

    public String toString() {
        return "folder[" + this.getName() + "]";
    }

    public IPath getRootArchiveRelativePath() {
        return this.getParent().getRootArchiveRelativePath().append(this.getName());
    }

    public boolean validateModel() {
        ArrayList<String> list = new ArrayList<String>();
        IArchiveNode[] children = this.getAllChildren();
        int i = 0;
        while (i < children.length) {
            if (children[i] instanceof INamedContainerArchiveNode) {
                if (list.contains(((INamedContainerArchiveNode)children[i]).getName())) {
                    return false;
                }
                list.add(((INamedContainerArchiveNode)children[i]).getName());
            }
            ++i;
        }
        return super.validateModel();
    }
}

