/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.ide.eclipse.archives.core.model.internal.xb;

import java.util.ArrayList;
import java.util.Hashtable;
import java.util.List;

public abstract class XbPackageNode
implements Cloneable {
    protected XbPackageNode parent;
    protected Hashtable children;
    private String nodeType;

    public XbPackageNode(String nodeType) {
        this.nodeType = nodeType;
        this.children = new Hashtable();
    }

    public XbPackageNode(XbPackageNode node) {
        this(node.getNodeType());
        for (Object key : node.children.keySet()) {
            this.children.put(key, ((ArrayList)node.children.get(key)).clone());
        }
    }

    public void addChild(Object object) {
        this.addChild((XbPackageNode)object);
    }

    public void addChild(XbPackageNode child) {
        if (!this.children.containsKey(child.getClass())) {
            this.children.put(child.getClass(), new ArrayList());
        }
        this.getChildren(child.getClass()).add(child);
        child.setParent(this);
    }

    public void removeChild(XbPackageNode child) {
        if (this.children.containsKey(child.getClass())) {
            this.getChildren(child.getClass()).remove(child);
        }
    }

    public List getChildren(Class type) {
        return (List)this.children.get(type);
    }

    public boolean hasChildren() {
        return this.children != null && this.children.size() > 0;
    }

    public List getAllChildren() {
        ArrayList allChildren = new ArrayList();
        for (Class childType : this.children.keySet()) {
            allChildren.addAll(this.getChildren(childType));
        }
        return allChildren;
    }

    public XbPackageNode getParent() {
        return this.parent;
    }

    public void setParent(XbPackageNode parent) {
        this.parent = parent;
    }

    public String getNodeType() {
        return this.nodeType;
    }
}

