/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.ide.eclipse.archives.core.project;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IProjectDescription;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;

public class ProjectUtils {
    public static boolean addProjectNature(IPath path) {
        IProject[] allProjects = ResourcesPlugin.getWorkspace().getRoot().getProjects();
        int i = 0;
        while (i < allProjects.length) {
            if (allProjects[i].getLocation().equals((Object)path)) {
                return ProjectUtils.addProjectNature(allProjects[i], "org.jboss.ide.eclipse.archives.core.archivesNature");
            }
            ++i;
        }
        return false;
    }

    public static boolean addProjectNature(IProject project, String natureId) {
        return ProjectUtils.addProjectNature(project, natureId, null);
    }

    public static boolean addProjectNature(IProject project, String natureId, IProgressMonitor monitor) {
        monitor = monitor == null ? new NullProgressMonitor() : monitor;
        boolean added = false;
        try {
            if (project != null && natureId != null) {
                IProjectDescription desc = project.getDescription();
                if (!project.hasNature(natureId)) {
                    String[] natureIds = desc.getNatureIds();
                    String[] newNatureIds = new String[natureIds.length + 1];
                    System.arraycopy(natureIds, 0, newNatureIds, 1, natureIds.length);
                    newNatureIds[0] = natureId;
                    desc.setNatureIds(newNatureIds);
                    project.getProject().setDescription(desc, monitor);
                    added = true;
                }
            }
        }
        catch (CoreException e) {
            e.printStackTrace();
        }
        return added;
    }

    public static boolean removeProjectNature(IPath path) {
        IProject[] allProjects = ResourcesPlugin.getWorkspace().getRoot().getProjects();
        int i = 0;
        while (i < allProjects.length) {
            if (allProjects[i].getLocation().equals((Object)path)) {
                return ProjectUtils.removeProjectNature(allProjects[i], "org.jboss.ide.eclipse.archives.core.archivesNature");
            }
            ++i;
        }
        return false;
    }

    public static boolean removeProjectNature(IProject project, String natureId) {
        return ProjectUtils.removeProjectNature(project, natureId, null);
    }

    public static boolean removeProjectNature(IProject project, String natureId, IProgressMonitor monitor) {
        monitor = monitor == null ? new NullProgressMonitor() : monitor;
        boolean removed = false;
        try {
            if (project != null && natureId != null) {
                IProjectDescription desc = project.getDescription();
                if (project.hasNature(natureId)) {
                    String[] natureIds = desc.getNatureIds();
                    List<String> l = Arrays.asList(natureIds);
                    ArrayList<String> newDesc = new ArrayList<String>();
                    newDesc.addAll(l);
                    newDesc.remove(natureId);
                    String[] asArr = newDesc.toArray(new String[newDesc.size()]);
                    desc.setNatureIds(asArr);
                    project.getProject().setDescription(desc, monitor);
                    removed = true;
                }
            }
        }
        catch (CoreException e) {
            e.printStackTrace();
        }
        return removed;
    }
}

