/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.ide.eclipse.archives.core.util;

import de.schlichtherle.io.AbstractArchiveDetector;
import de.schlichtherle.io.ArchiveDetector;
import de.schlichtherle.io.ArchiveException;
import de.schlichtherle.io.DefaultArchiveDetector;
import de.schlichtherle.io.archive.spi.ArchiveDriver;
import de.schlichtherle.io.archive.zip.JarDriver;
import java.io.File;
import java.io.IOException;
import org.eclipse.core.runtime.IPath;
import org.jboss.ide.eclipse.archives.core.ArchivesCorePlugin;

public class TrueZipUtil {
    private static ArchiveDetector JAR_ARCHIVE_DETECTOR;

    public static de.schlichtherle.io.File getFile(IPath path) {
        ClassLoader bundleLoader = ArchivesCorePlugin.getDefault().getBundleClassLoader();
        ClassLoader originalTCCL = Thread.currentThread().getContextClassLoader();
        try {
            Thread.currentThread().setContextClassLoader(bundleLoader);
            de.schlichtherle.io.File file = TrueZipUtil.getFile(path, (ArchiveDetector)ArchiveDetector.DEFAULT);
            return file;
        }
        finally {
            Thread.currentThread().setContextClassLoader(originalTCCL);
        }
    }

    public static de.schlichtherle.io.File getFile(File f, ArchiveDetector detector) {
        ClassLoader bundleLoader = ArchivesCorePlugin.getDefault().getBundleClassLoader();
        ClassLoader originalTCCL = Thread.currentThread().getContextClassLoader();
        try {
            Thread.currentThread().setContextClassLoader(bundleLoader);
            de.schlichtherle.io.File file = new de.schlichtherle.io.File(f, detector);
            return file;
        }
        finally {
            Thread.currentThread().setContextClassLoader(originalTCCL);
        }
    }

    public static de.schlichtherle.io.File getFile(File f, String segment, ArchiveDetector detector) {
        ClassLoader bundleLoader = ArchivesCorePlugin.getDefault().getBundleClassLoader();
        ClassLoader originalTCCL = Thread.currentThread().getContextClassLoader();
        try {
            Thread.currentThread().setContextClassLoader(bundleLoader);
            de.schlichtherle.io.File file = new de.schlichtherle.io.File(f, segment, detector);
            return file;
        }
        finally {
            Thread.currentThread().setContextClassLoader(originalTCCL);
        }
    }

    public static de.schlichtherle.io.File getFile(IPath path, ArchiveDetector detector) {
        ClassLoader bundleLoader = ArchivesCorePlugin.getDefault().getBundleClassLoader();
        ClassLoader originalTCCL = Thread.currentThread().getContextClassLoader();
        try {
            Thread.currentThread().setContextClassLoader(bundleLoader);
            de.schlichtherle.io.File file = new de.schlichtherle.io.File(path.toOSString(), detector);
            return file;
        }
        finally {
            Thread.currentThread().setContextClassLoader(originalTCCL);
        }
    }

    public static boolean pathExists(IPath path) {
        return TrueZipUtil.pathExists(TrueZipUtil.getFile(path));
    }

    public static boolean pathExists(de.schlichtherle.io.File file) {
        ClassLoader bundleLoader = ArchivesCorePlugin.getDefault().getBundleClassLoader();
        ClassLoader originalTCCL = Thread.currentThread().getContextClassLoader();
        try {
            Thread.currentThread().setContextClassLoader(bundleLoader);
            boolean bl = file.exists();
            return bl;
        }
        finally {
            Thread.currentThread().setContextClassLoader(originalTCCL);
        }
    }

    public static long getTimestamp(IPath path) {
        return TrueZipUtil.getTimestamp(TrueZipUtil.getFile(path));
    }

    public static long getTimestamp(de.schlichtherle.io.File file) {
        ClassLoader bundleLoader = ArchivesCorePlugin.getDefault().getBundleClassLoader();
        ClassLoader originalTCCL = Thread.currentThread().getContextClassLoader();
        try {
            Thread.currentThread().setContextClassLoader(bundleLoader);
            long l = file.lastModified();
            return l;
        }
        finally {
            Thread.currentThread().setContextClassLoader(originalTCCL);
        }
    }

    public static boolean copyFile(String source, IPath dest) throws IOException {
        return TrueZipUtil.copyFile(source, TrueZipUtil.getFile(dest), true);
    }

    public static boolean copyFile(String source, de.schlichtherle.io.File file, boolean updateTimestamps) {
        ClassLoader bundleLoader = ArchivesCorePlugin.getDefault().getBundleClassLoader();
        ClassLoader originalTCCL = Thread.currentThread().getContextClassLoader();
        try {
            Thread.currentThread().setContextClassLoader(bundleLoader);
            file.getParentFile().mkdirs();
            boolean b = new de.schlichtherle.io.File(source, (ArchiveDetector)ArchiveDetector.NULL).archiveCopyAllTo((File)file);
            boolean bl = b && (!updateTimestamps || TrueZipUtil.updateParentTimestamps(file));
            return bl;
        }
        finally {
            Thread.currentThread().setContextClassLoader(originalTCCL);
        }
    }

    public static boolean touchFile(IPath path) {
        ClassLoader bundleLoader = ArchivesCorePlugin.getDefault().getBundleClassLoader();
        ClassLoader originalTCCL = Thread.currentThread().getContextClassLoader();
        try {
            Thread.currentThread().setContextClassLoader(bundleLoader);
            de.schlichtherle.io.File f = TrueZipUtil.getFile(path);
            boolean b = f.setLastModified(System.currentTimeMillis());
            boolean bl = b && TrueZipUtil.updateParentTimestamps(path);
            return bl;
        }
        finally {
            Thread.currentThread().setContextClassLoader(originalTCCL);
        }
    }

    public static boolean deleteAll(IPath path, String fileName) {
        return TrueZipUtil.deleteAll(path.append(fileName));
    }

    public static boolean deleteAll(IPath path) {
        return TrueZipUtil.deleteAll(TrueZipUtil.getFile(path));
    }

    public static boolean deleteAll(de.schlichtherle.io.File file) {
        ClassLoader bundleLoader = ArchivesCorePlugin.getDefault().getBundleClassLoader();
        ClassLoader originalTCCL = Thread.currentThread().getContextClassLoader();
        try {
            Thread.currentThread().setContextClassLoader(bundleLoader);
            boolean bl = file.deleteAll();
            return bl;
        }
        finally {
            Thread.currentThread().setContextClassLoader(originalTCCL);
        }
    }

    public static boolean deleteEmptyChildren(File file) {
        boolean b = true;
        if (file.isDirectory()) {
            File[] children = file.listFiles();
            int i = 0;
            while (i < children.length) {
                b &= TrueZipUtil.deleteEmptyFolders(children[i]);
                ++i;
            }
        }
        return b;
    }

    public static boolean deleteEmptyFolders(File file) {
        boolean b = true;
        if (file.isDirectory()) {
            File[] children = file.listFiles();
            int i = 0;
            while (i < children.length) {
                b &= TrueZipUtil.deleteEmptyFolders(children[i]);
                ++i;
            }
            if (file.listFiles().length == 0) {
                file.delete();
            }
        }
        return b;
    }

    public static boolean createFolder(IPath parent, String folderName) {
        ClassLoader bundleLoader = ArchivesCorePlugin.getDefault().getBundleClassLoader();
        ClassLoader originalTCCL = Thread.currentThread().getContextClassLoader();
        try {
            Thread.currentThread().setContextClassLoader(bundleLoader);
            boolean b = new de.schlichtherle.io.File((File)TrueZipUtil.getFile(parent, (ArchiveDetector)ArchiveDetector.DEFAULT), folderName, (ArchiveDetector)ArchiveDetector.NULL).mkdirs();
            boolean bl = b && TrueZipUtil.updateParentTimestamps(parent.append(folderName));
            return bl;
        }
        finally {
            Thread.currentThread().setContextClassLoader(originalTCCL);
        }
    }

    public static boolean createFolder(IPath path) {
        return TrueZipUtil.createFolder(path.removeLastSegments(1), path.lastSegment());
    }

    public static boolean createArchive(IPath parent, String folderName) {
        ClassLoader bundleLoader = ArchivesCorePlugin.getDefault().getBundleClassLoader();
        ClassLoader originalTCCL = Thread.currentThread().getContextClassLoader();
        try {
            Thread.currentThread().setContextClassLoader(bundleLoader);
            boolean b = new de.schlichtherle.io.File((File)TrueZipUtil.getFile(parent, (ArchiveDetector)ArchiveDetector.DEFAULT), folderName, TrueZipUtil.getJarArchiveDetector()).mkdirs();
            boolean bl = b && TrueZipUtil.updateParentTimestamps(parent.append(folderName));
            return bl;
        }
        finally {
            Thread.currentThread().setContextClassLoader(originalTCCL);
        }
    }

    public static boolean createArchive(IPath path) {
        return TrueZipUtil.createArchive(path.removeLastSegments(1), path.lastSegment());
    }

    public static boolean createArchive(File parentFile, IPath relative) {
        ClassLoader bundleLoader = ArchivesCorePlugin.getDefault().getBundleClassLoader();
        ClassLoader originalTCCL = Thread.currentThread().getContextClassLoader();
        try {
            Thread.currentThread().setContextClassLoader(bundleLoader);
            de.schlichtherle.io.File archive = TrueZipUtil.getRelativeArchiveFile(parentFile, relative);
            boolean b = archive.mkdirs();
            boolean bl = b && TrueZipUtil.updateParentTimestamps(archive);
            return bl;
        }
        finally {
            Thread.currentThread().setContextClassLoader(originalTCCL);
        }
    }

    public static de.schlichtherle.io.File getRelativeArchiveFile(File parentFile, IPath relative) {
        ClassLoader bundleLoader = ArchivesCorePlugin.getDefault().getBundleClassLoader();
        ClassLoader originalTCCL = Thread.currentThread().getContextClassLoader();
        try {
            Thread.currentThread().setContextClassLoader(bundleLoader);
            de.schlichtherle.io.File file = TrueZipUtil.getRelativeArchiveFileInternal(parentFile, relative);
            return file;
        }
        finally {
            Thread.currentThread().setContextClassLoader(originalTCCL);
        }
    }

    private static de.schlichtherle.io.File getRelativeArchiveFileInternal(File parentFile, IPath relative) {
        de.schlichtherle.io.File working = null;
        working = parentFile instanceof de.schlichtherle.io.File ? (de.schlichtherle.io.File)parentFile : new de.schlichtherle.io.File(parentFile);
        if (relative.segmentCount() == 0) {
            return working;
        }
        IPath finalFileRelativeLocationPath = relative.removeLastSegments(1);
        de.schlichtherle.io.File finalFileLocation = TrueZipUtil.getFileInArchive(working, finalFileRelativeLocationPath);
        de.schlichtherle.io.File retval = new de.schlichtherle.io.File((File)finalFileLocation, relative.lastSegment(), TrueZipUtil.getJarArchiveDetector());
        return retval;
    }

    public static void umount() {
        ClassLoader bundleLoader = ArchivesCorePlugin.getDefault().getBundleClassLoader();
        ClassLoader originalTCCL = Thread.currentThread().getContextClassLoader();
        try {
            Thread.currentThread().setContextClassLoader(bundleLoader);
            try {
                de.schlichtherle.io.File.umount();
            }
            catch (ArchiveException archiveException) {}
        }
        finally {
            Thread.currentThread().setContextClassLoader(originalTCCL);
        }
    }

    public static void syncExec(Runnable run) {
        try {
            if (run != null) {
                run.run();
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        TrueZipUtil.umount();
    }

    public static void sync() {
        TrueZipUtil.syncExec(null);
    }

    public static boolean updateParentTimestamps(IPath path) {
        return TrueZipUtil.updateParentTimestamps(TrueZipUtil.getFile(path));
    }

    public static boolean updateParentTimestamps(de.schlichtherle.io.File file) {
        ClassLoader bundleLoader = ArchivesCorePlugin.getDefault().getBundleClassLoader();
        ClassLoader originalTCCL = Thread.currentThread().getContextClassLoader();
        try {
            Thread.currentThread().setContextClassLoader(bundleLoader);
            long time = System.currentTimeMillis();
            de.schlichtherle.io.File parent = (de.schlichtherle.io.File)file.getParentFile();
            boolean b = true;
            while (parent != null) {
                b &= parent.setLastModified(time);
                parent = parent.getEnclArchive();
            }
            boolean bl = b;
            return bl;
        }
        finally {
            Thread.currentThread().setContextClassLoader(originalTCCL);
        }
    }

    public static ArchiveDetector getJarArchiveDetector() {
        ClassLoader bundleLoader = ArchivesCorePlugin.getDefault().getBundleClassLoader();
        ClassLoader originalTCCL = Thread.currentThread().getContextClassLoader();
        try {
            Thread.currentThread().setContextClassLoader(bundleLoader);
            if (JAR_ARCHIVE_DETECTOR == null) {
                JAR_ARCHIVE_DETECTOR = new JarArchiveDetector();
            }
            ArchiveDetector archiveDetector = JAR_ARCHIVE_DETECTOR;
            return archiveDetector;
        }
        finally {
            Thread.currentThread().setContextClassLoader(originalTCCL);
        }
    }

    public static ArchiveDetector getNullArchiveDetector() {
        ClassLoader bundleLoader = ArchivesCorePlugin.getDefault().getBundleClassLoader();
        ClassLoader originalTCCL = Thread.currentThread().getContextClassLoader();
        try {
            Thread.currentThread().setContextClassLoader(bundleLoader);
            DefaultArchiveDetector defaultArchiveDetector = ArchiveDetector.NULL;
            return defaultArchiveDetector;
        }
        finally {
            Thread.currentThread().setContextClassLoader(originalTCCL);
        }
    }

    public static ArchiveDetector getDefaultArchiveDetector() {
        ClassLoader bundleLoader = ArchivesCorePlugin.getDefault().getBundleClassLoader();
        ClassLoader originalTCCL = Thread.currentThread().getContextClassLoader();
        try {
            Thread.currentThread().setContextClassLoader(bundleLoader);
            DefaultArchiveDetector defaultArchiveDetector = ArchiveDetector.DEFAULT;
            return defaultArchiveDetector;
        }
        finally {
            Thread.currentThread().setContextClassLoader(originalTCCL);
        }
    }

    public static boolean archiveCopyAllTo(File source, ArchiveDetector detector, File destination) {
        ClassLoader bundleLoader = ArchivesCorePlugin.getDefault().getBundleClassLoader();
        ClassLoader originalTCCL = Thread.currentThread().getContextClassLoader();
        try {
            Thread.currentThread().setContextClassLoader(bundleLoader);
            boolean bl = new de.schlichtherle.io.File(source, detector).archiveCopyAllTo(destination);
            return bl;
        }
        finally {
            Thread.currentThread().setContextClassLoader(originalTCCL);
        }
    }

    public static boolean javaIODeleteDir(File dir) {
        if (dir.isDirectory()) {
            String[] children = dir.list();
            int i = 0;
            while (i < children.length) {
                boolean success = TrueZipUtil.javaIODeleteDir(new File(dir, children[i]));
                if (!success) {
                    return false;
                }
                ++i;
            }
        }
        return dir.delete();
    }

    public static de.schlichtherle.io.File getFileInArchive(de.schlichtherle.io.File root, IPath relative) {
        ClassLoader bundleLoader = ArchivesCorePlugin.getDefault().getBundleClassLoader();
        ClassLoader originalTCCL = Thread.currentThread().getContextClassLoader();
        try {
            Thread.currentThread().setContextClassLoader(bundleLoader);
            while (relative.segmentCount() > 0) {
                root = new de.schlichtherle.io.File((File)root, relative.segment(0), (ArchiveDetector)ArchiveDetector.NULL);
                relative = relative.removeFirstSegments(1);
            }
            de.schlichtherle.io.File file = root;
            return file;
        }
        finally {
            Thread.currentThread().setContextClassLoader(originalTCCL);
        }
    }

    public static File getDestinationJar(File root, IPath relative) {
        ClassLoader bundleLoader = ArchivesCorePlugin.getDefault().getBundleClassLoader();
        ClassLoader originalTCCL = Thread.currentThread().getContextClassLoader();
        try {
            Thread.currentThread().setContextClassLoader(bundleLoader);
            while (relative.segmentCount() > 0) {
                if (relative.segmentCount() == 1) {
                    String string = relative.segment(0);
                    TrueZipUtil.getJarArchiveDetector();
                    root = new de.schlichtherle.io.File(root, string, (ArchiveDetector)ArchiveDetector.ALL);
                } else {
                    root = new de.schlichtherle.io.File(root, relative.segment(0), (ArchiveDetector)ArchiveDetector.NULL);
                }
                relative = relative.removeFirstSegments(1);
            }
            File file = root;
            return file;
        }
        finally {
            Thread.currentThread().setContextClassLoader(originalTCCL);
        }
    }

    public static boolean deleteAll(File f) {
        if (f instanceof de.schlichtherle.io.File) {
            return ((de.schlichtherle.io.File)f).deleteAll();
        }
        return f.delete();
    }

    private static class JarArchiveDetector
    extends AbstractArchiveDetector {
        private JarArchiveDetector() {
        }

        public ArchiveDriver getArchiveDriver(String arg0) {
            return new JarDriver();
        }
    }
}

