/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.ide.eclipse.as.rse.core;

import java.io.File;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Status;
import org.eclipse.rse.core.model.IHost;
import org.eclipse.rse.services.shells.IHostShell;
import org.eclipse.wst.server.core.IServer;
import org.eclipse.wst.server.core.IServerAttributes;
import org.eclipse.wst.server.core.IServerWorkingCopy;
import org.jboss.ide.eclipse.as.core.server.IDeployableServer;
import org.jboss.ide.eclipse.as.core.server.IJBossServerRuntime;
import org.jboss.ide.eclipse.as.core.server.internal.ExtendedServerPropertiesAdapterFactory;
import org.jboss.ide.eclipse.as.core.server.internal.extendedproperties.ServerExtendedProperties;
import org.jboss.ide.eclipse.as.core.server.internal.v7.LocalJBoss7ServerRuntime;
import org.jboss.ide.eclipse.as.core.util.RemotePath;
import org.jboss.ide.eclipse.as.core.util.RuntimeUtils;
import org.jboss.ide.eclipse.as.rse.core.RSEFrameworkUtils;
import org.jboss.ide.eclipse.as.rse.core.subsystems.RSEDeploymentOptionsController;
import org.jboss.ide.eclipse.as.wtp.core.server.behavior.ServerProfileModel;

public class RSEUtils {
    private static final char UNIX_SEPARATOR = '/';
    private static final char WINDOWS_SEPARATOR = '\\';
    public static final String RSE_SERVER_CONFIG = "org.jboss.ide.eclipse.as.rse.core.RSEServerConfig";
    public static final String RSE_BASE_DIR = "org.jboss.ide.eclipse.as.rse.core.RSEServerBaseDir";
    public static final String RSE_SERVER_HOME_DIR = "org.jboss.ide.eclipse.as.rse.core.RSEServerHomeDir";
    public static final String RSE_SERVER_HOST = "org.jboss.ide.eclipse.as.rse.core.ServerHost";
    public static final String RSE_SERVER_DEFAULT_HOST = "Local";
    public static final String RSE_MODE = "rse";

    public static String getRSEConnectionName(IServerAttributes server) {
        return server.getAttribute(RSE_SERVER_HOST, RSE_SERVER_DEFAULT_HOST);
    }

    public static String getRSEHomeDir(IServer server, boolean errorOnFail) throws CoreException {
        String rseHome = null;
        rseHome = errorOnFail ? RSEUtils.checkedGetRSEHomeDir((IServerAttributes)server) : RSEUtils.getRSEHomeDir((IServerAttributes)server);
        return rseHome == null ? "" : rseHome;
    }

    public static String getRSEHomeDir(IServerAttributes server) {
        String defaultVal = "";
        if (server.getRuntime() != null && server.getRuntime().getLocation() != null) {
            defaultVal = server.getRuntime().getLocation().toString();
        }
        return server.getAttribute(RSE_SERVER_HOME_DIR, defaultVal);
    }

    public static String checkedGetRSEHomeDir(IServerAttributes server) throws CoreException {
        String serverHome = server.getAttribute(RSE_SERVER_HOME_DIR, server.getRuntime().getLocation().toString());
        if (serverHome == null) {
            throw new CoreException((IStatus)new Status(4, "org.eclipse.rse.core", "Remote Server Home not set."));
        }
        return serverHome;
    }

    public static String getRSEConfigFile(IServerAttributes server) {
        return RSEUtils.getRSEConfigName(server);
    }

    public static String getRSEConfigName(IServerAttributes server) {
        IJBossServerRuntime runtime = RuntimeUtils.getJBossServerRuntime((IServerAttributes)server);
        ServerExtendedProperties sep = ExtendedServerPropertiesAdapterFactory.getServerExtendedProperties((IServerAttributes)server);
        String defVal = "default";
        if (runtime != null) {
            boolean isAS7Style = sep != null && sep.getFileStructure() == 2;
            boolean useAS7 = isAS7Style && runtime instanceof LocalJBoss7ServerRuntime;
            defVal = useAS7 ? ((LocalJBoss7ServerRuntime)runtime).getConfigurationFile() : runtime.getJBossConfiguration();
        }
        return server.getAttribute(RSE_SERVER_CONFIG, defVal);
    }

    public static String getDeployRootFolder(IDeployableServer server) {
        return RSEUtils.getDeployRootFolder(server.getServer());
    }

    public static String getDeployRootFolder(IServer server) {
        RSEDeploymentOptionsController controller = new RSEDeploymentOptionsController();
        controller.initialize((IServerAttributes)server, null, null);
        return controller.getDeploymentsRootFolder(true);
    }

    @Deprecated
    protected static IPath getBaseDirectoryPath(IServerAttributes server) {
        return RSEUtils.getBaseDirectoryPath(server, File.pathSeparatorChar);
    }

    protected static IPath getBaseDirectoryPath(IServerAttributes server, char sep) {
        String val = server.getAttribute(RSE_BASE_DIR, "standalone");
        RemotePath valPath = new RemotePath(val, sep);
        if (valPath.isAbsolute()) {
            return valPath;
        }
        IPath ret = RSEUtils.makeGlobal(server, (IPath)valPath, sep);
        return ret;
    }

    public static String getBaseDirectory(IServerAttributes server, char separator) {
        return RSEUtils.getBaseDirectoryPath(server, separator).toOSString();
    }

    public static IPath makeRelative(IServerAttributes server, IPath p) {
        return RSEUtils.makeRelative(server, p, File.pathSeparatorChar);
    }

    public static IPath makeRelative(IServerAttributes server, IPath p, char sep) {
        RemotePath rseHome;
        RemotePath p1 = new RemotePath(p.toString(), sep);
        if (p1.isAbsolute() && (rseHome = new RemotePath(RSEUtils.getRSEHomeDir(server), sep)).isPrefixOf((IPath)p1)) {
            return p1.makeRelativeTo((IPath)rseHome);
        }
        return p;
    }

    public static String makeRelativeString(IServerAttributes server, IPath p, char sep) {
        RemotePath rseHome;
        String rseHomeString;
        RemotePath p1 = new RemotePath(p.toString(), sep);
        String p1String = p1.toOSString();
        if (p1.isAbsolute() && p1String.startsWith(rseHomeString = (rseHome = new RemotePath(RSEUtils.getRSEHomeDir(server), sep)).toOSString())) {
            return p1String.substring(rseHomeString.length());
        }
        return p1String;
    }

    public static IPath makeGlobal(IServerAttributes server, IPath p) {
        return RSEUtils.makeGlobal(server, p, RSEUtils.getRemoteSystemSeparatorCharacter(server));
    }

    public static IPath makeGlobal(IServerAttributes server, IPath p, char sep) {
        String home = RSEUtils.getRSEHomeDir(server);
        if (home == null) {
            return p.makeAbsolute();
        }
        if (!p.isAbsolute()) {
            return new RemotePath(home, sep).makeAbsolute().append(p);
        }
        return p;
    }

    public static IServer setServerToRSEMode(IServer server, IHost newHost) throws CoreException {
        IServerWorkingCopy wc = server.createWorkingCopy();
        ServerProfileModel.setProfile((IServerWorkingCopy)wc, (String)RSE_MODE);
        wc.setAttribute(RSE_SERVER_HOST, newHost.getAliasName());
        wc.setAttribute("hostname", newHost.getHostName());
        return wc.save(false, (IProgressMonitor)new NullProgressMonitor());
    }

    public static IServer setServerToRSEMode(IServer server, IHost newHost, String jbossHome, String config) throws CoreException {
        IServerWorkingCopy wc = server.createWorkingCopy();
        ServerProfileModel.setProfile((IServerWorkingCopy)wc, (String)RSE_MODE);
        wc.setAttribute(RSE_SERVER_CONFIG, config);
        wc.setAttribute(RSE_SERVER_HOME_DIR, jbossHome);
        wc.setAttribute(RSE_SERVER_HOST, newHost.getAliasName());
        wc.setAttribute("hostname", newHost.getHostName());
        wc.setAttribute("org.jboss.ide.eclipse.as.core.server.deployDirectoryType", "server");
        return wc.save(false, (IProgressMonitor)new NullProgressMonitor());
    }

    public static boolean isActive(IHostShell shell) {
        return shell != null && shell.isActive();
    }

    public static String pathToRemoteSystem(IHost host, String path, String tail) {
        char sep = RSEUtils.getRemoteSystemSeparatorCharacter(host);
        RemotePath rp = new RemotePath(path, sep);
        if (tail != null) {
            rp = rp.append(tail);
        }
        return rp.toOSString();
    }

    public static boolean connectedToWindowsHost(IServerAttributes server) {
        IHost host = RSEFrameworkUtils.findHost(RSEUtils.getRSEConnectionName(server));
        return host == null ? false : RSEFrameworkUtils.isHostWindows(host);
    }

    public static char getRemoteSystemSeparatorCharacter(IServerAttributes server) {
        return RSEUtils.connectedToWindowsHost(server) ? (char)'\\' : '/';
    }

    public static char getRemoteSystemSeparatorCharacter(IHost host) {
        boolean win = host == null ? false : RSEFrameworkUtils.isHostWindows(host);
        return win ? (char)'\\' : '/';
    }
}

