/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.ide.eclipse.as.rse.core.subsystems;

import org.eclipse.core.runtime.IPath;
import org.jboss.ide.eclipse.as.core.util.RemotePath;
import org.jboss.ide.eclipse.as.rse.core.RSEUtils;
import org.jboss.tools.as.core.server.controllable.systems.AbstractJBossDeploymentOptionsController;
import org.jboss.tools.as.core.server.controllable.systems.IDeploymentOptionsController;

public class RSEDeploymentOptionsController
extends AbstractJBossDeploymentOptionsController
implements IDeploymentOptionsController {
    private Character separator;

    protected char getTargetSystemSeparator() {
        if (this.separator == null) {
            Character c = (Character)this.getEnvironment().get("PathHandling.TargetSystemSeparator");
            if (c == null) {
                c = Character.valueOf(RSEUtils.getRemoteSystemSeparatorCharacter(this.getServerOrWC()));
            }
            this.separator = c;
        }
        return this.separator.charValue();
    }

    public char getPathSeparatorCharacter() {
        return this.getTargetSystemSeparator();
    }

    public String makeGlobal(String original) {
        char sep = this.getTargetSystemSeparator();
        IPath ret = RSEUtils.makeGlobal(this.getServerOrWC(), (IPath)new RemotePath(original, sep), sep);
        return new RemotePath(ret.toString(), sep).toOSString();
    }

    public String makeRelative(String original) {
        char sep = this.getTargetSystemSeparator();
        String ret = RSEUtils.makeRelativeString(this.getServerOrWC(), (IPath)new RemotePath(original, sep), sep);
        return ret;
    }

    public String getCurrentDeploymentLocationType() {
        boolean isDepOnly = this.getServer().getServerType().getId().equals("org.jboss.ide.eclipse.as.systemCopyServer");
        if (isDepOnly) {
            return "custom";
        }
        return this.getServerOrWC().getAttribute("org.jboss.ide.eclipse.as.core.server.deployDirectoryType", "server");
    }

    protected String getDeployFolder(String type) {
        String ret = null;
        if ("custom".equals(type) && (ret = this.getServerOrWC().getAttribute("org.jboss.ide.eclipse.as.core.server.deployDirectory", null)) != null) {
            if (this.isDeployOnlyServer()) {
                return new RemotePath(ret, this.getTargetSystemSeparator()).makeAbsolute().toOSString();
            }
            return ret;
        }
        if (this.isAS7Structure()) {
            String baseDir = RSEUtils.getBaseDirectory(this.getServerOrWC(), this.getTargetSystemSeparator());
            IPath ret2 = new RemotePath(baseDir, this.getTargetSystemSeparator()).append("deployments");
            return RSEUtils.makeRelative(this.getServerOrWC(), ret2, this.getTargetSystemSeparator()).toOSString();
        }
        String loc = "server";
        String config = RSEUtils.getRSEConfigName(this.getServerOrWC());
        if (loc == null || config == null) {
            return null;
        }
        String p = new RemotePath(loc, this.getTargetSystemSeparator()).append(config).append("deploy").toOSString();
        return p;
    }

    protected String getTempDeployFolder(String type) {
        return this.getDeployFolder(type);
    }
}

