/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.ide.eclipse.as.rse.core.util;

import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.osgi.util.NLS;
import org.eclipse.rse.core.model.IHost;
import org.eclipse.rse.services.clientserver.messages.SystemMessageException;
import org.eclipse.wst.server.core.IServer;
import org.eclipse.wst.server.core.IServerAttributes;
import org.jboss.ide.eclipse.as.rse.core.RSEFrameworkUtils;
import org.jboss.ide.eclipse.as.rse.core.RSEUtils;
import org.jboss.tools.foundation.core.jobs.BarrierProgressWaitJob;

public class RemoteCallWrapperUtility {
    private static IStatus generateFailStatus(IServer server, String message, String resource, Exception sme) {
        String connectionName;
        String exceptionMsg = sme.getMessage();
        if ("Missing element for : ''".equals(exceptionMsg)) {
            sme = new Exception("The requested path is not found on the remote system.", sme);
        }
        IHost host = (connectionName = RSEUtils.getRSEConnectionName((IServerAttributes)server)) == null ? null : RSEFrameworkUtils.findHost(connectionName);
        Status s = new Status(4, "org.jboss.ide.eclipse.as.rse.core", 1644298251, NLS.bind((String)message, (Object)resource, (Object)(host == null ? null : host.getName())), (Throwable)sme);
        return s;
    }

    /*
     * Loose catch block
     */
    public static Exception wrapRemoteCallStatusTimeLimit(IServer server, NamedRunnableWithProgress runnable, String remoteResource, String failErrorMessage, final int maxDelay, final IProgressMonitor monitor) {
        Thread t = new Thread("Remote call timer"){

            @Override
            public void run() {
                try {
                    Thread.sleep(maxDelay);
                    monitor.setCanceled(true);
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
            }
        };
        t.start();
        try {
            try {
                RemoteCallWrapperUtility.wrapRemoteCall(server, runnable, remoteResource, failErrorMessage, true, monitor);
            }
            catch (CoreException e) {
                if (e.getStatus().getSeverity() == 8) {
                    CoreException coreException = new CoreException((IStatus)new Status(8, "org.jboss.ide.eclipse.as.rse.core", "The remote operation has been canceled because it did not finish in the alloted time (" + maxDelay + "ms)"));
                    t.interrupt();
                    return coreException;
                }
                CoreException coreException = e;
                t.interrupt();
                return coreException;
            }
            catch (RuntimeException e) {
                RuntimeException runtimeException = e;
                t.interrupt();
                return runtimeException;
                {
                    catch (Throwable throwable) {
                        throw throwable;
                    }
                }
            }
        }
        finally {
            t.interrupt();
        }
        return null;
    }

    public static IStatus wrapRemoteCall(IServer server, NamedRunnableWithProgress runnable, String remoteResource, String failErrorMessage, boolean alwaysThrow, IProgressMonitor monitor) throws CoreException, RuntimeException {
        monitor.setTaskName(runnable.getName());
        BarrierProgressWaitJob j = new BarrierProgressWaitJob(runnable.getName(), (BarrierProgressWaitJob.IRunnableWithProgress)runnable);
        j.schedule();
        j.monitorSafeJoin(monitor);
        if (j.getReturnValue() != null) {
            IStatus s = (IStatus)j.getReturnValue();
            return s;
        }
        if (j.getThrowable() != null) {
            if (j.getThrowable() instanceof SystemMessageException) {
                IStatus stat = RemoteCallWrapperUtility.generateFailStatus(server, failErrorMessage, remoteResource, (Exception)((Object)((SystemMessageException)j.getThrowable())));
                if (alwaysThrow) {
                    throw new CoreException(stat);
                }
                return stat;
            }
            if (j.getThrowable() instanceof CoreException) {
                throw new CoreException(((CoreException)j.getThrowable()).getStatus());
            }
            throw new RuntimeException(j.getThrowable());
        }
        return Status.CANCEL_STATUS;
    }

    public static abstract class NamedRunnableWithProgress
    implements BarrierProgressWaitJob.IRunnableWithProgress {
        private String name;

        public NamedRunnableWithProgress(String name) {
            this.name = name;
        }

        public String getName() {
            return this.name;
        }
    }
}

