/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.ide.eclipse.as.rse.core.xpl;

import java.util.ArrayList;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.core.runtime.Status;
import org.eclipse.rse.core.model.IHost;
import org.eclipse.rse.core.subsystems.IConnectorService;
import org.eclipse.rse.core.subsystems.ISubSystem;
import org.eclipse.rse.services.clientserver.messages.SystemMessageException;

public class ConnectAllSubsystemsUtil {
    private IHost _connection;

    public ConnectAllSubsystemsUtil(IHost host) {
        this._connection = host;
    }

    public IStatus run(IProgressMonitor monitor) {
        ArrayList<IConnectorService> failedSystems = new ArrayList<IConnectorService>();
        try {
            ISubSystem[] subsystems = this._connection.getSubSystems();
            int i = 0;
            while (i < subsystems.length) {
                ISubSystem subsystem = subsystems[i];
                IConnectorService system = subsystem.getConnectorService();
                if (!subsystem.isConnected() && subsystem.getSubSystemConfiguration().supportsSubSystemConnect() && !failedSystems.contains(system)) {
                    try {
                        subsystem.connect(monitor, false);
                    }
                    catch (SystemMessageException e) {
                        failedSystems.add(system);
                    }
                    catch (Exception e) {
                        failedSystems.add(system);
                        if (e instanceof InterruptedException || e instanceof OperationCanceledException) break;
                    }
                }
                ++i;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (failedSystems.size() > 0) {
            return Status.CANCEL_STATUS;
        }
        return Status.OK_STATUS;
    }
}

