/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.ide.eclipse.as.reddeer.server.requirement;

import org.jboss.ide.eclipse.as.reddeer.server.family.FamilyAS;
import org.jboss.ide.eclipse.as.reddeer.server.family.FamilyEAP;
import org.jboss.ide.eclipse.as.reddeer.server.family.FamilyWildFly;
import org.jboss.ide.eclipse.as.reddeer.server.requirement.ServerReqType;
import org.jboss.ide.eclipse.as.reddeer.server.requirement.ServerReqVersion;
import org.jboss.reddeer.requirements.server.IServerFamily;

class ServerMatcher {
    ServerMatcher() {
    }

    static boolean matchServerFamily(ServerReqType.ServerReqFamily serverFamily, IServerFamily configServerType) {
        return serverFamily == ServerReqType.ServerReqFamily.ANY || serverFamily == ServerReqType.ServerReqFamily.AS && configServerType instanceof FamilyAS || serverFamily == ServerReqType.ServerReqFamily.EAP && configServerType instanceof FamilyEAP || serverFamily == ServerReqType.ServerReqFamily.WILDFLY && configServerType instanceof FamilyWildFly;
    }

    static boolean matchServerVersion(String requiredVersion, ServerReqVersion versionMatcher, String configVersion) {
        if (requiredVersion == null || requiredVersion.length() == 0) {
            return true;
        }
        int versionNum = ServerMatcher.parseServerVersionNumber(requiredVersion);
        int configVersionNum = ServerMatcher.parseServerVersionNumber(configVersion);
        switch (versionMatcher) {
            case EQUAL: {
                return versionNum == configVersionNum;
            }
            case NOT_EQUAL: {
                return versionNum != configVersionNum;
            }
            case GREATER: {
                return configVersionNum > versionNum;
            }
            case GREATER_OR_EQUAL: {
                return configVersionNum >= versionNum;
            }
            case LESS: {
                return configVersionNum < versionNum;
            }
            case LESS_OR_EQUAL: {
                return configVersionNum <= versionNum;
            }
        }
        throw new IllegalArgumentException("Version matcher " + (Object)((Object)versionMatcher) + " was not recognized!");
    }

    private static int parseServerVersionNumber(String version) {
        boolean onlyMajorVersionEndingWithDot;
        int idx = (version = version.replaceAll("[^0-9.]", "")).indexOf(".");
        boolean onlyMajorVersion = idx == 0;
        boolean bl = onlyMajorVersionEndingWithDot = idx + 1 == version.length();
        if (onlyMajorVersion || onlyMajorVersionEndingWithDot) {
            return Integer.parseInt(version.replaceAll("[.]", "")) * 10;
        }
        String majorVersion = version.substring(0, idx);
        String minorVersion = version.substring(idx + 1, version.length());
        if (minorVersion.length() > 1) {
            throw new IllegalArgumentException("Version '" + version + "' must have format ## or ##.#");
        }
        return Integer.parseInt(majorVersion) * 10 + Integer.parseInt(minorVersion);
    }
}

