/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.ide.eclipse.as.reddeer.server.wizard.page;

import java.util.LinkedList;
import java.util.List;
import org.hamcrest.Description;
import org.hamcrest.Matcher;
import org.hamcrest.TypeSafeMatcher;
import org.jboss.reddeer.jface.wizard.WizardPage;
import org.jboss.reddeer.swt.api.Combo;
import org.jboss.reddeer.swt.impl.button.CheckBox;
import org.jboss.reddeer.swt.impl.button.RadioButton;
import org.jboss.reddeer.swt.impl.combo.DefaultCombo;

public class NewServerAdapterPage
extends WizardPage {
    private static final String NEW_RUNTIME_LABEL = "Create new runtime (next page)";

    public void setProfile(Profile profile) {
        switch (profile) {
            case REMOTE: {
                new RadioButton("Remote").click();
                break;
            }
            default: {
                new RadioButton("Local").click();
            }
        }
    }

    public Profile getProfile() {
        if (new RadioButton("Local").isSelected()) {
            return Profile.LOCAL;
        }
        return Profile.REMOTE;
    }

    public void setAssignRuntime(boolean assign) {
        CheckBox check = new CheckBox();
        if (check.isChecked() != assign) {
            check.click();
        }
    }

    public List<String> getRuntimes() {
        LinkedList<String> items = new LinkedList<String>(this.getRuntimeCombo().getItems());
        items.remove(NEW_RUNTIME_LABEL);
        return items;
    }

    public void setRuntime(String runtime) {
        Combo combo = this.getRuntimeCombo();
        if (runtime == null) {
            combo.setSelection(NEW_RUNTIME_LABEL);
        } else {
            combo.setSelection(runtime);
        }
    }

    public String getRuntime() {
        String runtime = this.getRuntimeCombo().getSelection();
        if (runtime.equals(NEW_RUNTIME_LABEL)) {
            return null;
        }
        return runtime;
    }

    private Combo getRuntimeCombo() {
        return new DefaultCombo(new Matcher[]{new RuntimeComboMatcher()});
    }

    public void checkErrors() {
    }

    public static enum Profile {
        LOCAL("Local"),
        REMOTE("Remote");

        private String label;

        private Profile(String label) {
            this.label = label;
        }

        public String getLabel() {
            return this.label;
        }
    }

    class RuntimeComboMatcher
    extends TypeSafeMatcher<org.eclipse.swt.widgets.Combo> {
        RuntimeComboMatcher() {
        }

        protected boolean matchesSafely(org.eclipse.swt.widgets.Combo combo) {
            String[] stringArray = combo.getItems();
            int n = stringArray.length;
            int n2 = 0;
            while (n2 < n) {
                String item = stringArray[n2];
                if (item.trim().equals(NewServerAdapterPage.NEW_RUNTIME_LABEL)) {
                    return true;
                }
                ++n2;
            }
            return false;
        }

        public void describeTo(Description arg0) {
        }
    }
}

