/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.wtp.server.launchbar.targets;

import java.util.ArrayList;
import java.util.Arrays;
import org.eclipse.launchbar.core.target.ILaunchTarget;
import org.eclipse.launchbar.core.target.ILaunchTargetManager;
import org.eclipse.launchbar.core.target.ILaunchTargetProvider;
import org.eclipse.launchbar.core.target.TargetStatus;
import org.eclipse.wst.server.core.IServer;
import org.eclipse.wst.server.core.IServerLifecycleListener;
import org.eclipse.wst.server.core.ServerCore;

public class ServerLaunchTargetProvider
implements ILaunchTargetProvider,
IServerLifecycleListener {
    private static final String TYPE = "org.eclipse.launchbar.core.launchTargetType.wst.server";
    private ILaunchTargetManager manager = null;

    public ServerLaunchTargetProvider() {
        ServerCore.addServerLifecycleListener((IServerLifecycleListener)this);
    }

    public synchronized void init(ILaunchTargetManager targetManager) {
        this.manager = targetManager;
        IServer[] all = ServerCore.getServers();
        ArrayList<ILaunchTarget> existingTargets = new ArrayList<ILaunchTarget>(Arrays.asList(targetManager.getLaunchTargetsOfType(TYPE)));
        int i = 0;
        while (i < all.length) {
            ILaunchTarget t = targetManager.getLaunchTarget(TYPE, all[i].getName());
            if (t == null) {
                targetManager.addLaunchTarget(TYPE, all[i].getName());
            } else {
                existingTargets.remove(t);
            }
            ++i;
        }
        for (ILaunchTarget lt : existingTargets) {
            targetManager.removeLaunchTarget(lt);
        }
    }

    public TargetStatus getStatus(ILaunchTarget target) {
        return TargetStatus.OK_STATUS;
    }

    public synchronized void serverAdded(IServer server) {
        if (this.manager != null && server != null) {
            this.manager.addLaunchTarget(TYPE, server.getName());
        }
    }

    public synchronized void serverChanged(IServer server) {
        ILaunchTarget existing;
        if (this.manager != null && server != null && (existing = this.manager.getLaunchTarget(TYPE, server.getName())) == null) {
            this.init(this.manager);
        }
    }

    public synchronized void serverRemoved(IServer server) {
        ILaunchTarget existing;
        if (this.manager != null && server != null && (existing = this.manager.getLaunchTarget(TYPE, server.getName())) != null) {
            this.manager.removeLaunchTarget(existing);
        }
    }
}

