/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.ide.eclipse.as.internal.management.eap61plus;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.eclipse.osgi.util.NLS;
import org.jboss.as.controller.client.ModelControllerClient;
import org.jboss.as.controller.client.Operation;
import org.jboss.dmr.ModelNode;
import org.jboss.dmr.ModelType;
import org.jboss.dmr.Property;
import org.jboss.ide.eclipse.as.internal.management.eap61plus.DefaultOperationRequestBuilder;
import org.jboss.ide.eclipse.as.internal.management.eap61plus.Messages;
import org.jboss.ide.eclipse.as.management.core.JBoss7ManangerException;
import org.jboss.ide.eclipse.as.management.core.OperationFormatException;

public class EAP61PlusManagerUtil {
    public static boolean isSuccess(ModelNode operationResult) {
        if (operationResult != null) {
            ModelNode outcome = operationResult.get("outcome");
            return outcome != null && outcome.asString().equals("success");
        }
        return false;
    }

    public static String getFailureDescription(ModelNode operationResult) {
        if (operationResult == null) {
            return null;
        }
        ModelNode descr = operationResult.get("failure-description");
        if (descr == null) {
            return null;
        }
        return descr.asString();
    }

    public static List<String> getList(ModelNode operationResult) {
        if (!operationResult.hasDefined("result")) {
            return Collections.emptyList();
        }
        List nodeList = operationResult.get("result").asList();
        if (nodeList.isEmpty()) {
            return Collections.emptyList();
        }
        ArrayList<String> list = new ArrayList<String>(nodeList.size());
        for (ModelNode node : nodeList) {
            list.add(node.asString());
        }
        return list;
    }

    public static List<String> getRequestPropertyNames(ModelNode operationResult) {
        if (!operationResult.hasDefined("result")) {
            return Collections.emptyList();
        }
        ModelNode result = operationResult.get("result");
        if (!result.hasDefined("request-properties")) {
            return Collections.emptyList();
        }
        List nodeList = result.get("request-properties").asPropertyList();
        if (nodeList.isEmpty()) {
            return Collections.emptyList();
        }
        ArrayList<String> list = new ArrayList<String>(nodeList.size());
        for (Property node : nodeList) {
            list.add(node.getName());
        }
        return list;
    }

    public static boolean isDeployed(String name, ModelControllerClient client) {
        try {
            return EAP61PlusManagerUtil.getDeployments(client).contains(name);
        }
        catch (IOException ioe) {
            return false;
        }
    }

    public static List<String> getDeployments(ModelControllerClient client) throws IOException {
        ModelNode request;
        DefaultOperationRequestBuilder builder = new DefaultOperationRequestBuilder();
        try {
            builder.operationName("read-children-names");
            builder.addProperty("child-type", "deployment");
            request = builder.buildRequest();
        }
        catch (OperationFormatException e) {
            throw new IllegalStateException(Messages.FailedToBuildOperation, e);
        }
        ModelNode outcome = client.execute(request);
        if (EAP61PlusManagerUtil.isSuccess(outcome)) {
            return EAP61PlusManagerUtil.getList(outcome);
        }
        return Collections.emptyList();
    }

    public static Boolean getBooleanProperty(String propertyName, ModelNode node) {
        if (node == null) {
            return null;
        }
        ModelNode valueNode = node.get(propertyName);
        if (valueNode == null) {
            return null;
        }
        String value = valueNode.toString();
        if (value == null || valueNode.getType() != ModelType.BOOLEAN) {
            return null;
        }
        return Boolean.valueOf(value);
    }

    public static ModelNode execute(Operation operation, ModelControllerClient client) throws JBoss7ManangerException {
        try {
            ModelNode result = client.execute(operation);
            if (result.hasDefined("outcome") && "success".equals(result.get("outcome").asString())) {
                return result.get("result");
            }
            if (result.hasDefined("failure-description")) {
                throw new JBoss7ManangerException(result.get("failure-description").toString());
            }
            throw new JBoss7ManangerException(NLS.bind((String)Messages.OperationOutcomeToString, (Object)result.get("outcome").asString()));
        }
        catch (IOException e) {
            throw new JBoss7ManangerException((Throwable)e);
        }
    }
}

