/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.ide.eclipse.archives.webtools.ui;

import java.util.ArrayList;
import org.eclipse.core.runtime.IPath;
import org.eclipse.jface.viewers.ArrayContentProvider;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.jface.wizard.Wizard;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.FormAttachment;
import org.eclipse.swt.layout.FormData;
import org.eclipse.swt.layout.FormLayout;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.wst.server.core.IServerType;
import org.eclipse.wst.server.ui.internal.ImageResource;
import org.jboss.ide.eclipse.archives.core.build.SaveArchivesJob;
import org.jboss.ide.eclipse.archives.core.model.IArchive;
import org.jboss.ide.eclipse.archives.webtools.Messages;
import org.jboss.ide.eclipse.as.core.server.IDeployableServer;
import org.jboss.ide.eclipse.as.core.util.ServerConverter;

public class ArchivePublishWizard
extends Wizard {
    private ArchivePublishWizardPage page;
    private IArchive pack;

    public ArchivePublishWizard(IArchive pack) {
        this.pack = pack;
        this.setWindowTitle(Messages.ArchivePublishSettings);
    }

    public boolean performFinish() {
        boolean alwaysPublish = new Boolean(this.page.getAlwaysPublish());
        this.pack.setProperty("org.jboss.ide.eclipse.as.core.model.PackagesListener.DeployServers", alwaysPublish ? this.getServers() : null);
        this.pack.setProperty("org.jboss.ide.eclipse.as.core.model.PackagesListener.DeployAfterBuild", this.getAutoDeploy());
        IPath p = this.pack.getProjectPath();
        new SaveArchivesJob(p).schedule();
        return true;
    }

    public void addPages() {
        this.page = new ArchivePublishWizardPage(this.pack);
        this.addPage((IWizardPage)this.page);
    }

    protected String getServers() {
        return this.page.getServers();
    }

    protected String getAutoDeploy() {
        return this.page.getAutoDeploy();
    }

    protected String getAlwaysPublish() {
        return this.page.getAlwaysPublish();
    }

    protected class ArchivePublishLabelProvider
    extends LabelProvider {
        protected ArchivePublishLabelProvider() {
        }

        public Image getImage(Object element) {
            if (element instanceof IDeployableServer) {
                IServerType type = ((IDeployableServer)element).getServer().getServerType();
                return ImageResource.getImage((String)type.getId());
            }
            return null;
        }

        public String getText(Object element) {
            if (element instanceof IDeployableServer) {
                return ((IDeployableServer)element).getServer().getName();
            }
            return element == null ? "" : element.toString();
        }
    }

    public class ArchivePublishWizardPage
    extends WizardPage {
        protected IArchive pack;
        protected TableViewer viewer;
        protected Button autoDeploy;
        protected Button alwaysPublish;
        protected String viewerResult;
        protected String deployResult;
        protected String alwaysPublishResult;

        protected ArchivePublishWizardPage(IArchive pack) {
            super(Messages.SelectServerWizard);
            this.viewerResult = "";
            this.deployResult = Boolean.toString(false);
            this.alwaysPublishResult = Boolean.toString(false);
            this.setDescription(Messages.SelectServerWizardDescription);
            this.setTitle(Messages.SelectServerWizardTitle);
            this.pack = pack;
        }

        public void createControl(Composite parent) {
            Composite mainComposite = new Composite(parent, 0);
            mainComposite.setLayout((Layout)new FormLayout());
            mainComposite.setLayoutData((Object)new GridData(1808));
            this.fillComposite(mainComposite);
            this.addListeners();
            this.setControl((Control)mainComposite);
            this.getContainer().updateTitleBar();
            this.setPackageDefaults();
            IStructuredSelection sel = (IStructuredSelection)this.viewer.getSelection();
            this.setPageComplete(sel.size() > 0);
        }

        protected void setPackageDefaults() {
            String servers;
            this.viewerResult = servers = this.pack.getProperty("org.jboss.ide.eclipse.as.core.model.PackagesListener.DeployServers");
            String deployAfterBuild = this.pack.getProperty("org.jboss.ide.eclipse.as.core.model.PackagesListener.DeployAfterBuild");
            if (servers != null) {
                this.alwaysPublish.setSelection(true);
                this.alwaysPublishSelected();
                boolean depAfterBld = deployAfterBuild != null && new Boolean(deployAfterBuild) != false;
                this.autoDeploy.setSelection(depAfterBld);
                this.autoDeploySelected();
                IDeployableServer[] depServers = ServerConverter.getAllDeployableServers();
                String[] serverList = servers.split(",");
                ArrayList<IDeployableServer> selected = new ArrayList<IDeployableServer>();
                int i = 0;
                while (i < serverList.length) {
                    int j = 0;
                    while (j < depServers.length) {
                        if (serverList[i].equals(depServers[j].getServer().getId())) {
                            selected.add(depServers[j]);
                        }
                        ++j;
                    }
                    ++i;
                }
                this.viewer.setSelection((ISelection)new StructuredSelection(selected.toArray()));
            }
        }

        protected void fillComposite(Composite mainComposite) {
            this.viewer = new TableViewer(mainComposite);
            FormData viewerData = new FormData();
            viewerData.left = new FormAttachment(15, 0);
            viewerData.right = new FormAttachment(85, 0);
            viewerData.top = new FormAttachment(0, 10);
            viewerData.bottom = new FormAttachment(80, 0);
            this.viewer.getTable().setLayoutData((Object)viewerData);
            this.alwaysPublish = new Button(mainComposite, 32);
            FormData always = new FormData();
            always.left = new FormAttachment(15, 0);
            always.top = new FormAttachment((Control)this.viewer.getTable(), 5);
            this.alwaysPublish.setLayoutData((Object)always);
            this.alwaysPublish.setText(Messages.AlwaysPublishToTheseServers);
            this.autoDeploy = new Button(mainComposite, 32);
            FormData add = new FormData();
            add.left = new FormAttachment(15, 0);
            add.top = new FormAttachment((Control)this.alwaysPublish, 5);
            this.autoDeploy.setLayoutData((Object)add);
            this.autoDeploy.setText(Messages.AutoDeployAfterBuild);
        }

        protected void addListeners() {
            this.autoDeploy.addSelectionListener(new SelectionListener(){

                public void widgetDefaultSelected(SelectionEvent e) {
                    this.widgetSelected(e);
                }

                public void widgetSelected(SelectionEvent e) {
                    ArchivePublishWizardPage.this.autoDeploySelected();
                }
            });
            this.viewer.addPostSelectionChangedListener(new ISelectionChangedListener(){

                public void selectionChanged(SelectionChangedEvent event) {
                    ArchivePublishWizardPage.this.viewerSelected();
                }
            });
            this.alwaysPublish.addSelectionListener(new SelectionListener(){

                public void widgetDefaultSelected(SelectionEvent e) {
                    this.widgetSelected(e);
                }

                public void widgetSelected(SelectionEvent e) {
                    ArchivePublishWizardPage.this.alwaysPublishSelected();
                }
            });
            this.viewer.setContentProvider((IContentProvider)new ArrayContentProvider());
            this.viewer.setLabelProvider((IBaseLabelProvider)new ArchivePublishLabelProvider());
            this.viewer.setInput((Object)ServerConverter.getAllDeployableServers());
            this.autoDeploy.setEnabled(false);
        }

        protected void autoDeploySelected() {
            this.deployResult = Boolean.toString(this.autoDeploy.getSelection() && this.autoDeploy.getEnabled());
        }

        protected void alwaysPublishSelected() {
            this.autoDeploy.setEnabled(this.alwaysPublish.getSelection());
            this.deployResult = Boolean.toString(this.autoDeploy.getSelection() && this.autoDeploy.getEnabled());
            this.alwaysPublishResult = Boolean.toString(this.alwaysPublish.getSelection());
        }

        protected void viewerSelected() {
            ISelection sel = this.viewer.getSelection();
            if (sel instanceof IStructuredSelection) {
                IStructuredSelection sel2 = (IStructuredSelection)sel;
                Object[] os = sel2.toArray();
                String tmp = "";
                int i = 0;
                while (i < os.length) {
                    tmp = String.valueOf(tmp) + ((IDeployableServer)os[i]).getServer().getId() + ",";
                    ++i;
                }
                this.viewerResult = tmp;
                this.setPageComplete(sel2.size() > 0);
            }
        }

        protected String getServers() {
            return this.viewerResult;
        }

        protected String getAutoDeploy() {
            return this.deployResult;
        }

        protected String getAlwaysPublish() {
            return this.alwaysPublishResult;
        }
    }
}

