/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.as.ui.bot.itests.archives;

import java.io.File;
import org.jboss.ide.eclipse.archives.ui.test.bot.ArchivesTestBase;
import org.jboss.reddeer.eclipse.jst.ejb.ui.EjbProjectFirstPage;
import org.jboss.reddeer.eclipse.jst.ejb.ui.EjbProjectWizard;
import org.jboss.reddeer.eclipse.jst.servlet.ui.WebProjectFirstPage;
import org.jboss.reddeer.eclipse.jst.servlet.ui.WebProjectWizard;
import org.jboss.reddeer.eclipse.ui.views.log.LogMessage;
import org.jboss.reddeer.eclipse.ui.views.log.LogView;
import org.jboss.reddeer.junit.runner.RedDeerSuite;
import org.jboss.tools.as.ui.bot.itests.Activator;
import org.jboss.tools.as.ui.bot.itests.download.RuntimeDownloadTestUtility;
import org.jboss.tools.as.ui.bot.itests.parametized.server.ServerRuntimeUIConstants;
import org.jboss.tools.as.ui.bot.itests.reddeer.util.DetectRuntimeTemplate;
import org.junit.After;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.Before;
import org.junit.BeforeClass;
import org.junit.Test;
import org.junit.runner.RunWith;

@RunWith(value=RedDeerSuite.class)
public class VariousProjectsArchiving
extends ArchivesTestBase {
    private static String SMOKETEST_TYPE = ServerRuntimeUIConstants.SMOKETEST_DOWNLOADS[0];

    @BeforeClass
    public static void setup() {
        File f = Activator.getDownloadFolder(SMOKETEST_TYPE);
        if (!f.exists() || f.list() == null || f.list().length == 0) {
            RuntimeDownloadTestUtility util = new RuntimeDownloadTestUtility(f);
            util.downloadRuntimeNoCredentials(SMOKETEST_TYPE);
        } else {
            DetectRuntimeTemplate.detectRuntime(f.getAbsolutePath(), ServerRuntimeUIConstants.getRuntimesForDownloadable(SMOKETEST_TYPE));
            DetectRuntimeTemplate.removePath(f.getAbsolutePath());
        }
    }

    @AfterClass
    public static void postClass() {
        new RuntimeDownloadTestUtility(Activator.getStateFolder().toFile()).clean(false);
    }

    @After
    public void checkErrorLog() {
        Assert.assertTrue((String)"Error log contains archive errors", (this.countOfArchivesErrors() == 0 ? 1 : 0) != 0);
    }

    @Before
    public void deleteLogView() {
        VariousProjectsArchiving.deleteErrorView();
    }

    @Test
    public void testDynamicWebProject() {
        String project = "pr1";
        String serverName = ServerRuntimeUIConstants.getServerName(SMOKETEST_TYPE);
        this.createDynamicWebProject(project, String.valueOf(serverName) + " Runtime");
        VariousProjectsArchiving.deleteErrorView();
        view = VariousProjectsArchiving.viewForProject((String)project);
        view.getProject(project).newJarArchive().finish();
        this.assertArchiveIsInView(project, view, String.valueOf(project) + ".jar [/" + project + "]");
    }

    @Test
    public void testEJBProject() {
        String project = "pr2";
        String serverName = ServerRuntimeUIConstants.getServerName(SMOKETEST_TYPE);
        this.createEJBProject(project, String.valueOf(serverName) + " Runtime");
        VariousProjectsArchiving.deleteErrorView();
        view = VariousProjectsArchiving.viewForProject((String)project);
        view.getProject(project).newJarArchive().finish();
        this.assertArchiveIsInView(project, view, String.valueOf(project) + ".jar [/" + project + "]");
    }

    private void createDynamicWebProject(String project, String targetRuntime) {
        WebProjectWizard ww = new WebProjectWizard();
        ww.open();
        WebProjectFirstPage fp = new WebProjectFirstPage();
        fp.setProjectName(project);
        fp.setTargetRuntime(targetRuntime);
        ww.finish();
    }

    private void createEJBProject(String project, String targetRuntime) {
        EjbProjectWizard ejbw = new EjbProjectWizard();
        ejbw.open();
        EjbProjectFirstPage fp = new EjbProjectFirstPage();
        fp.setProjectName(project);
        fp.setTargetRuntime(targetRuntime);
        ejbw.finish();
    }

    private int countOfArchivesErrors() {
        LogView lv = new LogView();
        lv.open();
        int archivesErrorsCount = 0;
        for (LogMessage msg : lv.getErrorMessages()) {
            String pluginId = msg.getPlugin();
            if (!pluginId.contains("org.jboss.ide.eclipse.archives")) continue;
            System.out.println(msg.getMessage());
            System.out.println(msg.getPlugin());
            System.out.println(msg.getStackTrace());
            ++archivesErrorsCount;
        }
        return archivesErrorsCount;
    }
}

