/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.as.ui.bot.itests.download;

import java.io.File;
import java.io.IOException;
import org.jboss.reddeer.common.condition.WaitCondition;
import org.jboss.reddeer.common.exception.WaitTimeoutExpiredException;
import org.jboss.reddeer.common.logging.Logger;
import org.jboss.reddeer.common.wait.TimePeriod;
import org.jboss.reddeer.common.wait.WaitUntil;
import org.jboss.reddeer.common.wait.WaitWhile;
import org.jboss.reddeer.core.condition.JobIsRunning;
import org.jboss.reddeer.core.condition.ShellWithTextIsAvailable;
import org.jboss.reddeer.jface.preference.PreferencePage;
import org.jboss.reddeer.jface.wizard.WizardDialog;
import org.jboss.reddeer.swt.impl.button.PushButton;
import org.jboss.reddeer.swt.impl.shell.DefaultShell;
import org.jboss.reddeer.workbench.ui.dialogs.WorkbenchPreferenceDialog;
import org.jboss.tools.as.ui.bot.itests.parametized.CleanEnvironmentUtils;
import org.jboss.tools.as.ui.bot.itests.reddeer.util.FileUtils;
import org.jboss.tools.as.ui.bot.itests.reddeer.util.RuntimeDetectionUtility;
import org.jboss.tools.runtime.reddeer.wizard.TaskWizardFirstPage;
import org.jboss.tools.runtime.reddeer.wizard.TaskWizardLoginPage;
import org.jboss.tools.runtime.reddeer.wizard.TaskWizardSecondPage;
import org.jboss.tools.runtime.reddeer.wizard.TaskWizardThirdPage;
import org.junit.Assert;

public final class RuntimeDownloadTestUtility
extends RuntimeDetectionUtility {
    private static final String JBOSS_ORG_USERNAME_PROPERTY_KEY = "jboss.org.username";
    private static final String JBOSS_ORG_PASSWORD_PROPERTY_KEY = "jboss.org.password";
    protected WizardDialog runtimeDownloadWizard;
    private Logger log = new Logger(RuntimeDownloadTestUtility.class);
    private String username = System.getProperty("jboss.org.username");
    private String password = System.getProperty("jboss.org.password");
    private File tmpPath;

    public RuntimeDownloadTestUtility() {
        this(RuntimeDownloadTestUtility.getDefaultDownloadPath());
    }

    public RuntimeDownloadTestUtility(File f) {
        this.tmpPath = f;
        if (!this.tmpPath.exists()) {
            this.tmpPath.mkdir();
        }
    }

    protected static File getDefaultDownloadPath() {
        File tmpDir = new File(System.getProperty("java.io.tmpdir"));
        File f = new File(tmpDir, "tmpServer_" + System.currentTimeMillis());
        return f;
    }

    public void setCredentials(String user, String pass) {
        this.username = user;
        this.password = pass;
    }

    public void setPath(File path) {
        if (this.tmpPath.exists()) {
            try {
                FileUtils.deleteDirectory(this.tmpPath);
            }
            catch (IOException ioe) {
                this.log.debug(ioe.getMessage());
            }
        }
        this.tmpPath = path;
    }

    public void clean() {
        this.clean(true);
    }

    public void clean(boolean delete) {
        if (delete) {
            new WaitUntil((WaitCondition)new SuccesfullyDeleted(this.tmpPath));
        }
        CleanEnvironmentUtils.cleanAll();
    }

    public void invokeDownloadRuntimesWizard() {
        WorkbenchPreferenceDialog preferenceDialog = new WorkbenchPreferenceDialog();
        preferenceDialog.open();
        preferenceDialog.select((PreferencePage)runtimeDetectionPage);
        new PushButton("Download...").click();
        new WaitUntil((WaitCondition)new ShellWithTextIsAvailable("Download Runtimes"), TimePeriod.VERY_LONG);
        new DefaultShell("Download Runtimes");
        this.runtimeDownloadWizard = new WizardDialog();
    }

    public void processSelectingRuntime(String runtime) {
        TaskWizardFirstPage selectRuntimePage = new TaskWizardFirstPage();
        selectRuntimePage.selectRuntime(runtime);
        this.runtimeDownloadWizard.next();
    }

    public void processInsertingCredentials(String username, String password) {
        TaskWizardLoginPage credentialsPage = new TaskWizardLoginPage();
        Assert.assertEquals((String)"Domain is set to jboss.org", (Object)"jboss.org", (Object)credentialsPage.getDomain());
        if (!credentialsPage.containsUsername(username)) {
            credentialsPage.addCredentials(username, password);
        }
        new DefaultShell("Download Runtimes").setFocus();
        credentialsPage.setUsername(username);
        try {
            new WaitWhile((WaitCondition)new JobIsRunning());
        }
        catch (WaitTimeoutExpiredException e) {
            e.printStackTrace();
            throw e;
        }
        this.runtimeDownloadWizard.next();
        new WaitWhile((WaitCondition)new JobIsRunning());
    }

    public void processRuntimeDownload() {
        TaskWizardThirdPage downloadRuntimePage = new TaskWizardThirdPage();
        downloadRuntimePage.setInstallFolder(this.tmpPath.getAbsolutePath());
        new PushButton("Finish").click();
        this.runtimeDownloadWizard = null;
        new WaitUntil((WaitCondition)new JobIsRunning(), TimePeriod.VERY_LONG, false);
        new WaitWhile((WaitCondition)new JobIsRunning(), TimePeriod.getCustom((long)900L));
        runtimeDetectionPage.ok();
    }

    public void processLicenceAgreement() {
        TaskWizardSecondPage licenceAgreementPage = new TaskWizardSecondPage();
        licenceAgreementPage.acceptLicense(true);
        this.runtimeDownloadWizard.next();
    }

    public void downloadRuntimeWithCredentials(String runtime) {
        this.downloadRuntimeWithCredentials(this.getUsername(), this.getPassword(), runtime, 1);
    }

    public String getUsername() {
        if (this.username == null || this.username.length() == 0) {
            Assert.fail((String)"To download product runtime you have to set property \"jboss.org.username\"");
        }
        return this.username;
    }

    public String getPassword() {
        if (this.password == null || this.password.length() == 0) {
            Assert.fail((String)"To download product runtime you have to set property \"jboss.org.password\"");
        }
        return this.password;
    }

    public void downloadRuntimeWithCredentials(String username, String password, String runtime, int serversCount) {
        this.downloadRuntimeWithCredentials(runtime, username, password);
        this.checkRuntimes(serversCount);
    }

    public void downloadRuntimeWithCredentials(String runtime, String username, String password) {
        this.invokeDownloadRuntimesWizard();
        this.processSelectingRuntime(runtime);
        if (username != null && password != null) {
            this.processInsertingCredentials(username, password);
        }
        this.processLicenceAgreement();
        this.processRuntimeDownload();
    }

    public void downloadRuntimeNoCredentials(String runtime) {
        this.downloadRuntimeWithCredentials(runtime, null, null);
    }

    public void downloadAndCheckRuntime(String runtime, int serversCount) {
        this.downloadRuntimeNoCredentials(runtime);
        this.checkRuntimes(serversCount);
    }

    public void checkRuntimes(int serversCount) {
        RuntimeDownloadTestUtility.assertServerRuntimesNumber(serversCount);
    }

    public void downloadAndCheckServer(String server, int serversCount) {
        this.downloadAndCheckRuntime(server, serversCount);
    }

    private class SuccesfullyDeleted
    implements WaitCondition {
        private File dir;

        public SuccesfullyDeleted(File dir) {
            this.dir = dir;
        }

        public boolean test() {
            try {
                RuntimeDownloadTestUtility.this.log.debug("Trying to delete directory: " + this.dir.toString());
                FileUtils.deleteDirectory(this.dir);
            }
            catch (IOException e) {
                RuntimeDownloadTestUtility.this.log.debug("Deletion was unsuccesfull");
                RuntimeDownloadTestUtility.this.log.debug(e.getClass() + ": " + e.getMessage() + ": " + e.getCause() + "\n" + e.getStackTrace().toString());
                return false;
            }
            return true;
        }

        public String description() {
            return null;
        }

        public String errorMessage() {
            return null;
        }
    }
}

