/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.as.ui.bot.itests.parametized;

import java.util.List;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.jboss.reddeer.core.condition.ShellWithTextIsAvailable;
import org.jboss.reddeer.eclipse.wst.server.ui.RuntimePreferencePage;
import org.jboss.reddeer.eclipse.wst.server.ui.view.Server;
import org.jboss.reddeer.eclipse.wst.server.ui.view.ServersView;
import org.jboss.reddeer.jface.preference.PreferencePage;
import org.jboss.reddeer.swt.impl.button.PushButton;
import org.jboss.reddeer.swt.impl.shell.DefaultShell;
import org.jboss.reddeer.workbench.ui.dialogs.WorkbenchPreferenceDialog;
import org.jboss.tools.runtime.core.model.RuntimePath;
import org.jboss.tools.runtime.ui.RuntimeUIActivator;

public class CleanEnvironmentUtils {
    public static void cleanPaths() {
        RuntimePath[] runtimePathArray = RuntimeUIActivator.getDefault().getModel().getRuntimePaths();
        int n = runtimePathArray.length;
        int n2 = 0;
        while (n2 < n) {
            RuntimePath path = runtimePathArray[n2];
            RuntimeUIActivator.getDefault().getModel().removeRuntimePath(path);
            ++n2;
        }
    }

    public static void closeShells() {
        String[] openedShells;
        String[] stringArray = openedShells = new String[]{"Searching for runtimes...", "Preferences"};
        int n = openedShells.length;
        int n2 = 0;
        while (n2 < n) {
            String title = stringArray[n2];
            if (new ShellWithTextIsAvailable(title).test()) {
                new DefaultShell(title);
                new PushButton("Cancel").click();
            }
            ++n2;
        }
    }

    public static void cleanAll() {
        CleanEnvironmentUtils.cleanPaths();
        CleanEnvironmentUtils.cleanServers();
        CleanEnvironmentUtils.cleanServerRuntimes();
        CleanEnvironmentUtils.deleteAllProjects();
    }

    public static void deleteAllProjects() {
        IProject[] all = ResourcesPlugin.getWorkspace().getRoot().getProjects();
        int i = 0;
        while (i < all.length) {
            try {
                all[i].delete(true, (IProgressMonitor)new NullProgressMonitor());
            }
            catch (CoreException e) {
                e.printStackTrace();
            }
            ++i;
        }
    }

    public static void deleteServersAndRuntimes() {
        CleanEnvironmentUtils.cleanServers();
        CleanEnvironmentUtils.cleanServerRuntimes();
    }

    public static void cleanServerRuntimes() {
        WorkbenchPreferenceDialog preferenceDialog = new WorkbenchPreferenceDialog();
        preferenceDialog.open();
        RuntimePreferencePage runtimePage = new RuntimePreferencePage();
        preferenceDialog.select((PreferencePage)runtimePage);
        runtimePage.removeAllRuntimes();
        preferenceDialog.ok();
    }

    public static void cleanServers() {
        ServersView serversView = new ServersView();
        serversView.open();
        List servers = serversView.getServers();
        for (Server server : servers) {
            server.delete();
        }
    }
}

