/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.as.ui.bot.itests.parametized.server;

import java.io.File;
import java.io.IOException;
import java.util.Collection;
import java.util.List;
import junit.framework.TestCase;
import org.eclipse.core.runtime.Path;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.core.Is;
import org.jboss.reddeer.common.condition.WaitCondition;
import org.jboss.reddeer.common.wait.WaitWhile;
import org.jboss.reddeer.core.condition.JobIsRunning;
import org.jboss.reddeer.junit.internal.runner.ParameterizedRequirementsRunnerFactory;
import org.jboss.reddeer.junit.runner.RedDeerSuite;
import org.jboss.reddeer.workbench.ui.dialogs.WorkbenchPreferenceDialog;
import org.jboss.tools.as.ui.bot.itests.Activator;
import org.jboss.tools.as.ui.bot.itests.parametized.CleanEnvironmentUtils;
import org.jboss.tools.as.ui.bot.itests.parametized.MatrixUtils;
import org.jboss.tools.as.ui.bot.itests.parametized.server.PomServerConstants;
import org.jboss.tools.as.ui.bot.itests.reddeer.Runtime;
import org.jboss.tools.as.ui.bot.itests.reddeer.ui.SearchingForRuntimesDialog;
import org.jboss.tools.as.ui.bot.itests.reddeer.util.RuntimeDetectionUtility;
import org.jboss.tools.common.util.FileUtil;
import org.junit.After;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;

@RunWith(value=RedDeerSuite.class)
@Parameterized.UseParametersRunnerFactory(value=ParameterizedRequirementsRunnerFactory.class)
public class RuntimeDetectionDuplicatesTest
extends TestCase {
    private String serverHomeFlag;

    @Parameterized.Parameters
    public static Collection<Object[]> data() {
        String[] homes = PomServerConstants.getJBossHomeFlags();
        return MatrixUtils.toMatrix(new Object[][]{homes});
    }

    public RuntimeDetectionDuplicatesTest(String serverHome) {
        this.serverHomeFlag = serverHome;
    }

    @Test
    public void duplicateRuntimes() {
        RuntimeDetectionDuplicatesTest.assertNotNull((Object)this.serverHomeFlag);
        System.out.println("flag: " + this.serverHomeFlag);
        String home = System.getProperty(this.serverHomeFlag);
        System.out.println("sysprop has value: " + home);
        RuntimeDetectionDuplicatesTest.assertNotNull((Object)home);
        RuntimeDetectionDuplicatesTest.assertTrue((String)(String.valueOf(home) + " should exist"), (boolean)new File(home).exists());
        RuntimeDetectionDuplicatesTest.assertTrue((String)(String.valueOf(home) + " should be a directory"), (boolean)new File(home).isDirectory());
        File tmpDir = Activator.getStateFolder().append("RuntimeDetectionDuplicatesTest").toFile();
        tmpDir.mkdirs();
        File tmpServerPath = new File(tmpDir, "tmpServerCopy_" + System.currentTimeMillis());
        String suffix = new Path(home).lastSegment();
        File tmpServerAPath = new File(tmpServerPath, "serverA/" + suffix);
        File tmpServerBPath = new File(tmpServerPath, "serverB/" + suffix);
        FileUtil.copyDir((File)new File(home), (File)tmpServerAPath, (boolean)true, (boolean)true, (boolean)true);
        FileUtil.copyDir((File)new File(home), (File)tmpServerBPath, (boolean)true, (boolean)true, (boolean)true);
        SearchingForRuntimesDialog searchingForRuntimesDialog = RuntimeDetectionUtility.addPath(tmpServerPath.getAbsolutePath());
        this.assertFoundRuntimesNumber(searchingForRuntimesDialog, 2);
        searchingForRuntimesDialog = RuntimeDetectionUtility.searchFirstPath();
        searchingForRuntimesDialog.ok();
        new WaitWhile((WaitCondition)new JobIsRunning());
        searchingForRuntimesDialog = RuntimeDetectionUtility.searchFirstPath();
        this.assertFoundRuntimesNumber(searchingForRuntimesDialog, 2);
        searchingForRuntimesDialog = RuntimeDetectionUtility.searchFirstPath();
        searchingForRuntimesDialog.hideAlreadyCreatedRuntimes();
        this.assertFoundRuntimesNumber(searchingForRuntimesDialog, 0);
        new WorkbenchPreferenceDialog().ok();
    }

    @After
    public void deleteServers() throws IOException {
        CleanEnvironmentUtils.cleanAll();
    }

    private void assertFoundRuntimesNumber(SearchingForRuntimesDialog dialog, int expected) {
        List<Runtime> runtimes = dialog.getRuntimes();
        dialog.cancel();
        MatcherAssert.assertThat((Object)runtimes.size(), (Matcher)Is.is((Object)expected));
    }
}

