/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.as.ui.bot.itests.reddeer.ui;

import java.util.ArrayList;
import java.util.List;
import org.jboss.reddeer.common.condition.AbstractWaitCondition;
import org.jboss.reddeer.common.condition.WaitCondition;
import org.jboss.reddeer.common.wait.TimePeriod;
import org.jboss.reddeer.common.wait.WaitUntil;
import org.jboss.reddeer.common.wait.WaitWhile;
import org.jboss.reddeer.core.condition.JobIsRunning;
import org.jboss.reddeer.jface.preference.PreferencePage;
import org.jboss.reddeer.swt.api.TableItem;
import org.jboss.reddeer.swt.exception.SWTLayerException;
import org.jboss.reddeer.swt.impl.button.PushButton;
import org.jboss.reddeer.swt.impl.label.DefaultLabel;
import org.jboss.reddeer.swt.impl.shell.DefaultShell;
import org.jboss.reddeer.swt.impl.table.DefaultTable;
import org.jboss.reddeer.workbench.ui.dialogs.WorkbenchPreferenceDialog;
import org.jboss.tools.as.ui.bot.itests.reddeer.ui.SearchingForRuntimesDialog;
import org.junit.Assert;

public class RuntimeDetectionPreferencePage
extends PreferencePage {
    public static final String[] PATH = new String[]{"JBoss Tools", "JBoss Runtime Detection"};

    public RuntimeDetectionPreferencePage() {
        super(PATH);
    }

    public void ok() {
        new WaitWhile((WaitCondition)new JobIsRunning());
        new WorkbenchPreferenceDialog().ok();
    }

    public void removeAllPaths() {
        DefaultTable table = new DefaultTable();
        int pathsNumber = table.rowCount();
        int i = 0;
        while (i < pathsNumber) {
            table.select(new int[]{0});
            PushButton removeButton = new PushButton("Remove");
            Assert.assertTrue((String)"Remove button is not enabled", (boolean)removeButton.isEnabled());
            removeButton.click();
            ++i;
        }
    }

    public List<String> getAllPaths() {
        DefaultTable table = new DefaultTable();
        ArrayList<String> paths = new ArrayList<String>();
        for (TableItem ti : table.getItems()) {
            paths.add(ti.getText(0));
        }
        return paths;
    }

    public SearchingForRuntimesDialog search() {
        new PushButton("Search...").click();
        new DefaultShell("Searching for runtimes...");
        new WaitUntil((WaitCondition)new RuntimeSearchedFinished(), TimePeriod.LONG);
        return new SearchingForRuntimesDialog();
    }

    private static class RuntimeSearchedFinished
    extends AbstractWaitCondition {
        private RuntimeSearchedFinished() {
        }

        public boolean test() {
            try {
                new DefaultLabel("Searching runtimes is finished.");
                return true;
            }
            catch (SWTLayerException sWTLayerException) {
                return false;
            }
        }

        public String description() {
            return "The runtime search has not finished in the specified amount of time";
        }
    }
}

