/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.as.ui.bot.itests.reddeer.ui;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import org.eclipse.swt.widgets.Tree;
import org.eclipse.swt.widgets.TreeColumn;
import org.jboss.reddeer.common.condition.WaitCondition;
import org.jboss.reddeer.common.wait.WaitWhile;
import org.jboss.reddeer.core.condition.ShellWithTextIsActive;
import org.jboss.reddeer.core.util.Display;
import org.jboss.reddeer.core.util.ResultRunnable;
import org.jboss.reddeer.swt.api.TreeItem;
import org.jboss.reddeer.swt.impl.button.CheckBox;
import org.jboss.reddeer.swt.impl.button.PushButton;
import org.jboss.reddeer.swt.impl.shell.DefaultShell;
import org.jboss.reddeer.swt.impl.tree.DefaultTree;
import org.jboss.tools.as.ui.bot.itests.reddeer.Runtime;

public class SearchingForRuntimesDialog
extends DefaultShell {
    public static final String DIALOG_TITLE = "Searching for runtimes...";
    private Map<String, Integer> columnsNames = (Map)Display.syncExec((ResultRunnable)new ResultRunnable<Map<String, Integer>>(){

        public Map<String, Integer> run() {
            TreeMap<String, Integer> columnsNames = new TreeMap<String, Integer>();
            Tree tree = (Tree)new DefaultTree().getSWTWidget();
            TreeColumn[] columns = tree.getColumns();
            int i = 0;
            while (i < columns.length) {
                columnsNames.put(columns[i].getText(), i);
                ++i;
            }
            return columnsNames;
        }
    });

    public SearchingForRuntimesDialog() {
        super(DIALOG_TITLE);
    }

    private String getText(TreeItem row, String columnName) {
        int columnIndex = this.columnsNames.get(columnName);
        return row.getCell(columnIndex);
    }

    public List<Runtime> getRuntimes() {
        ArrayList<Runtime> runtimes = new ArrayList<Runtime>();
        for (TreeItem treeItem : this.getRuntimesTreeItems()) {
            Runtime runtime = new Runtime();
            runtime.setName(this.getText(treeItem, "Name"));
            runtime.setVersion(this.getText(treeItem, "Version"));
            runtime.setType(this.getText(treeItem, "Type"));
            runtime.setLocation(this.getText(treeItem, "Location"));
            runtimes.add(runtime);
        }
        return runtimes;
    }

    public void ok() {
        DefaultShell shell = new DefaultShell();
        String title = shell.getText();
        new PushButton("OK").click();
        new WaitWhile((WaitCondition)new ShellWithTextIsActive(title));
    }

    public void cancel() {
        new PushButton("Cancel").click();
    }

    public void hideAlreadyCreatedRuntimes() {
        new CheckBox("Hide already created runtimes").toggle(true);
    }

    public void deselect(String runtimeName) {
        for (TreeItem treeItem : this.getRuntimesTreeItems()) {
            if (!treeItem.getCell(0).equals(runtimeName)) continue;
            treeItem.setChecked(false);
        }
    }

    private List<TreeItem> getRuntimesTreeItems() {
        return new DefaultTree().getAllItems();
    }
}

