/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.as.ui.bot.itests.reddeer.util;

import org.jboss.reddeer.common.condition.AbstractWaitCondition;
import org.jboss.reddeer.common.wait.AbstractWait;
import org.jboss.reddeer.common.wait.TimePeriod;
import org.jboss.reddeer.eclipse.ui.browser.BrowserView;

public class BrowserContainsTextCondition
extends AbstractWaitCondition {
    private String text;
    private boolean refresh;
    private BrowserView browserView;

    public BrowserContainsTextCondition(String text) {
        this(text, false);
    }

    public BrowserContainsTextCondition(String text, boolean refresh) {
        this(null, text, refresh);
    }

    public BrowserContainsTextCondition(String url, String text, boolean refresh) {
        this.text = text;
        this.refresh = refresh;
        this.browserView = new BrowserView();
        this.browserView.open();
        AbstractWait.sleep((TimePeriod)TimePeriod.NORMAL);
        if (url != null) {
            this.browserView.openPageURL(url);
        }
    }

    public boolean test() {
        if (this.refresh) {
            this.browserView.refreshPage();
        }
        return this.browserView.getText().contains(this.text);
    }

    public void cleanup() {
        if (this.browserView != null) {
            this.browserView.close();
        }
    }

    public String description() {
        return "Browser should contain text: " + this.text + ", but contains: " + this.browserView.getText();
    }
}

